/**
 *  FontGenerator7Pixel
 *  Original Font Created By Marc Nause, 05.04.2007
 *  (name was FontGenerator8Pixel)
 *  based on FontGenerator5Pixel.java
 *  Copyright 2005 by Michael Christen
 *  First released 31.10.2005 at https://yacy.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *  
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *  
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program in the file lgpl21.txt
 *  If not, see <http://www.gnu.org/licenses/>.
 */

package net.yacy.visualization;

public class FontGenerator7Pixel { 

    /**
     * font: a character matrix of 96 characters:
     * 
     *  0x20: !"#$%&'
     *  0x28:()*+,-./
     *  0x30:01234567
     *  0x38:89:;<=>?
     *  0x40:@ABCDEFG
     *  0x48:HIJKLMNO
     *  0x50:PQRSTUVW
     *  0x58:XYZ[\]^_
     *  0x60:`abcdefg
     *  0x68:hijklmno
     *  0x70:pqrstuvw
     *  0x78:xyz{|}~
     */
    public static final String[] font = {
        ".......", "...X...", "..X.X..", "..X.X..", "...X...", "XX....X", ".XX....", "...X...", 
        ".......", "...X...", "..X.X..", "..X.X..", ".XXXXXX", "XX...X.", "X..X...", "...X...", 
        ".......", "...X...", ".......", "XXXXXXX", "X..X...", "....X..", ".XX....", ".......", 
        ".......", "...X...", ".......", "..X.X..", ".XXXXX.", "...X...", "..X...X", ".......", 
        ".......", "...X...", ".......", "XXXXXXX", "...X..X", "..X....", "X..X.X.", ".......", 
        ".......", ".......", ".......", "..X.X..", "XXXXXX.", ".X...XX", "X...X..", ".......", 
        ".......", "...X...", ".......", "..X.X..", "...X...", "X....XX", ".XXX..X", ".......", 
        ".......", ".......", ".......", ".......", ".......", ".......", ".......", ".......", 

        "....X..", "...X...", "...X...", ".......", ".......", ".......", ".......", "......X", 
        "...X...", "....X..", ".X.X.X.", "...X...", ".......", ".......", ".......", ".....X.", 
        "..X....", ".....X.", "..XXX..", "...X...", ".......", ".......", ".......", "....X..", 
        "..X....", ".....X.", "XXXXXXX", ".XXXXX.", ".......", ".XXXXX.", ".......", "...X...", 
        "..X....", ".....X.", "..XXX..", "...X...", ".......", ".......", ".......", "..X....", 
        "...X...", "....X..", ".X..X.X", "...X...", "...XX..", ".......", "...XX..", ".X.....", 
        "....X..", "...X...", "...X...", ".......", "...XX..", ".......", "...XX..", "X......", 
        ".......", ".......", ".......", ".......", "....X..", ".......", ".......", ".......", 

        ".XXXXX.", "...X...", ".XXXX..", ".XXXXX.", ".....X.", ".XXXXXX", ".XXXX..", ".XXXXX.", 
        "X....XX", "..XX...", "X....X.", "X.....X", "....XX.", ".X.....", "X....X.", ".....X.", 
        "X...X.X", ".X.X...", ".....X.", "......X", "...X.X.", ".X.....", "X......", ".....X.", 
        "X..X..X", "...X...", "...XX..", "...XXX.", "..X..X.", ".XXXXX.", "XXXXX..", "....X..", 
        "X.X...X", "...X...", "..X....", "......X", ".XXXXXX", "......X", "X....X.", "...X...", 
        "XX....X", "...X...", ".X.....", "X.....X", ".....X.", "......X", "X....X.", "...X...", 
        ".XXXXX.", ".XXXXX.", "XXXXXX.", ".XXXXX.", ".....X.", ".XXXXX.", ".XXXX..", "...X...", 
        ".......", ".......", ".......", ".......", ".......", ".......", ".......", ".......", 

        "..XXX..", "..XXX..", ".......", ".......", ".....XX", ".......", "XX.....", "..XXX..", 
        ".X...X.", ".X...X.", ".......", ".......", "...XX..", ".......", "..XX...", ".X...X.", 
        ".X...X.", ".X...X.", "...X...", "...X...", ".XX....", "..XXXX.", "....XX.", ".....X.", 
        "..XXX..", "..XXXX.", "...X...", "...X...", "X......", ".......", "......X", "....X..", 
        ".X...X.", ".....X.", ".......", ".......", ".XX....", "..XXXX.", "....XX.", "...X...", 
        ".X...X.", ".X...X.", "...X...", "...X...", "...XX..", ".......", "..XX...", ".......", 
        "..XXX..", "..XXX..", "...X...", "...X...", ".....XX", ".......", "XX.....", "...X...", 
        ".......", ".......", ".......", "..X....", ".......", ".......", "........", ".......", 

        ".XXXXX.", ".XXXXX.", "XXXXXX.", "..XXXX.", "XXXXX..", "XXXXXXX", "XXXXXXX", ".XXXXX.", 
        "X.....X", "X.....X", "X.....X", ".X....X", "X....X.", "X......", "X......", "X......", 
        "X...XXX", "X.....X", "X.....X", "X......", "X.....X", "X......", "X......", "X......", 
        "X..X..X", "XXXXXXX", "XXXXXX.", "X......", "X.....X", "XXXXXX.", "XXXXXX.", "X..XXXX", 
        "X...XXX", "X.....X", "X.....X", "X......", "X.....X", "X......", "X......", "X.....X", 
        "X......", "X.....X", "X.....X", ".X....X", "X....X.", "X......", "X......", "X.....X", 
        ".XXXXXX", "X.....X", "XXXXXX.", "..XXXX.", "XXXXX..", "XXXXXXX", "X......", ".XXXXX.", 
        ".......", ".......", ".......", ".......", ".......", ".......", ".......", ".......", 

        "X.....X", "..XXX..", "...XXX.", "X....XX", "X......", "X.....X", "X.....X", ".XXXXX.", 
        "X.....X", "...X...", "....X..", "X...XX.", "X......", "XX...XX", "XX....X", "X.....X", 
        "X.....X", "...X...", "....X..", "X..XX..", "X......", "X.X.X.X", "X.X...X", "X.....X", 
        "XXXXXXX", "...X...", "....X..", "XXX....", "X......", "X..X..X", "X..X..X", "X.....X", 
        "X.....X", "...X...", "....X..", "X..XX..", "X......", "X.....X", "X...X.X", "X.....X", 
        "X.....X", "...X...", "X...X..", "X...XX.", "X......", "X.....X", "X....XX", "X.....X", 
        "X.....X", "..XXX..", ".XXX...", "X....XX", "XXXXXXX", "X.....X", "X.....X", ".XXXXX.", 
        ".......", ".......", ".......", ".......", ".......", ".......", ".......", ".......", 

        "XXXXXX.", ".XXXXX.", "XXXXXX.", ".XXXXX.", "XXXXXXX", "X.....X", "X.....X", "X.....X", 
        "X.....X", "X.....X", "X.....X", "X.....X", "...X...", "X.....X", "X.....X", "X.....X", 
        "X.....X", "X.....X", "X.....X", "X......", "...X...", "X.....X", "X.....X", "X.....X", 
        "XXXXXX.", "X.....X", "XXXXXX.", ".XXXXX.", "...X...", "X.....X", "X.....X", "X.....X", 
        "X......", "X.....X", "X...X..", "......X", "...X...", "X.....X", ".X...X.", "X..X..X", 
        "X......", "X...X.X", "X....X.", "X.....X", "...X...", "X.....X", "..X.X..", "X.X.X.X", 
        "X......", ".XXXXX.", "X.....X", ".XXXXX.", "...X...", ".XXXXX.", "...X...", ".X...X.", 
        ".......", "......X", ".......", ".......", ".......", ".......", ".......", ".......", 

        "X.....X", "X.....X", "XXXXXXX", "..XXXX.", "X......", "..XXXX.", "...X...", ".......", 
        ".X...X.", ".X...X.", ".....X.", "..X....", ".X.....", ".....X.", "..X.X..", ".......", 
        "..X.X..", "..X.X..", "....X..", "..X....", "..X....", ".....X.", ".X...X.", ".......", 
        "...X...", "...X...", "...X...", "..X....", "...X...", ".....X.", ".......", ".......", 
        "..X.X..", "...X...", "..X....", "..X....", "....X..", ".....X.", ".......", ".......", 
        ".X...X.", "...X...", ".X.....", "..X....", ".....X.", ".....X.", ".......", ".......", 
        "X.....X", "...X...", "XXXXXXX", "..XXXX.", "......X", "..XXXX.", ".......", "XXXXXXX", 
        ".......", ".......", ".......", ".......", ".......", ".......", ".......", ".......", 

        "...X...", ".......", ".......", ".......", ".......", ".......", "...XX..", ".......", 
        "....X..", ".......", "X......", ".......", "......X", ".......", "..X....", ".......", 
        ".......", ".XXXX..", "X......", ".XXXXXX", "......X", ".XXXXX.", "..X....", ".XXXXX.", 
        ".......", ".....X.", "XXXXXX.", "X......", ".XXXXXX", "X.....X", ".XXX...", "X.....X", 
        ".......", ".XXXXX.", "X.....X", "X......", "X.....X", "XXXXXXX", "..X....", "X.....X", 
        ".......", "X....X.", "X.....X", "X......", "X.....X", "X......", "..X....", ".XXXXXX", 
        ".......", ".XXXX.X", "XXXXXX.", ".XXXXXX", ".XXXXXX", ".XXXXX.", "..X....", "......X", 
        ".......", ".......", ".......", ".......", ".......", ".......", ".......", ".XXXXX.", 

        ".......", ".......", ".......", ".......", ".......", ".......", ".......", ".......", 
        "X......", "...X...", "....X..", "X......", "..XX...", ".......", ".......", ".......", 
        "X......", ".......", ".......", "X....XX", "...X...", ".XX.XX.", ".XXXXX.", ".XXXXX.", 
        "XXXXXX.", "..XX...", "...XX..", "X..XX..", "...X...", "X..X..X", "X.....X", "X.....X", 
        "X.....X", "...X...", "....X..", "XXX....", "...X...", "X..X..X", "X.....X", "X.....X", 
        "X.....X", "...X...", "....X..", "X..XX..", "...X...", "X..X..X", "X.....X", "X.....X", 
        "X.....X", "..XXX..", "....X..", "X....XX", "..XXX..", "X..X..X", "X.....X", ".XXXXX.", 
        ".......", ".......", "..XX...", ".......", ".......", ".......", ".......", ".......", 

        ".......", ".......", ".......", ".......", ".......", ".......", ".......", ".......", 
        ".......", ".......", ".......", ".......", "...X...", ".......", ".......", ".......", 
        "XXXXXX.", ".XXXXXX", "X.XXXX.", ".XXXXX.", "...X...", "X.....X", "X.....X", "X.....X", 
        "X.....X", "X.....X", "XX....X", "X......", ".XXXXX.", "X.....X", "X.....X", "X.....X", 
        "X.....X", "X.....X", "X......", ".XXXXX.", "...X...", "X.....X", ".X...X.", "X..X..X", 
        "XXXXXX.", ".XXXXXX", "X......", "......X", "...X...", "X.....X", "..X.X..", "X.X.X.X", 
        "X......", "......X", "X......", ".XXXXX.", "....XX.", ".XXXXX.", "...X...", ".X...X.", 
        "X......", "......X", ".......", ".......", ".......", ".......", ".......", ".......", 

        ".......", ".......", ".......", "...XX..", "...X...", "..XX...", ".......", "XXXXXXX", 
        ".......", ".......", ".......", "..X....", "...X...", "....X..", ".......", "X.....X", 
        "X.....X", "X.....X", "XXXXXXX", "..X....", "...X...", "....X..", "..X....", "X.....X", 
        ".XX.XX.", "X.....X", "....XX.", "XX.....", "...X...", ".....XX", ".X.XX.X", "X.....X", 
        "...X...", "X.....X", "...X...", "..X....", "...X...", "....X..", ".....X.", "X.....X", 
        ".XX.XX.", ".XXXXXX", ".XX....", "..X....", "...X...", "....X..", ".......", "X.....X", 
        "X.....X", "......X", "XXXXXXX", "...XX..", "...X...", "..XX...", ".......", "XXXXXXX", 
        ".......", ".XXXXX.", ".......", ".......", "...X...", ".......", ".......", "......."
    };
    

    public static void fontConverter(final String[] font) {

        final int matrix_width = 8;
        final int matrix_height = 12;
        final int font_width = 7;
        final int font_height = 8;
        
        for (int matrix_y = 0; matrix_y < matrix_height; matrix_y++) {
            for (int matrix_x = 0; matrix_x < matrix_width; matrix_x++) {
                int start = (matrix_y * matrix_width * font_height) + matrix_x;
                long b = 0;
                for (int row = 0; row < font_height; row++) {
                    b = b << font_width;
                    long v = 1 << (font_width - 1);
                    for (int col = 0; col < font_width; col++) {
                        if (font[start + matrix_width * row].charAt(col) == 'X')  b += v;
                        v = v >> 1;
                    }
                }
                String s = Long.toHexString(b).toUpperCase();
                while (s.length() < 14) s = "0" + s;
                System.out.print("0x" + s + "L,");
            }
            System.out.println();
        }
        
    } 
    
    public static void main(final String[] args) {
        fontConverter(font);        
    } 

} 
