/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene90;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.RandomAccessVectorValuesProducer;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.index.VectorValues;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.hnsw.HnswGraph;
import org.apache.lucene.util.hnsw.HnswGraphBuilder;
import org.apache.lucene.util.hnsw.NeighborArray;

public final class Lucene90HnswVectorsWriter
extends KnnVectorsWriter {
    private final SegmentWriteState segmentWriteState;
    private final IndexOutput meta;
    private final IndexOutput vectorData;
    private final IndexOutput vectorIndex;
    private final int maxConn;
    private final int beamWidth;
    private boolean finished;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Lucene90HnswVectorsWriter(SegmentWriteState state, int maxConn, int beamWidth) throws IOException {
        this.maxConn = maxConn;
        this.beamWidth = beamWidth;
        assert (state.fieldInfos.hasVectorValues());
        this.segmentWriteState = state;
        String metaFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "vem");
        String vectorDataFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "vec");
        String indexDataFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "vex");
        boolean success = false;
        try {
            this.meta = state.directory.createOutput(metaFileName, state.context);
            this.vectorData = state.directory.createOutput(vectorDataFileName, state.context);
            this.vectorIndex = state.directory.createOutput(indexDataFileName, state.context);
            CodecUtil.writeIndexHeader(this.meta, "Lucene90HnswVectorsFormatMeta", 0, state.segmentInfo.getId(), state.segmentSuffix);
            CodecUtil.writeIndexHeader(this.vectorData, "Lucene90HnswVectorsFormatData", 0, state.segmentInfo.getId(), state.segmentSuffix);
            CodecUtil.writeIndexHeader(this.vectorIndex, "Lucene90HnswVectorsFormatIndex", 0, state.segmentInfo.getId(), state.segmentSuffix);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
    }

    @Override
    public void writeField(FieldInfo fieldInfo, VectorValues vectors) throws IOException {
        long pos = this.vectorData.getFilePointer();
        long padding = 4L - (pos & 3L) & 3L;
        long vectorDataOffset = pos + padding;
        int i = 0;
        while ((long)i < padding) {
            this.vectorData.writeByte((byte)0);
            ++i;
        }
        int[] docIds = new int[vectors.size()];
        int count = 0;
        int docV = vectors.nextDoc();
        while (docV != Integer.MAX_VALUE) {
            this.writeVectorValue(vectors);
            docIds[count] = docV;
            docV = vectors.nextDoc();
            ++count;
        }
        long[] offsets = new long[count];
        long vectorDataLength = this.vectorData.getFilePointer() - vectorDataOffset;
        long vectorIndexOffset = this.vectorIndex.getFilePointer();
        if (!(vectors instanceof RandomAccessVectorValuesProducer)) {
            throw new IllegalArgumentException("Indexing an HNSW graph requires a random access vector values, got " + vectors);
        }
        this.writeGraph(this.vectorIndex, (RandomAccessVectorValuesProducer)((Object)vectors), fieldInfo.getVectorSimilarityFunction(), vectorIndexOffset, offsets, count, this.maxConn, this.beamWidth);
        long vectorIndexLength = this.vectorIndex.getFilePointer() - vectorIndexOffset;
        this.writeMeta(fieldInfo, vectorDataOffset, vectorDataLength, vectorIndexOffset, vectorIndexLength, count, docIds);
        this.writeGraphOffsets(this.meta, offsets);
    }

    private void writeMeta(FieldInfo field, long vectorDataOffset, long vectorDataLength, long indexDataOffset, long indexDataLength, int size, int[] docIds) throws IOException {
        this.meta.writeInt(field.number);
        this.meta.writeInt(field.getVectorSimilarityFunction().ordinal());
        this.meta.writeVLong(vectorDataOffset);
        this.meta.writeVLong(vectorDataLength);
        this.meta.writeVLong(indexDataOffset);
        this.meta.writeVLong(indexDataLength);
        this.meta.writeInt(field.getVectorDimension());
        this.meta.writeInt(size);
        for (int i = 0; i < size; ++i) {
            this.meta.writeVInt(docIds[i]);
        }
    }

    private void writeVectorValue(VectorValues vectors) throws IOException {
        BytesRef binaryValue = vectors.binaryValue();
        assert (binaryValue.length == vectors.dimension() * 4);
        this.vectorData.writeBytes(binaryValue.bytes, binaryValue.offset, binaryValue.length);
    }

    private void writeGraphOffsets(IndexOutput out, long[] offsets) throws IOException {
        long last = 0L;
        for (long offset : offsets) {
            out.writeVLong(offset - last);
            last = offset;
        }
    }

    private void writeGraph(IndexOutput graphData, RandomAccessVectorValuesProducer vectorValues, VectorSimilarityFunction similarityFunction, long graphDataOffset, long[] offsets, int count, int maxConn, int beamWidth) throws IOException {
        HnswGraphBuilder hnswGraphBuilder = new HnswGraphBuilder(vectorValues, similarityFunction, maxConn, beamWidth, HnswGraphBuilder.randSeed);
        hnswGraphBuilder.setInfoStream(this.segmentWriteState.infoStream);
        HnswGraph graph = hnswGraphBuilder.build(vectorValues.randomAccess());
        for (int ord = 0; ord < count; ++ord) {
            offsets[ord] = graphData.getFilePointer() - graphDataOffset;
            NeighborArray neighbors = graph.getNeighbors(ord);
            int size = neighbors.size();
            int[] nodes = neighbors.node();
            Arrays.sort(nodes, 0, size);
            graphData.writeInt(size);
            int lastNode = -1;
            for (int i = 0; i < size; ++i) {
                int node = nodes[i];
                assert (node > lastNode) : "nodes out of order: " + lastNode + "," + node;
                assert (node < offsets.length) : "node too large: " + node + ">=" + offsets.length;
                graphData.writeVInt(node - lastNode);
                lastNode = node;
            }
        }
    }

    @Override
    public void finish() throws IOException {
        if (this.finished) {
            throw new IllegalStateException("already finished");
        }
        this.finished = true;
        if (this.meta != null) {
            this.meta.writeInt(-1);
            CodecUtil.writeFooter(this.meta);
        }
        if (this.vectorData != null) {
            CodecUtil.writeFooter(this.vectorData);
            CodecUtil.writeFooter(this.vectorIndex);
        }
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.meta, this.vectorData, this.vectorIndex);
    }
}

