/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.SolrException;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.facet.AggUtil;
import org.apache.solr.search.facet.DocValuesAcc;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetMerger;
import org.apache.solr.search.facet.FacetModule;
import org.apache.solr.search.facet.SimpleAggValueSource;
import org.apache.solr.search.facet.SlotAcc;
import org.apache.solr.search.facet.UnInvertedFieldAcc;
import org.apache.solr.search.function.FieldNameValueSource;

public class AvgAgg
extends SimpleAggValueSource {
    public AvgAgg(ValueSource vs) {
        super("avg", vs);
    }

    @Override
    public SlotAcc createSlotAcc(FacetContext fcontext, long numDocs, int numSlots) throws IOException {
        ValueSource vs = this.getArg();
        if (vs instanceof FieldNameValueSource) {
            String field = ((FieldNameValueSource)vs).getFieldName();
            SchemaField sf = fcontext.qcontext.searcher().getSchema().getField(field);
            if (sf.getType().getNumberType() == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, this.name() + " aggregation not supported for " + sf.getType().getTypeName());
            }
            if (sf.multiValued() || sf.getType().multiValuedFieldCache()) {
                if (sf.hasDocValues()) {
                    if (sf.getType().isPointField()) {
                        return new AvgSortedNumericAcc(fcontext, sf, numSlots);
                    }
                    return new AvgSortedSetAcc(fcontext, sf, numSlots);
                }
                if (sf.getType().isPointField()) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, this.name() + " aggregation not supported for PointField w/o docValues");
                }
                return new AvgUnInvertedFieldAcc(fcontext, sf, numSlots);
            }
            vs = sf.getType().getValueSource(sf, null);
        }
        return new SlotAcc.AvgSlotAcc(vs, fcontext, numSlots);
    }

    @Override
    public FacetMerger createFacetMerger(Object prototype) {
        return new Merger();
    }

    class AvgUnInvertedFieldAcc
    extends UnInvertedFieldAcc.DoubleUnInvertedFieldAcc {
        int[] counts;

        public AvgUnInvertedFieldAcc(FacetContext fcontext, SchemaField sf, int numSlots) throws IOException {
            super(fcontext, sf, numSlots, 0.0);
            this.counts = new int[numSlots];
        }

        @Override
        public void call(int termNum) {
            try {
                BytesRef term = this.docToTerm.lookupOrd(termNum);
                Object obj = this.sf.getType().toObject(this.sf, term);
                double val = obj instanceof Date ? (double)((Date)obj).getTime() : ((Number)obj).doubleValue();
                int n = this.currentSlot;
                this.result[n] = this.result[n] + val;
                int n2 = this.currentSlot;
                this.counts[n2] = this.counts[n2] + 1;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        private double avg(int slot) {
            return AggUtil.avg(this.result[slot], this.counts[slot]);
        }

        @Override
        public int compare(int slotA, int slotB) {
            return Double.compare(this.avg(slotA), this.avg(slotB));
        }

        @Override
        public Object getValue(int slot) {
            if (this.fcontext.isShard()) {
                ArrayList<Number> lst = new ArrayList<Number>(2);
                lst.add(this.counts[slot]);
                lst.add(this.result[slot]);
                return lst;
            }
            return this.avg(slot);
        }

        @Override
        public void reset() throws IOException {
            super.reset();
            Arrays.fill(this.counts, 0);
        }

        @Override
        public void resize(SlotAcc.Resizer resizer) {
            super.resize(resizer);
            this.counts = resizer.resize(this.counts, 0);
        }
    }

    class AvgSortedSetAcc
    extends DocValuesAcc.DoubleSortedSetDVAcc {
        int[] counts;

        public AvgSortedSetAcc(FacetContext fcontext, SchemaField sf, int numSlots) throws IOException {
            super(fcontext, sf, numSlots, 0L);
            this.counts = new int[numSlots];
        }

        @Override
        protected void collectValues(int doc, int slot) throws IOException {
            long ord;
            while ((ord = this.values.nextOrd()) != -1L) {
                BytesRef term = this.values.lookupOrd(ord);
                Object obj = this.sf.getType().toObject(this.sf, term);
                double val = obj instanceof Date ? (double)((Date)obj).getTime() : ((Number)obj).doubleValue();
                int n = slot;
                this.result[n] = this.result[n] + val;
                int n2 = slot;
                this.counts[n2] = this.counts[n2] + 1;
            }
        }

        private double avg(int slot) {
            return AggUtil.avg(this.result[slot], this.counts[slot]);
        }

        @Override
        public int compare(int slotA, int slotB) {
            return Double.compare(this.avg(slotA), this.avg(slotB));
        }

        @Override
        public Object getValue(int slot) {
            if (this.fcontext.isShard()) {
                ArrayList<Number> lst = new ArrayList<Number>(2);
                lst.add(this.counts[slot]);
                lst.add(this.result[slot]);
                return lst;
            }
            return this.avg(slot);
        }

        @Override
        public void reset() throws IOException {
            super.reset();
            Arrays.fill(this.counts, 0);
        }

        @Override
        public void resize(SlotAcc.Resizer resizer) {
            super.resize(resizer);
            this.counts = resizer.resize(this.counts, 0);
        }
    }

    class AvgSortedNumericAcc
    extends DocValuesAcc.DoubleSortedNumericDVAcc {
        int[] counts;

        public AvgSortedNumericAcc(FacetContext fcontext, SchemaField sf, int numSlots) throws IOException {
            super(fcontext, sf, numSlots, 0.0);
            this.counts = new int[numSlots];
        }

        @Override
        protected void collectValues(int doc, int slot) throws IOException {
            int count = this.values.docValueCount();
            for (int i = 0; i < count; ++i) {
                int n = slot;
                this.result[n] = this.result[n] + this.getDouble(this.values.nextValue());
                int n2 = slot;
                this.counts[n2] = this.counts[n2] + 1;
            }
        }

        private double avg(int slot) {
            return AggUtil.avg(this.result[slot], this.counts[slot]);
        }

        @Override
        public int compare(int slotA, int slotB) {
            return Double.compare(this.avg(slotA), this.avg(slotB));
        }

        @Override
        public Object getValue(int slot) {
            if (this.fcontext.isShard()) {
                ArrayList<Number> lst = new ArrayList<Number>(2);
                lst.add(this.counts[slot]);
                lst.add(this.result[slot]);
                return lst;
            }
            return this.avg(slot);
        }

        @Override
        public void reset() throws IOException {
            super.reset();
            Arrays.fill(this.counts, 0);
        }

        @Override
        public void resize(SlotAcc.Resizer resizer) {
            super.resize(resizer);
            this.counts = resizer.resize(this.counts, 0);
        }
    }

    private static class Merger
    extends FacetModule.FacetDoubleMerger {
        long num;
        double sum;

        private Merger() {
        }

        @Override
        public void merge(Object facetResult, FacetMerger.Context mcontext1) {
            List numberList = (List)facetResult;
            this.num += ((Number)numberList.get(0)).longValue();
            this.sum += ((Number)numberList.get(1)).doubleValue();
        }

        @Override
        protected double getDouble() {
            return AggUtil.avg(this.sum, this.num);
        }
    }
}

