/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.export;

import com.carrotsearch.hppc.IntObjectHashMap;
import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.solr.common.MapWriter;
import org.apache.solr.handler.export.FieldWriter;
import org.apache.solr.handler.export.SortDoc;
import org.apache.solr.handler.export.SortValue;

class FloatFieldWriter
extends FieldWriter {
    private String field;
    private IntObjectHashMap<NumericDocValues> docValuesCache = new IntObjectHashMap();

    public FloatFieldWriter(String field) {
        this.field = field;
    }

    @Override
    public boolean write(SortDoc sortDoc, LeafReaderContext readerContext, MapWriter.EntryWriter ew, int fieldIndex) throws IOException {
        NumericDocValues numericDocValues;
        SortValue sortValue = sortDoc.getSortValue(this.field);
        if (sortValue != null) {
            if (sortValue.isPresent()) {
                float val = ((Float)sortValue.getCurrentValue()).floatValue();
                ew.put((CharSequence)this.field, val);
                return true;
            }
            return false;
        }
        int readerOrd = readerContext.ord;
        NumericDocValues vals = null;
        if (this.docValuesCache.containsKey(readerOrd) && (numericDocValues = (NumericDocValues)this.docValuesCache.get(readerOrd)).docID() < sortDoc.docId) {
            vals = numericDocValues;
        }
        if (vals == null) {
            vals = DocValues.getNumeric((LeafReader)readerContext.reader(), (String)this.field);
            this.docValuesCache.put(readerOrd, (Object)vals);
        }
        if (vals.advance(sortDoc.docId) == sortDoc.docId) {
            int val = (int)vals.longValue();
            ew.put((CharSequence)this.field, Float.intBitsToFloat(val));
            return true;
        }
        return false;
    }
}

