/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.BaseHttpSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.cloud.DistributedClusterStateUpdater;
import org.apache.solr.cloud.api.collections.AddReplicaCmd;
import org.apache.solr.cloud.api.collections.CollectionCommandContext;
import org.apache.solr.cloud.api.collections.DeleteBackupCmd;
import org.apache.solr.cloud.api.collections.DeleteCollectionCmd;
import org.apache.solr.cloud.overseer.ClusterStateMutator;
import org.apache.solr.cloud.overseer.OverseerAction;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.TimeSource;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.ConfigSetService;
import org.apache.solr.core.backup.BackupId;
import org.apache.solr.core.backup.repository.BackupRepository;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardHandlerFactory;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionHandlingUtils {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String NUM_SLICES = "numShards";
    public static final boolean CREATE_NODE_SET_SHUFFLE_DEFAULT = true;
    public static final String CREATE_NODE_SET_SHUFFLE = "createNodeSet.shuffle";
    public static final String CREATE_NODE_SET_EMPTY = "EMPTY";
    public static final String CREATE_NODE_SET = "createNodeSet";
    public static final String ROUTER = "router";
    public static final String SHARDS_PROP = "shards";
    public static final String REQUESTID = "requestid";
    public static final String ONLY_IF_DOWN = "onlyIfDown";
    public static final String SHARD_UNIQUE = "shardUnique";
    public static final String ONLY_ACTIVE_NODES = "onlyactivenodes";
    static final String SKIP_CREATE_REPLICA_IN_CLUSTER_STATE = "skipCreateReplicaInClusterState";
    public static final Map<String, Object> COLLECTION_PROPS_AND_DEFAULTS = Collections.unmodifiableMap(Utils.makeMap((String[])new String[]{"router", "compositeId", "replicationFactor", "1", "nrtReplicas", "1", "tlogReplicas", "0", "perReplicaState", null, "pullReplicas", "0"}));
    public static final Random RANDOM;

    static boolean waitForCoreNodeGone(String collectionName, String shard, String replicaName, int timeoutms, ZkStateReader zkStateReader) throws InterruptedException {
        try {
            zkStateReader.waitForState(collectionName, (long)timeoutms, TimeUnit.MILLISECONDS, c -> {
                if (c == null) {
                    return true;
                }
                Slice slice = c.getSlice(shard);
                return slice == null || slice.getReplica(replicaName) == null;
            });
        }
        catch (TimeoutException e) {
            return false;
        }
        return true;
    }

    static void deleteCoreNode(String collectionName, String replicaName, Replica replica, String core, CollectionCommandContext ccc) throws Exception {
        ZkNodeProps m = new ZkNodeProps(new String[]{"operation", OverseerAction.DELETECORE.toLower(), "core", core, "node_name", replica.getNodeName(), "collection", collectionName, "core_node_name", replicaName});
        if (ccc.getDistributedClusterStateUpdater().isDistributedStateUpdate()) {
            ccc.getDistributedClusterStateUpdater().doSingleStateUpdate(DistributedClusterStateUpdater.MutatingCommand.SliceRemoveReplica, m, ccc.getSolrCloudManager(), ccc.getZkStateReader());
        } else {
            ccc.offerStateUpdate(Utils.toJSON((Object)m));
        }
    }

    static void checkRequired(ZkNodeProps message, String ... props) {
        for (String prop : props) {
            if (message.get(prop) != null) continue;
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, StrUtils.join(Arrays.asList(props), (char)',') + " are required params");
        }
    }

    static void checkResults(String label, NamedList<Object> results, boolean failureIsFatal) throws SolrException {
        Object failure = results.get("failure");
        if (failure == null) {
            failure = results.get("error");
        }
        if (failure != null) {
            String msg = "Error: " + label + ": " + Utils.toJSONString(results);
            if (failureIsFatal) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
            }
            log.error(msg);
        }
    }

    static void commit(NamedList<Object> results, String slice, Replica parentShardLeader) {
        log.debug("Calling soft commit to make sub shard updates visible");
        String coreUrl = new ZkCoreNodeProps((ZkNodeProps)parentShardLeader).getCoreUrl();
        UpdateResponse updateResponse = null;
        try {
            updateResponse = CollectionHandlingUtils.softCommit(coreUrl);
            CollectionHandlingUtils.processResponse(results, null, coreUrl, (SolrResponse)updateResponse, slice, Collections.emptySet());
        }
        catch (Exception e) {
            CollectionHandlingUtils.processResponse(results, e, coreUrl, (SolrResponse)updateResponse, slice, Collections.emptySet());
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to call distrib softCommit on: " + coreUrl, (Throwable)e);
        }
    }

    static UpdateResponse softCommit(String url) throws SolrServerException, IOException {
        try (HttpSolrClient client = ((HttpSolrClient.Builder)((HttpSolrClient.Builder)new HttpSolrClient.Builder(url).withConnectionTimeout(30000)).withSocketTimeout(120000)).build();){
            UpdateRequest ureq = new UpdateRequest();
            ureq.setParams(new ModifiableSolrParams());
            ureq.setAction(AbstractUpdateRequest.ACTION.COMMIT, false, true, true);
            UpdateResponse updateResponse = (UpdateResponse)ureq.process((SolrClient)client);
            return updateResponse;
        }
    }

    public static String waitForCoreNodeName(String collectionName, String msgNodeName, String msgCore, ZkStateReader zkStateReader) {
        try {
            DocCollection collection = zkStateReader.waitForState(collectionName, 320L, TimeUnit.SECONDS, c -> ClusterStateMutator.getAssignedCoreNodeName(c, msgNodeName, msgCore) != null);
            return ClusterStateMutator.getAssignedCoreNodeName(collection, msgNodeName, msgCore);
        }
        catch (InterruptedException | TimeoutException e) {
            SolrZkClient.checkInterrupted((Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed waiting for coreNodeName", (Throwable)e);
        }
    }

    static ClusterState waitForNewShard(String collectionName, String sliceName, ZkStateReader zkStateReader) throws KeeperException, InterruptedException {
        log.debug("Waiting for slice {} of collection {} to be available", (Object)sliceName, (Object)collectionName);
        try {
            zkStateReader.waitForState(collectionName, 320L, TimeUnit.SECONDS, c -> c != null && c.getSlice(sliceName) != null);
        }
        catch (InterruptedException | TimeoutException e) {
            SolrZkClient.checkInterrupted((Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed waiting for new slice", (Throwable)e);
        }
        return zkStateReader.getClusterState();
    }

    static void addPropertyParams(ZkNodeProps message, ModifiableSolrParams params) {
        for (String key : message.keySet()) {
            if (!key.startsWith("property.")) continue;
            params.set(key, new String[]{message.getStr(key)});
        }
    }

    static void addPropertyParams(ZkNodeProps message, Map<String, Object> map) {
        for (String key : message.keySet()) {
            if (!key.startsWith("property.")) continue;
            map.put(key, message.getStr(key));
        }
    }

    static void cleanupCollection(String collectionName, NamedList<Object> results, CollectionCommandContext ccc) throws Exception {
        log.error("Cleaning up collection [{}].", (Object)collectionName);
        Map<String, String> props = Map.of("operation", CollectionParams.CollectionAction.DELETE.toLower(), "name", collectionName);
        new DeleteCollectionCmd(ccc).call(ccc.getZkStateReader().getClusterState(), new ZkNodeProps(props), results);
    }

    static Map<String, Replica> waitToSeeReplicasInState(ZkStateReader zkStateReader, TimeSource timeSource, String collectionName, Collection<String> coreNames) throws InterruptedException {
        assert (coreNames.size() > 0);
        ConcurrentHashMap<String, Replica> results = new ConcurrentHashMap<String, Replica>();
        long maxWait = Long.getLong("solr.waitToSeeReplicasInStateTimeoutSeconds", 120L);
        try {
            zkStateReader.waitForState(collectionName, maxWait, TimeUnit.SECONDS, c -> {
                if (c == null) {
                    return false;
                }
                c.getSlices().stream().flatMap(slice -> slice.getReplicas().stream()).filter(r -> coreNames.contains(r.getCoreName())).forEach(r -> results.putIfAbsent(r.getCoreName(), (Replica)r));
                log.debug("Expecting {} cores, found {}", (Object)coreNames, (Object)results);
                return results.size() == coreNames.size();
            });
        }
        catch (TimeoutException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, e.getMessage(), (Throwable)e);
        }
        return results;
    }

    static void cleanBackup(BackupRepository repository, URI backupUri, BackupId backupId, CollectionCommandContext ccc) throws Exception {
        new DeleteBackupCmd(ccc).deleteBackupIds(backupUri, repository, Collections.singleton(backupId), (NamedList<Object>)new NamedList());
    }

    static void deleteBackup(BackupRepository repository, URI backupPath, int maxNumBackup, NamedList<Object> results, CollectionCommandContext ccc) throws Exception {
        new DeleteBackupCmd(ccc).keepNumberOfBackup(repository, backupPath, maxNumBackup, results);
    }

    static List<ZkNodeProps> addReplica(ClusterState clusterState, ZkNodeProps message, NamedList<Object> results, Runnable onComplete, CollectionCommandContext ccc) throws Exception {
        return new AddReplicaCmd(ccc).addReplica(clusterState, message, results, onComplete);
    }

    static void validateConfigOrThrowSolrException(ConfigSetService configSetService, String configName) throws IOException {
        boolean isValid = configSetService.checkConfigExists(configName);
        if (!isValid) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can not find the specified config set: " + configName);
        }
    }

    static List<Replica> collectionCmd(ZkNodeProps message, ModifiableSolrParams params, NamedList<Object> results, Replica.State stateMatcher, String asyncId, Set<String> okayExceptions, CollectionCommandContext ccc, ClusterState clusterState) {
        log.info("Executing Collection Cmd={}, asyncId={}", (Object)params, (Object)asyncId);
        String collectionName = message.getStr("name");
        ShardHandler shardHandler = ccc.newShardHandler();
        DocCollection coll = clusterState.getCollection(collectionName);
        ArrayList<Replica> notLivesReplicas = new ArrayList<Replica>();
        ShardRequestTracker shardRequestTracker = CollectionHandlingUtils.asyncRequestTracker(asyncId, ccc);
        for (Slice slice : coll.getSlices()) {
            notLivesReplicas.addAll(shardRequestTracker.sliceCmd(clusterState, params, stateMatcher, slice, shardHandler));
        }
        shardRequestTracker.processResponses(results, shardHandler, false, null, okayExceptions);
        return notLivesReplicas;
    }

    static void processResponse(NamedList<Object> results, ShardResponse srsp, Set<String> okayExceptions) {
        Throwable e = srsp.getException();
        String nodeName = srsp.getNodeName();
        SolrResponse solrResponse = srsp.getSolrResponse();
        String shard = srsp.getShard();
        CollectionHandlingUtils.processResponse(results, e, nodeName, solrResponse, shard, okayExceptions);
    }

    static void processResponse(NamedList<Object> results, Throwable e, String nodeName, SolrResponse solrResponse, String shard, Set<String> okayExceptions) {
        String rootThrowable = null;
        if (e instanceof BaseHttpSolrClient.RemoteSolrException) {
            rootThrowable = ((BaseHttpSolrClient.RemoteSolrException)e).getRootThrowable();
        }
        if (!(e == null || rootThrowable != null && okayExceptions.contains(rootThrowable))) {
            log.error("Error from shard: {}", (Object)shard, (Object)e);
            CollectionHandlingUtils.addFailure(results, nodeName, e.getClass().getName() + ":" + e.getMessage());
        } else {
            CollectionHandlingUtils.addSuccess(results, nodeName, solrResponse.getResponse());
        }
    }

    private static void addFailure(NamedList<Object> results, String key, Object value) {
        SimpleOrderedMap failure = (SimpleOrderedMap)results.get("failure");
        if (failure == null) {
            failure = new SimpleOrderedMap();
            results.add("failure", (Object)failure);
        }
        failure.add(key, value);
    }

    private static void addSuccess(NamedList<Object> results, String key, Object value) {
        SimpleOrderedMap success = (SimpleOrderedMap)results.get("success");
        if (success == null) {
            success = new SimpleOrderedMap();
            results.add("success", (Object)success);
        }
        success.add(key, value);
    }

    private static NamedList<Object> waitForCoreAdminAsyncCallToComplete(ShardHandlerFactory shardHandlerFactory, String adminPath, ZkStateReader zkStateReader, String nodeName, String requestId) {
        ShardHandler shardHandler = shardHandlerFactory.getShardHandler();
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("action", new String[]{CoreAdminParams.CoreAdminAction.REQUESTSTATUS.toString()});
        params.set(REQUESTID, new String[]{requestId});
        int counter = 0;
        block4: while (true) {
            ShardResponse srsp;
            ShardRequest sreq = new ShardRequest();
            params.set("qt", new String[]{adminPath});
            sreq.purpose = 1;
            String replica = zkStateReader.getBaseUrlForNodeName(nodeName);
            sreq.shards = new String[]{replica};
            sreq.actualShards = sreq.shards;
            sreq.params = params;
            shardHandler.submit(sreq, replica, sreq.params);
            do {
                if ((srsp = shardHandler.takeCompletedOrError()) == null) continue;
                NamedList results = new NamedList();
                CollectionHandlingUtils.processResponse((NamedList<Object>)results, srsp, Collections.emptySet());
                if (srsp.getSolrResponse().getResponse() == null) {
                    NamedList response = new NamedList();
                    response.add("STATUS", (Object)"failed");
                    return response;
                }
                String r = (String)srsp.getSolrResponse().getResponse().get("STATUS");
                if (r.equals("running")) {
                    log.debug("The task is still RUNNING, continuing to wait.");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                if (r.equals("completed")) {
                    log.debug("The task is COMPLETED, returning");
                    return srsp.getSolrResponse().getResponse();
                }
                if (r.equals("failed")) {
                    log.debug("The task is FAILED, returning");
                    return srsp.getSolrResponse().getResponse();
                }
                if (r.equals("notfound")) {
                    log.debug("The task is notfound, retry");
                    if (counter++ < 5) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue block4;
                    }
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid status request for requestId: " + requestId + srsp.getSolrResponse().getResponse().get("STATUS") + "retried " + counter + "times");
                }
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid status request " + srsp.getSolrResponse().getResponse().get("STATUS"));
            } while (srsp != null);
        }
    }

    public static ShardRequestTracker syncRequestTracker(CollectionCommandContext ccc) {
        return CollectionHandlingUtils.asyncRequestTracker(null, ccc);
    }

    public static ShardRequestTracker asyncRequestTracker(String asyncId, CollectionCommandContext ccc) {
        return new ShardRequestTracker(asyncId, ccc.getAdminPath(), ccc.getZkStateReader(), ccc.newShardHandler().getShardHandlerFactory());
    }

    static {
        String seed = System.getProperty("tests.seed");
        RANDOM = seed == null ? new Random() : new Random(seed.hashCode());
    }

    public static class ShardRequestTracker {
        @Deprecated
        static boolean INCLUDE_TOP_LEVEL_RESPONSE = true;
        private final String asyncId;
        private final String adminPath;
        private final ZkStateReader zkStateReader;
        private final ShardHandlerFactory shardHandlerFactory;
        private final NamedList<String> shardAsyncIdByNode = new NamedList();

        public ShardRequestTracker(String asyncId, String adminPath, ZkStateReader zkStateReader, ShardHandlerFactory shardHandlerFactory) {
            this.asyncId = asyncId;
            this.adminPath = adminPath;
            this.zkStateReader = zkStateReader;
            this.shardHandlerFactory = shardHandlerFactory;
        }

        public List<Replica> sliceCmd(ClusterState clusterState, ModifiableSolrParams params, Replica.State stateMatcher, Slice slice, ShardHandler shardHandler) {
            ArrayList<Replica> notLiveReplicas = new ArrayList<Replica>();
            for (Replica replica : slice.getReplicas()) {
                if (stateMatcher != null && Replica.State.getState((String)replica.getStr("state")) != stateMatcher) continue;
                if (clusterState.liveNodesContain(replica.getStr("node_name"))) {
                    ModifiableSolrParams cloneParams = new ModifiableSolrParams();
                    cloneParams.add((SolrParams)params);
                    cloneParams.set("core", new String[]{replica.getStr("core")});
                    this.sendShardRequest(replica.getStr("node_name"), cloneParams, shardHandler);
                    continue;
                }
                notLiveReplicas.add(replica);
            }
            return notLiveReplicas;
        }

        public void sendShardRequest(String nodeName, ModifiableSolrParams params, ShardHandler shardHandler) {
            this.sendShardRequest(nodeName, params, shardHandler, this.adminPath, this.zkStateReader);
        }

        public void sendShardRequest(String nodeName, ModifiableSolrParams params, ShardHandler shardHandler, String adminPath, ZkStateReader zkStateReader) {
            if (this.asyncId != null) {
                String coreAdminAsyncId = this.asyncId + Math.abs(System.nanoTime());
                params.set("async", new String[]{coreAdminAsyncId});
                this.track(nodeName, coreAdminAsyncId);
            }
            ShardRequest sreq = new ShardRequest();
            params.set("qt", new String[]{adminPath});
            sreq.purpose = 1;
            String replica = zkStateReader.getBaseUrlForNodeName(nodeName);
            sreq.shards = new String[]{replica};
            sreq.actualShards = sreq.shards;
            sreq.nodeName = nodeName;
            sreq.params = params;
            shardHandler.submit(sreq, replica, sreq.params);
        }

        void processResponses(NamedList<Object> results, ShardHandler shardHandler, boolean abortOnError, String msgOnError) {
            this.processResponses(results, shardHandler, abortOnError, msgOnError, Collections.emptySet());
        }

        void processResponses(NamedList<Object> results, ShardHandler shardHandler, boolean abortOnError, String msgOnError, Set<String> okayExceptions) {
            ShardResponse srsp;
            do {
                if ((srsp = shardHandler.takeCompletedOrError()) == null) continue;
                CollectionHandlingUtils.processResponse(results, srsp, okayExceptions);
                Throwable exception = srsp.getException();
                if (!abortOnError || exception == null) continue;
                while (srsp != null) {
                    srsp = shardHandler.takeCompletedOrError();
                }
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msgOnError, exception);
            } while (srsp != null);
            if (this.asyncId != null) {
                this.waitForAsyncCallsToComplete(results);
                this.shardAsyncIdByNode.clear();
            }
        }

        private void waitForAsyncCallsToComplete(NamedList<Object> results) {
            for (Map.Entry nodeToAsync : this.shardAsyncIdByNode) {
                String node = (String)nodeToAsync.getKey();
                String shardAsyncId = (String)nodeToAsync.getValue();
                log.debug("I am Waiting for :{}/{}", (Object)node, (Object)shardAsyncId);
                NamedList<Object> reqResult = CollectionHandlingUtils.waitForCoreAdminAsyncCallToComplete(this.shardHandlerFactory, this.adminPath, this.zkStateReader, node, shardAsyncId);
                if (INCLUDE_TOP_LEVEL_RESPONSE) {
                    results.add(shardAsyncId, reqResult);
                }
                if ("failed".equalsIgnoreCase((String)reqResult.get("STATUS"))) {
                    log.error("Error from shard {}: {}", (Object)node, reqResult);
                    CollectionHandlingUtils.addFailure(results, node, reqResult);
                    continue;
                }
                CollectionHandlingUtils.addSuccess(results, node, reqResult);
            }
        }

        @Deprecated
        void track(String nodeName, String coreAdminAsyncId) {
            this.shardAsyncIdByNode.add(nodeName, (Object)coreAdminAsyncId);
        }
    }
}

