/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.visualization;

import java.io.File;
import java.io.IOException;
import net.yacy.visualization.PrintTool;
import net.yacy.visualization.RasterPlotter;

public class HeartbeatTelemetryRibbonPlotter
extends RasterPlotter {
    private final int ribbonHeight = 80;
    private final int baseline;

    public HeartbeatTelemetryRibbonPlotter(int width, int height) {
        super(width, height, RasterPlotter.DrawMode.MODE_REPLACE, 12L);
        this.baseline = height / 2;
    }

    public void renderFrame(int frame) {
        this.clear();
        this.drawBackground();
        this.drawRibbon(frame);
        this.drawMarkers(frame);
        this.drawOverlay(frame);
    }

    private void drawBackground() {
        this.setColor(4128L);
        for (int y = 0; y < this.getHeight(); y += 4) {
            this.line(0, y, this.getWidth(), y, 12);
        }
    }

    private void drawRibbon(int frame) {
        int left = 20;
        int right = this.getWidth() - 20;
        int amplitude = 40;
        this.setColor(13132L);
        this.line(20, this.baseline, right, this.baseline, 40);
        this.setColor(65450L);
        int prevX = 20;
        int prevY = this.baseline;
        int x = 20;
        while (x <= right) {
            double t = (double)(x - 20) / (double)(right - 20);
            double wave = this.heartbeatWave(t, frame);
            int y = this.baseline - (int)(wave * 40.0);
            this.line(prevX, prevY, x, y, 80);
            prevX = x++;
            prevY = y;
        }
    }

    private double heartbeatWave(double t, int frame) {
        double phase = t * 4.0 + (double)frame * 0.1;
        double wave = Math.sin(phase * Math.PI * 2.0) * 0.2;
        double beat = (phase + (double)frame * 0.02) % 1.0;
        if (beat < 0.04) {
            wave += Math.sin(beat * Math.PI / 0.04) * 1.2;
        }
        if (beat > 0.04 && beat < 0.08) {
            wave -= Math.sin((beat - 0.04) * Math.PI / 0.04) * 0.6;
        }
        return Math.max(-1.0, Math.min(1.0, wave));
    }

    private void drawMarkers(int frame) {
        this.setColor(48127L);
        for (int x = 20; x < this.getWidth(); x += 60) {
            this.line(x, this.baseline - 40, x, this.baseline + 40, 20);
        }
        this.setColor(0x66FFFFL);
        PrintTool.print5(this, 20, this.baseline - 40 - 12, 0, "SYNC", -1, 70);
    }

    private void drawOverlay(int frame) {
        this.setColor(0x66FFEEL);
        PrintTool.print5(this, 6, 12, 0, "CARDIAC TELEMETRY", -1, 80);
        this.setColor(65450L);
        PrintTool.print5(this, this.getWidth() - 6, 12, 0, "BPM" + (frame * 3 % 90 + 60), 1, 70);
    }

    public static void main(String[] args) {
        File dir;
        System.setProperty("java.awt.headless", "true");
        File file = dir = args.length > 0 ? new File(args[0]) : new File(".");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        HeartbeatTelemetryRibbonPlotter plotter = new HeartbeatTelemetryRibbonPlotter(640, 240);
        for (int frame = 0; frame < 8; ++frame) {
            plotter.renderFrame(frame);
            File out = new File(dir, String.format("telemetry_ribbon_%02d.png", frame));
            try {
                plotter.save(out, "png");
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to save telemetry frame", e);
            }
        }
    }
}

