/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeSet;
import net.yacy.kelondro.util.FileUtils;

public class enumerateFiles
implements Enumeration<File> {
    private final List<TreeSet<File>> hierarchy;
    private final boolean incOrder;
    private File buffer;
    private final boolean return_files;
    private final boolean return_folders;
    private final boolean delete_emptyFolders;

    public enumerateFiles(File root, boolean files, boolean folders, boolean increasing, boolean deleteEmptyFolders) {
        this.return_files = files;
        this.return_folders = folders;
        this.delete_emptyFolders = deleteEmptyFolders;
        this.hierarchy = new ArrayList<TreeSet<File>>();
        this.incOrder = increasing;
        TreeSet<File> t = new TreeSet<File>();
        String[] l = root.list();
        if (l != null) {
            for (int i = 0; i < l.length; ++i) {
                t.add(new File(root, l[i]));
            }
        }
        this.hierarchy.add(t);
        this.buffer = this.nextElement0();
    }

    private File nextElement0() {
        File f;
        do {
            TreeSet<File> t = null;
            while (t == null && !this.hierarchy.isEmpty()) {
                t = this.hierarchy.get(this.hierarchy.size() - 1);
                if (!t.isEmpty()) continue;
                this.hierarchy.remove(this.hierarchy.size() - 1);
                t = null;
            }
            if (this.hierarchy.isEmpty() || t == null || t.isEmpty()) {
                return null;
            }
            f = this.incOrder ? t.first() : t.last();
            t.remove(f);
            if (f.isDirectory()) {
                t = new TreeSet();
                String[] l = f.list();
                if (l == null) {
                    f = null;
                    continue;
                }
                if (l.length == 0) {
                    if (this.delete_emptyFolders) {
                        FileUtils.deletedelete(f);
                        f = null;
                        continue;
                    }
                    if (this.return_folders) continue;
                    f = null;
                    continue;
                }
                for (int i = 0; i < l.length; ++i) {
                    t.add(new File(f, l[i]));
                }
                this.hierarchy.add(t);
                if (this.return_folders) continue;
                f = null;
                continue;
            }
            if (this.return_files) continue;
            f = null;
        } while (f == null);
        return f;
    }

    @Override
    public boolean hasMoreElements() {
        return this.buffer != null;
    }

    @Override
    public File nextElement() {
        File r = this.buffer;
        this.buffer = this.nextElement0();
        return r;
    }
}

