/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.search.navigator;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import net.yacy.cora.federate.solr.SolrType;
import net.yacy.cora.sorting.ReversibleScoreMap;
import net.yacy.kelondro.data.meta.URIMetadataNode;
import net.yacy.search.navigator.Navigator;
import net.yacy.search.navigator.NavigatorSort;
import net.yacy.search.navigator.StringNavigator;
import net.yacy.search.query.QueryModifier;
import net.yacy.search.schema.CollectionSchema;

public class YearNavigator
extends StringNavigator
implements Navigator {
    public YearNavigator(String title, CollectionSchema field, NavigatorSort sort) {
        super(title, field, sort == null ? NavigatorSort.LABEL_DESC : sort);
        if (field.getType() != SolrType.date) {
            throw new IllegalArgumentException("field is not of type Date");
        }
    }

    @Override
    public String getQueryModifier(String key) {
        if (this.field == CollectionSchema.dates_in_content_dts) {
            return "from:" + key + "-01-01 to:" + key + "-12-31 ";
        }
        return key;
    }

    @Override
    public void incFacet(Map<String, ReversibleScoreMap<String>> facets) {
        ReversibleScoreMap<String> fcts;
        if (this.field != null && facets != null && !facets.isEmpty() && (fcts = facets.get(this.field.getSolrFieldName())) != null) {
            for (String datestring : fcts) {
                this.inc(datestring.substring(0, 4), fcts.get(datestring));
            }
        }
    }

    @Override
    public void incDoc(URIMetadataNode doc) {
        Object val;
        if (this.field != null && this.field.getType() == SolrType.date && (val = doc.getFieldValue(this.field.getSolrFieldName())) != null) {
            Calendar cal = Calendar.getInstance();
            if (val instanceof Collection) {
                Collection ll = (Collection)val;
                for (Object o : ll) {
                    if (o instanceof String) {
                        this.inc((String)o);
                        continue;
                    }
                    if (!(o instanceof Date)) continue;
                    cal.setTime((Date)o);
                    String year = Integer.toString(cal.get(1));
                    this.inc(year);
                }
            } else {
                cal.setTime((Date)val);
                String year = Integer.toString(cal.get(1));
                this.inc(year);
            }
        }
    }

    @Override
    public boolean modifieractive(QueryModifier modifier, String name) {
        return this.field == CollectionSchema.dates_in_content_dts && modifier.toString().contains("from:" + name) && modifier.toString().contains("to:" + name);
    }
}

