/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.search;

import net.yacy.cora.util.ConcurrentLog;
import net.yacy.kelondro.util.MemoryControl;
import net.yacy.search.EventTracker;

public class MemoryTracker
extends Thread {
    private static MemoryTracker systemProfiler = null;
    private final long delaytime;
    private boolean running;

    public static void startSystemProfiling() {
        systemProfiler = new MemoryTracker(1500L);
        systemProfiler.start();
    }

    public static void stopSystemProfiling() {
        MemoryTracker.systemProfiler.running = false;
    }

    public MemoryTracker(long time) {
        super("MemoryTracker");
        this.delaytime = time;
        this.running = true;
    }

    @Override
    public void run() {
        try {
            while (this.running) {
                EventTracker.update(EventTracker.EClass.MEMORY, MemoryControl.used(), true);
                try {
                    Thread.sleep(this.delaytime);
                }
                catch (InterruptedException e) {
                    this.running = false;
                }
            }
        }
        catch (Exception e) {
            ConcurrentLog.logException(e);
        }
    }
}

