/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.peers.graphics;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import net.yacy.search.EventTracker;
import net.yacy.search.query.SearchEventType;
import net.yacy.visualization.ChartPlotter;
import net.yacy.visualization.RasterPlotter;

public class ProfilingGraph {
    private static ChartPlotter bufferChart = null;
    public static long maxTime = 600000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long maxPayload(EventTracker.EClass eventname, long min) {
        Iterator<EventTracker.Event> list2 = EventTracker.getHistory(eventname);
        if (list2 == null) {
            return min;
        }
        long max = min;
        Iterator<EventTracker.Event> iterator = list2;
        synchronized (iterator) {
            while (list2.hasNext()) {
                EventTracker.Event event = list2.next();
                long l = (Long)event.payload;
                if (l <= max) continue;
                max = l;
            }
        }
        return max;
    }

    public static RasterPlotter performanceGraph(int width, int height, String subline, int maxTime, TimeUnit timeUnit, boolean showMemory, boolean showPeers) {
        int leftscale;
        int maxppm = (int)ProfilingGraph.maxPayload(EventTracker.EClass.PPM, 25L);
        int maxwords = (int)ProfilingGraph.maxPayload(EventTracker.EClass.WORDCACHE, 12000L);
        long maxbytes = ProfilingGraph.maxPayload(EventTracker.EClass.MEMORY, 0x6E00000L);
        int maxmbytes = (int)(maxbytes / 1024L / 1024L);
        int leftborder = 64;
        int rightborder = 48;
        int topborder = 24;
        int bottomborder = 24;
        int n = leftscale = maxwords > 150000 ? maxwords / 150000 * 20000 : 10000;
        int rightscale = showMemory ? (maxmbytes > 1500 ? maxmbytes / 1500 * 200 : 100) : Math.max(100, maxppm / 100 * 100);
        int anotscale = 1000;
        int bottomscale = Math.max(1, maxTime / 10);
        int vspace = height - 24 - 24;
        int hspace = width - 64 - 48;
        ChartPlotter chart = new ChartPlotter(width, height, 0xFFFFFFL, 0L, 0xAAAAAAL, 64, 48, 24, 24, "YACY PEER PERFORMANCE: MAIN MEMORY, WORD CACHE AND PAGES/MINUTE (PPM)", subline);
        chart.declareDimension(3, bottomscale, hspace / (maxTime / bottomscale), -maxTime, 0L, 0xCCCCCCL, "TIME/" + String.valueOf((Object)timeUnit) != null ? timeUnit.toString() : TimeUnit.SECONDS.toString());
        chart.declareDimension(2, leftscale, (int)((long)vspace * (long)leftscale / (long)maxwords), 0, 34816L, null, "WORDS IN INDEXING CACHE");
        if (showMemory) {
            chart.declareDimension(0, rightscale, (int)((long)vspace * (long)rightscale / (long)maxmbytes), 0, 255L, 0xCCCCCCL, "MEMORY/MEGABYTE");
        } else {
            chart.declareDimension(0, rightscale, (int)((long)vspace * (long)rightscale / (long)Math.max(1, maxppm)), 0, 0xFF0000L, 0xCCCCCCL, "INDEXING SPEED/PAGES PER MINUTE");
        }
        chart.declareDimension(4, 1000, (int)((long)vspace * 1000L / (long)maxppm), 0, 34816L, null, "PPM [PAGES/MINUTE]");
        chart.declareDimension(5, vspace / 6, vspace / 6, 0, 0x888800L, null, "URL");
        chart.declareDimension(6, 1, 1, 0, 0x888800L, null, "PING");
        long now = System.currentTimeMillis();
        try {
            int y1;
            float x1;
            long time;
            EventTracker.Event event;
            int y0;
            float x0;
            Iterator<EventTracker.Event> events;
            if (showMemory) {
                events = EventTracker.getHistory(EventTracker.EClass.MEMORY);
                x0 = 1.0f;
                y0 = 0;
                if (events != null) {
                    while (events.hasNext()) {
                        event = events.next();
                        time = event.getTime() - now;
                        long bytes = (Long)event.payload;
                        x1 = timeUnit.convert(time, TimeUnit.MILLISECONDS);
                        y1 = (int)(bytes / 1024L / 1024L);
                        chart.setColor(255L);
                        if (x0 < 0.0f) {
                            chart.chartLine(3, 0, x0, y0, x1, y1);
                        }
                        x0 = x1;
                        y0 = y1;
                    }
                }
            }
            events = EventTracker.getHistory(EventTracker.EClass.WORDCACHE);
            x0 = 1.0f;
            y0 = 0;
            if (events != null) {
                while (events.hasNext()) {
                    event = events.next();
                    time = event.getTime() - now;
                    int words = (int)((Long)event.payload).longValue();
                    x1 = timeUnit.convert(time, TimeUnit.MILLISECONDS);
                    y1 = words;
                    chart.setColor(0x228822L);
                    chart.chartDot(3, 2, x1, y1, 2, null, 315);
                    chart.setColor(34816L);
                    if (x0 < 0.0f) {
                        chart.chartLine(3, 2, x0, y0, x1, y1);
                    }
                    x0 = x1;
                    y0 = y1;
                }
            }
            events = EventTracker.getHistory(EventTracker.EClass.PPM);
            x0 = 1.0f;
            y0 = 0;
            if (events != null) {
                while (events.hasNext()) {
                    event = events.next();
                    time = event.getTime() - now;
                    int ppm = (int)((Long)event.payload).longValue();
                    x1 = timeUnit.convert(time, TimeUnit.MILLISECONDS);
                    y1 = ppm;
                    chart.setColor(0xAA8888L);
                    if (x0 < 0.0f) {
                        chart.chartLine(3, 4, x0, y0, x1, y1);
                    }
                    chart.setColor(0xAA2222L);
                    chart.chartDot(3, 4, x1, y1, 2, ppm + " PPM", 0);
                    x0 = x1;
                    y0 = y1;
                }
            }
            if (showPeers) {
                events = EventTracker.getHistory(EventTracker.EClass.PEERPING);
                x0 = 1.0f;
                y0 = 0;
                if (events != null) {
                    while (events.hasNext()) {
                        event = events.next();
                        time = event.getTime() - now;
                        EventPing ping = (EventPing)event.payload;
                        x1 = timeUnit.convert(time, TimeUnit.MILLISECONDS);
                        y1 = Math.abs((ping.outgoing ? ping.toPeer : ping.fromPeer).hashCode()) % vspace;
                        String pingPeer = ping.outgoing ? "-> " + ping.toPeer.toUpperCase() : "<- " + ping.fromPeer.toUpperCase();
                        chart.setColor(0x9999AAL);
                        chart.chartDot(3, 6, x1, y1, 2, pingPeer + (String)(ping.newPeers > 0 ? "(+" + ping.newPeers + ")" : ""), 0);
                        x0 = x1;
                        y0 = y1;
                    }
                }
            }
            bufferChart = chart;
        }
        catch (ConcurrentModificationException cme) {
            chart = bufferChart;
        }
        return chart;
    }

    public static class EventPing {
        public String fromPeer;
        public String toPeer;
        public boolean outgoing;
        public int newPeers;

        public EventPing(String fromPeer, String toPeer, boolean outgoing, int newPeers) {
            this.fromPeer = fromPeer;
            this.toPeer = toPeer;
            this.outgoing = outgoing;
            this.newPeers = newPeers;
        }
    }

    public static class EventDHT {
        public String fromPeer;
        public String toPeer;
        public boolean outgoing;
        public int totalReferences;
        public int newReferences;

        public EventDHT(String fromPeer, String toPeer, boolean outgoing, int totalReferences, int newReferences) {
            this.fromPeer = fromPeer;
            this.toPeer = toPeer;
            this.outgoing = outgoing;
            this.totalReferences = totalReferences;
            this.newReferences = newReferences;
        }
    }

    public static class EventSearch {
        public SearchEventType processName;
        public String comment;
        public String queryID;
        public long duration;
        public int resultCount;

        public EventSearch(String queryID, SearchEventType processName, String comment, int resultCount, long duration) {
            this.queryID = queryID;
            this.processName = processName;
            this.comment = comment;
            this.resultCount = resultCount;
            this.duration = duration;
        }
    }
}

