/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.workflow;

import java.util.TreeMap;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.kelondro.workflow.AbstractBusyThread;
import net.yacy.kelondro.workflow.BusyThread;

public abstract class InstantBusyThread
extends AbstractBusyThread
implements BusyThread {
    private final Long handle;
    private static final TreeMap<Long, String> jobs = new TreeMap();

    public InstantBusyThread(long idleSleep, long busySleep) {
        this("InstantBusyThread.job", idleSleep, busySleep);
    }

    public InstantBusyThread(String jobName, long idleSleep, long busySleep) {
        super(idleSleep, busySleep);
        this.setName("BusyThread " + jobName);
        this.handle = System.currentTimeMillis() + (long)this.getName().hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean job() throws Exception {
        TreeMap<Long, String> treeMap = jobs;
        synchronized (treeMap) {
            jobs.put(this.handle, this.getName());
        }
        boolean jobHasDoneSomething = false;
        try {
            jobHasDoneSomething = this.jobImpl();
        }
        catch (IllegalArgumentException e) {
            ConcurrentLog.severe("BUSYTHREAD", "Internal Error in InstantBusyThread.job: " + e.getMessage());
            ConcurrentLog.severe("BUSYTHREAD", "shutting down thread '" + this.getName() + "'");
            this.terminate(false);
        }
        catch (OutOfMemoryError e) {
            ConcurrentLog.severe("BUSYTHREAD", "OutOfMemory Error in InstantBusyThread.job, thread '" + this.getName() + "': " + e.getMessage());
            ConcurrentLog.logException(e);
            this.freemem();
        }
        catch (Exception e) {
            ConcurrentLog.severe("BUSYTHREAD", "Generic Exception, thread '" + this.getName() + "': " + e.getMessage());
            ConcurrentLog.logException(e);
        }
        TreeMap<Long, String> treeMap2 = jobs;
        synchronized (treeMap2) {
            jobs.remove(this.handle);
        }
        return jobHasDoneSomething;
    }

    public abstract boolean jobImpl() throws Exception;

    @Override
    public void freemem() {
        try {
            this.freememImpl();
        }
        catch (OutOfMemoryError e) {
            ConcurrentLog.severe("BUSYTHREAD", "OutOfMemory Error in InstantBusyThread.freemem, thread '" + this.getName() + "': " + e.getMessage());
            ConcurrentLog.logException(e);
        }
    }

    @Override
    public int getJobCount() {
        return Integer.MAX_VALUE;
    }

    public void freememImpl() {
    }

    @Override
    public void open() {
    }

    @Override
    public synchronized void close() {
    }

    public static InstantBusyThread createFromRunnable(final Runnable task, long idleSleep, long busySleep) {
        if (task == null) {
            throw new IllegalArgumentException("Runnable task must not be null");
        }
        InstantBusyThread busyThread = new InstantBusyThread(task.getClass().getName() + ".run", idleSleep, busySleep){

            @Override
            public boolean jobImpl() throws Exception {
                task.run();
                return true;
            }
        };
        return busyThread;
    }
}

