/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.workflow;

import net.yacy.cora.util.ConcurrentLog;
import net.yacy.kelondro.util.MemoryControl;
import net.yacy.kelondro.workflow.AbstractThread;
import net.yacy.kelondro.workflow.BlockingThread;
import net.yacy.kelondro.workflow.WorkflowJob;
import net.yacy.kelondro.workflow.WorkflowProcessor;

public abstract class AbstractBlockingThread<J extends WorkflowJob>
extends AbstractThread
implements BlockingThread<J> {
    private WorkflowProcessor<J> manager = null;
    private static final ConcurrentLog log = new ConcurrentLog("AbstractBlockingThread");

    @Override
    public void setManager(WorkflowProcessor<J> manager) {
        this.manager = manager;
    }

    @Override
    public WorkflowProcessor<J> getManager() {
        return this.manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.open();
        if (log != null) {
            this.logSystem("thread '" + this.getName() + "' deployed, starting loop.");
        }
        long busyCycles = 0L;
        while (this.running) {
            try {
                long memstamp1;
                if (!this.shutdownInProgress() && MemoryControl.shortStatus()) {
                    for (int i = 0; i < 5; ++i) {
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                        if (this.shutdownInProgress() || !MemoryControl.shortStatus()) break;
                    }
                }
                long timestamp = System.currentTimeMillis();
                long memstamp0 = MemoryControl.used();
                J in = this.manager.take();
                if (in == null || in == WorkflowJob.poisonPill || ((WorkflowJob)in).status == 99) {
                    this.running = false;
                    break;
                }
                J out = this.job(in);
                if (out != null) {
                    this.manager.passOn(out);
                }
                if ((memstamp1 = MemoryControl.used()) >= memstamp0) {
                    this.memuse += memstamp1 - memstamp0;
                } else if (busyCycles > 0L) {
                    this.memuse += this.memuse / busyCycles;
                }
                this.busytime += System.currentTimeMillis() - timestamp;
            }
            catch (InterruptedException e) {
                this.running = false;
                break;
            }
            catch (Exception e) {
                ConcurrentLog.logException(e);
                this.jobExceptionHandler(e);
            }
            finally {
                ++busyCycles;
            }
        }
        this.manager.decExecutors();
        this.close();
        this.logSystem("thread '" + this.getName() + "' terminated.");
    }

    private void logSystem(String text) {
        if (log == null) {
            ConcurrentLog.config("THREAD-CONTROL", text);
        } else {
            log.config(text);
        }
    }
}

