/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.util;

import java.lang.reflect.Array;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import net.yacy.cora.order.CloneableIterator;

public class StackIterator<E>
implements CloneableIterator<E> {
    private final CloneableIterator<E> a;
    private final CloneableIterator<E> b;
    private E na;
    private E nb;
    private final Comparator<E> c;

    public StackIterator(CloneableIterator<E> a, CloneableIterator<E> b, final Comparator<E> c, boolean up) {
        this.a = a;
        this.b = b;
        this.c = up ? c : new Comparator<E>(){
            final /* synthetic */ StackIterator this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public int compare(E o1, E o2) {
                return -c.compare(o1, o2);
            }
        };
        this.nexta();
        this.nextb();
    }

    @Override
    public StackIterator<E> clone(Object modifier) {
        return new StackIterator<E>(this.a.clone(modifier), this.b.clone(modifier), this.c, true);
    }

    private void nexta() {
        try {
            this.na = this.a != null && this.a.hasNext() ? this.a.next() : null;
        }
        catch (ConcurrentModificationException e) {
            this.na = null;
        }
    }

    private void nextb() {
        try {
            this.nb = this.b != null && this.b.hasNext() ? this.b.next() : null;
        }
        catch (ConcurrentModificationException e) {
            this.nb = null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.na != null || this.nb != null;
    }

    @Override
    public E next() {
        if (this.na == null) {
            E s = this.nb;
            this.nextb();
            return s;
        }
        if (this.nb == null) {
            E s = this.na;
            this.nexta();
            return s;
        }
        if (this.c == null || this.c.compare(this.na, this.nb) <= 0) {
            E s = this.na;
            this.nexta();
            return s;
        }
        E s = this.nb;
        this.nextb();
        return s;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("merge does not support remove");
    }

    public static <A> CloneableIterator<A> stack(CloneableIterator<A>[] iterators, Comparator<A> c, boolean up) {
        if (iterators == null || iterators.length == 0) {
            return new CloneableIterator<A>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public A next() {
                    return null;
                }

                @Override
                public void remove() {
                }

                @Override
                public CloneableIterator<A> clone(Object modifier) {
                    return null;
                }

                @Override
                public void close() {
                }
            };
        }
        if (iterators.length == 1) {
            return iterators[0];
        }
        if (iterators.length == 2) {
            if (iterators[0] == null) {
                return iterators[1];
            }
            if (iterators[1] == null) {
                return iterators[0];
            }
            return new StackIterator<A>(iterators[0], iterators[1], c, up);
        }
        CloneableIterator<A> a = iterators[0];
        CloneableIterator[] iterators0 = (CloneableIterator[])Array.newInstance(CloneableIterator.class, iterators.length - 1);
        System.arraycopy(iterators, 1, iterators0, 0, iterators.length - 1);
        if (a == null) {
            return StackIterator.stack(iterators0, c, up);
        }
        return new StackIterator<A>(a, StackIterator.stack(iterators0, c, up), c, up);
    }

    @Override
    public void close() {
        this.a.close();
        this.b.close();
    }
}

