/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;

public final class Formatter {
    private static Locale locale = Locale.forLanguageTag("en");
    private static final ThreadLocal<NumberFormat> numForm = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            NumberFormat n = locale == null ? new DecimalFormat("####.##", new DecimalFormatSymbols(Locale.ENGLISH)) : NumberFormat.getInstance(locale);
            n.setGroupingUsed(true);
            n.setParseIntegerOnly(false);
            n.setMaximumFractionDigits(2);
            return n;
        }
    };
    private static final ThreadLocal<NumberFormat> cleanNumForm = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            DecimalFormat n = new DecimalFormat("####.##", new DecimalFormatSymbols(Locale.ENGLISH));
            return n;
        }
    };

    private static void setLocale(Locale l) {
        locale = l;
    }

    public static void setLocale(String lang) {
        String l = lang.equalsIgnoreCase("default") ? "en" : lang.toLowerCase(Locale.ROOT);
        Formatter.setLocale(l.equals("none") ? null : Locale.forLanguageTag(l));
    }

    public static String number(double d, boolean localized) {
        return localized ? numForm.get().format(d) : cleanNumForm.get().format(d);
    }

    private static String number(double d) {
        return numForm.get().format(d);
    }

    public static String number(long l, boolean localized) {
        return localized ? numForm.get().format(l) : cleanNumForm.get().format(l);
    }

    public static String number(long l) {
        return numForm.get().format(l);
    }

    public static String number(String s) {
        String ret = null;
        try {
            ret = s.indexOf(46) == -1 ? Formatter.number(Long.parseLong(s)) : Formatter.number(Float.parseFloat(s));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return ret == null ? "-" : ret;
    }

    public static String bytesToString(long byteCount) {
        try {
            StringBuilder byteString = new StringBuilder();
            if (byteCount > 0x40000000L) {
                byteString.append(Formatter.number((double)byteCount / 1.073741824E9)).append(" GB");
            } else if (byteCount > 0x100000L) {
                byteString.append(Formatter.number((double)byteCount / 1048576.0)).append(" MB");
            } else if (byteCount > 1024L) {
                byteString.append(Formatter.number((double)byteCount / 1024.0)).append(" KB");
            } else {
                byteString.append(Long.toString(byteCount)).append(" Bytes");
            }
            return byteString.toString();
        }
        catch (Exception e) {
            return "unknown";
        }
    }
}

