/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import net.yacy.cora.util.ConcurrentLog;

public class ConsoleInterface
extends Thread {
    private final InputStream stream;
    private final List<String> output = new ArrayList<String>();
    private final Semaphore dataIsRead = new Semaphore(1);
    private final ConcurrentLog log;

    private ConsoleInterface(InputStream stream, ConcurrentLog log) {
        super("ConsoleInterface");
        this.log = log;
        this.stream = stream;
        try {
            this.dataIsRead.acquire();
        }
        catch (InterruptedException e) {
            ConcurrentLog.logException(e);
        }
    }

    @Override
    public void run() {
        try {
            InputStreamReader input = new InputStreamReader(this.stream);
            BufferedReader buffer = new BufferedReader(input);
            String line = null;
            int tries = 0;
            while (tries < 1000) {
                ++tries;
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!buffer.ready()) continue;
            }
            while ((line = buffer.readLine()) != null) {
                this.output.add(line);
            }
            this.dataIsRead.release();
        }
        catch (IOException ix) {
            this.log.warn("logpoint 6 " + ix.getMessage());
        }
        catch (Exception e) {
            ConcurrentLog.logException(e);
        }
    }

    public List<String> getOutput() {
        try {
            this.dataIsRead.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.dataIsRead.release();
        return this.output;
    }

    private static List<String> getConsoleOutput(List<String> processArgs, ConcurrentLog log) throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(processArgs);
        Process process = null;
        ConsoleInterface inputStream = null;
        ConsoleInterface errorStream = null;
        try {
            process = processBuilder.start();
            inputStream = new ConsoleInterface(process.getInputStream(), log);
            errorStream = new ConsoleInterface(process.getErrorStream(), log);
            inputStream.start();
            errorStream.start();
            process.waitFor();
        }
        catch (IOException iox) {
            log.warn("logpoint 0 " + iox.getMessage());
            throw new IOException(iox.getMessage());
        }
        catch (InterruptedException ix) {
            log.warn("logpoint 1 " + ix.getMessage());
            throw new IOException(ix.getMessage());
        }
        List<String> list2 = inputStream.getOutput();
        if (list2.isEmpty()) {
            String error = errorStream.getOutput().toString();
            log.warn("logpoint 2: " + error);
            throw new IOException("empty list: " + error);
        }
        return list2;
    }

    public static String getLastLineConsoleOutput(List<String> processArgs, ConcurrentLog log) throws IOException {
        List<String> lines = ConsoleInterface.getConsoleOutput(processArgs, log);
        String line = "";
        for (int l = lines.size() - 1; l >= 0 && (line = lines.get(l).trim()).length() <= 0; --l) {
        }
        return line;
    }
}

