/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.rwi;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import net.yacy.cora.order.ByteOrder;
import net.yacy.cora.order.CloneableIterator;
import net.yacy.cora.order.Order;
import net.yacy.cora.sorting.Rating;
import net.yacy.cora.storage.ComparableARC;
import net.yacy.cora.storage.HandleSet;
import net.yacy.cora.util.ByteArray;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.data.word.Word;
import net.yacy.kelondro.index.RowHandleSet;
import net.yacy.kelondro.rwi.AbstractBufferedIndex;
import net.yacy.kelondro.rwi.BufferedIndex;
import net.yacy.kelondro.rwi.IODispatcher;
import net.yacy.kelondro.rwi.Reference;
import net.yacy.kelondro.rwi.ReferenceContainer;
import net.yacy.kelondro.rwi.ReferenceContainerArray;
import net.yacy.kelondro.rwi.ReferenceContainerCache;
import net.yacy.kelondro.rwi.ReferenceContainerOrder;
import net.yacy.kelondro.rwi.ReferenceFactory;
import net.yacy.kelondro.util.MemoryControl;
import net.yacy.kelondro.util.MergeIterator;
import net.yacy.search.EventTracker;
import net.yacy.search.Switchboard;

public final class IndexCell<ReferenceType extends Reference>
extends AbstractBufferedIndex<ReferenceType>
implements BufferedIndex<ReferenceType>,
Iterable<ReferenceContainer<ReferenceType>> {
    private static final long cleanupCycle = 60000L;
    private static final long dumpCycle = 300000L;
    private final ReferenceContainerArray<ReferenceType> array;
    private ReferenceContainerCache<ReferenceType> ram;
    private final ComparableARC<byte[], Integer> countCache;
    private int maxRamEntries;
    private IODispatcher merger;
    private long lastCleanup;
    private long lastDump;
    private final long targetFileSize;
    private final long maxFileSize;
    private final int writeBufferSize;
    private final Map<byte[], HandleSet> removeDelayedURLs;
    private boolean flushShallRun;
    private final Thread flushThread;

    public IndexCell(File cellPath, String prefix, ReferenceFactory<ReferenceType> factory, ByteOrder termOrder, int termSize, int maxRamEntries, long targetFileSize, long maxFileSize, int writeBufferSize, IODispatcher merger) throws IOException {
        super(factory);
        this.merger = merger;
        this.array = new ReferenceContainerArray<ReferenceType>(cellPath, prefix, factory, termOrder, termSize);
        this.ram = new ReferenceContainerCache<ReferenceType>(factory, termOrder, termSize);
        this.countCache = new ComparableARC(1000, termOrder);
        this.maxRamEntries = maxRamEntries;
        this.lastCleanup = System.currentTimeMillis();
        this.lastDump = System.currentTimeMillis();
        this.targetFileSize = targetFileSize;
        this.maxFileSize = maxFileSize;
        this.writeBufferSize = writeBufferSize;
        this.removeDelayedURLs = new TreeMap<byte[], HandleSet>(Word.commonHashOrder);
        this.flushShallRun = true;
        this.flushThread = new FlushThread(cellPath.toString());
        this.flushThread.start();
    }

    private boolean shrink(long targetFileSize, long maxFileSize) {
        if (this.array.entries() < 2) {
            return false;
        }
        boolean donesomething = false;
        int term = 10;
        while (term-- > 0 && (this.merger.queueLength() < 3 || this.array.entries() >= 50) && this.array.shrinkBestSmallFiles(this.merger, targetFileSize)) {
            donesomething = true;
        }
        term = 10;
        while (term-- > 0 && this.merger.queueLength() < 2 && this.array.shrinkAnySmallFiles(this.merger, targetFileSize)) {
            donesomething = true;
        }
        term = 10;
        while (term-- > 0 && this.merger.queueLength() < 1 && this.array.shrinkUpToMaxSizeFiles(this.merger, maxFileSize)) {
            donesomething = true;
        }
        term = 10;
        while (term-- > 0 && this.merger.queueLength() < 1 && this.array.shrinkOldFiles(this.merger)) {
            donesomething = true;
        }
        return donesomething;
    }

    public int deleteOld(int minsize, long maxtime) throws IOException {
        long timeout = System.currentTimeMillis() + maxtime;
        Collection<byte[]> keys = this.keys4LargeReferences(minsize, maxtime / 3L);
        int c = 0;
        int oldShrinkMaxsize = ReferenceContainer.maxReferences;
        ReferenceContainer.maxReferences = minsize;
        for (byte[] key : keys) {
            ReferenceContainer<ReferenceType> container = this.get(key, null);
            container.shrinkReferences();
            try {
                this.add(container);
                ++c;
            }
            catch (SpaceExceededException spaceExceededException) {
                // empty catch block
            }
            if (System.currentTimeMillis() <= timeout) continue;
            break;
        }
        ReferenceContainer.maxReferences = oldShrinkMaxsize;
        return c;
    }

    private Collection<byte[]> keys4LargeReferences(int minsize, long maxtime) throws IOException {
        long timeout = System.currentTimeMillis() + maxtime;
        ArrayList<byte[]> keys = new ArrayList<byte[]>();
        Iterator<ByteArray> ci = this.ram.keys();
        while (ci.hasNext()) {
            byte[] k = ci.next().asBytes();
            if (this.ram.count(k) < minsize) continue;
            keys.add(k);
        }
        CloneableIterator<byte[]> ki = this.array.keys(true, false);
        while (ki.hasNext()) {
            byte[] k = (byte[])ki.next();
            if (this.array.count(k) >= minsize) {
                keys.add(k);
            }
            if (System.currentTimeMillis() <= timeout) continue;
            break;
        }
        return keys;
    }

    @Override
    public int termKeyLength() {
        return this.ram.termKeyLength();
    }

    @Override
    public void add(ReferenceContainer<ReferenceType> newEntries) throws IOException, SpaceExceededException {
        try {
            this.ram.add(newEntries);
            long t = System.currentTimeMillis();
            if (this.ram.size() % 1000 == 0 || this.lastCleanup + 60000L < t || this.lastDump + 300000L < t) {
                EventTracker.update(EventTracker.EClass.WORDCACHE, this.ram.size(), true);
            }
        }
        catch (SpaceExceededException e) {
            EventTracker.update(EventTracker.EClass.WORDCACHE, this.ram.size(), true);
            this.ram.add(newEntries);
        }
    }

    @Override
    public void add(byte[] termHash, ReferenceType entry2) throws IOException, SpaceExceededException {
        try {
            this.ram.add(termHash, entry2);
            long t = System.currentTimeMillis();
            if (this.ram.size() % 1000 == 0 || this.lastCleanup + 60000L < t || this.lastDump + 300000L < t) {
                EventTracker.update(EventTracker.EClass.WORDCACHE, this.ram.size(), true);
            }
        }
        catch (SpaceExceededException e) {
            EventTracker.update(EventTracker.EClass.WORDCACHE, this.ram.size(), true);
            this.ram.add(termHash, entry2);
        }
    }

    @Override
    public boolean has(byte[] termHash) {
        if (this.ram.has(termHash)) {
            return true;
        }
        return this.array.has(termHash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int count(byte[] termHash) {
        Integer cachedCount = (Integer)this.countCache.get((Object)termHash);
        if (cachedCount != null) {
            return cachedCount;
        }
        int countFile = 0;
        try {
            countFile = this.array.count(termHash);
        }
        catch (Throwable e) {
            ConcurrentLog.logException(e);
        }
        assert (countFile >= 0);
        ReferenceContainer<ReferenceType> countRam = this.ram.get(termHash, null);
        assert (countRam == null || countRam.size() >= 0);
        int c = countRam == null ? countFile : countFile + countRam.size();
        Map<byte[], HandleSet> map = this.removeDelayedURLs;
        synchronized (map) {
            HandleSet s = this.removeDelayedURLs.get(termHash);
            if (s != null) {
                c -= s.size();
            }
            if (c < 0) {
                c = 0;
            }
        }
        if (MemoryControl.shortStatus()) {
            this.countCache.clear();
        }
        this.countCache.insert(termHash, c);
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReferenceContainer<ReferenceType> get(byte[] termHash, HandleSet urlselection) throws IOException {
        ReferenceContainer<ReferenceType> c0 = this.ram.get(termHash, null);
        ReferenceContainer<ReferenceType> c1 = null;
        try {
            c1 = this.array.get(termHash);
        }
        catch (SpaceExceededException e2) {
            ConcurrentLog.logException(e2);
        }
        ReferenceContainer<ReferenceType> result = null;
        if (c0 != null && c1 != null) {
            try {
                result = c1.merge(c0);
            }
            catch (SpaceExceededException e) {
                try {
                    result = c1.merge(c0);
                }
                catch (SpaceExceededException e1) {
                    result = c1.size() > c0.size() ? c1 : c0;
                }
            }
        } else if (c0 != null) {
            result = c0;
        } else if (c1 != null) {
            result = c1;
        }
        if (result == null) {
            return null;
        }
        Map<byte[], HandleSet> map = this.removeDelayedURLs;
        synchronized (map) {
            HandleSet s = this.removeDelayedURLs.get(termHash);
            if (s != null) {
                result.removeEntries(s);
            }
        }
        return result;
    }

    @Override
    public ReferenceContainer<ReferenceType> remove(byte[] termHash) throws IOException {
        this.removeDelayed();
        ReferenceContainer<ReferenceType> c1 = null;
        try {
            c1 = this.array.get(termHash);
        }
        catch (SpaceExceededException e2) {
            ConcurrentLog.logException(e2);
        }
        if (c1 != null) {
            this.array.delete(termHash);
        }
        ReferenceContainer<ReferenceType> c0 = this.ram.remove(termHash);
        if (c1 == null) {
            return c0;
        }
        if (c0 == null) {
            return c1;
        }
        try {
            return c1.merge(c0);
        }
        catch (SpaceExceededException e) {
            try {
                return c1.merge(c0);
            }
            catch (SpaceExceededException e1) {
                return c1.size() > c0.size() ? c1 : c0;
            }
        }
    }

    @Override
    public void delete(byte[] termHash) throws IOException {
        this.removeDelayed();
        ReferenceContainer<ReferenceType> c1 = null;
        try {
            c1 = this.array.get(termHash);
        }
        catch (SpaceExceededException e2) {
            ConcurrentLog.logException(e2);
        }
        if (c1 != null) {
            this.array.delete(termHash);
        }
        this.ram.delete(termHash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDelayed(byte[] termHash, byte[] urlHashBytes) {
        HandleSet r;
        Map<byte[], HandleSet> map = this.removeDelayedURLs;
        synchronized (map) {
            r = this.removeDelayedURLs.get(termHash);
        }
        if (r == null) {
            r = new RowHandleSet(12, (ByteOrder)Word.commonHashOrder, 0);
        }
        try {
            r.put(urlHashBytes);
        }
        catch (SpaceExceededException e) {
            try {
                this.remove(termHash, urlHashBytes);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        map = this.removeDelayedURLs;
        synchronized (map) {
            this.removeDelayedURLs.put(termHash, r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDelayed() throws IOException {
        RowHandleSet words = new RowHandleSet(12, (ByteOrder)Word.commonHashOrder, 0);
        Map<byte[], HandleSet> map = this.removeDelayedURLs;
        synchronized (map) {
            for (byte[] b : this.removeDelayedURLs.keySet()) {
                try {
                    words.put(b);
                }
                catch (SpaceExceededException spaceExceededException) {}
            }
        }
        map = this.removeDelayedURLs;
        synchronized (map) {
            for (byte[] b : words) {
                HandleSet urls2 = this.removeDelayedURLs.remove(b);
                if (urls2 == null) continue;
                this.remove(b, urls2);
            }
        }
        this.countCache.clear();
    }

    @Override
    public int remove(byte[] termHash, HandleSet urlHashes) throws IOException {
        int reduced;
        this.countCache.remove((Object)termHash);
        int removed = this.ram.remove(termHash, urlHashes);
        try {
            reduced = this.array.reduce(termHash, new RemoveReducer(urlHashes));
        }
        catch (SpaceExceededException e) {
            reduced = 0;
            ConcurrentLog.warn("KELONDRO", "IndexCell: not possible to remove urlHashes from a RWI because of too low memory. Remove was not applied. Please increase RAM assignment");
        }
        return removed + reduced / this.array.rowdef().objectsize;
    }

    @Override
    public boolean remove(byte[] termHash, byte[] urlHashBytes) throws IOException {
        int reduced;
        this.countCache.remove((Object)termHash);
        boolean removed = this.ram.remove(termHash, urlHashBytes);
        try {
            reduced = this.array.reduce(termHash, new RemoveReducer(urlHashBytes));
        }
        catch (SpaceExceededException e) {
            reduced = 0;
            ConcurrentLog.warn("KELONDRO", "IndexCell: not possible to remove urlHashes from a RWI because of too low memory. Remove was not applied. Please increase RAM assignment");
        }
        return removed || reduced > 0;
    }

    @Override
    public Iterator<ReferenceContainer<ReferenceType>> iterator() {
        return this.referenceContainerIterator(null, false, false);
    }

    @Override
    public CloneableIterator<Rating<byte[]>> referenceCountIterator(byte[] starttermHash, boolean rot, boolean excludePrivate) {
        return this.array.referenceCountIterator(starttermHash, false, excludePrivate);
    }

    @Override
    public CloneableIterator<ReferenceContainer<ReferenceType>> referenceContainerIterator(byte[] startTermHash, boolean rot, boolean excludePrivate) {
        return this.referenceContainerIterator(startTermHash, rot, excludePrivate, false);
    }

    @Override
    public CloneableIterator<ReferenceContainer<ReferenceType>> referenceContainerIterator(byte[] startTermHash, boolean rot, boolean excludePrivate, boolean ram) {
        ReferenceContainerOrder containerOrder = new ReferenceContainerOrder(this.factory, (Order<byte[]>)this.ram.rowdef().getOrdering().clone());
        containerOrder.rotate(new ReferenceContainer(this.factory, startTermHash));
        if (ram) {
            return this.ram.referenceContainerIterator(startTermHash, rot, excludePrivate);
        }
        return new MergeIterator<ReferenceContainer<ReferenceType>>(this.ram.referenceContainerIterator(startTermHash, rot, excludePrivate), new MergeIterator<ReferenceContainer<ReferenceType>>(this.ram.referenceContainerIterator(startTermHash, false, excludePrivate), this.array.referenceContainerIterator(startTermHash, false, excludePrivate), containerOrder, ReferenceContainer.containerMergeMethod, true), containerOrder, ReferenceContainer.containerMergeMethod, true);
    }

    @Override
    public synchronized void clear() throws IOException {
        this.countCache.clear();
        this.removeDelayedURLs.clear();
        this.ram.clear();
        this.array.clear();
        if (Switchboard.getSwitchboard() != null && Switchboard.getSwitchboard().peers != null && Switchboard.getSwitchboard().peers.mySeed() != null) {
            Switchboard.getSwitchboard().peers.mySeed().resetCounters();
        }
    }

    public synchronized void clearCache() {
        this.countCache.clear();
    }

    @Override
    public synchronized void close() {
        this.countCache.clear();
        try {
            this.removeDelayed();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!this.ram.isEmpty()) {
            this.ram.dump(this.array.newContainerBLOBFile(), (int)Math.min(MemoryControl.available() / 3L, (long)this.writeBufferSize), true);
        }
        this.flushShallRun = false;
        if (this.flushThread != null) {
            try {
                this.flushThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.ram.close();
        this.array.close();
    }

    public boolean isEmpty() {
        if (this.ram.size() > 0) {
            return false;
        }
        for (int s : this.array.sizes()) {
            if (s <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("an accumulated size of index entries would not reflect the real number of words, which cannot be computed easily");
    }

    private int[] sizes() {
        int[] as = this.array.sizes();
        int[] asr = new int[as.length + 1];
        System.arraycopy(as, 0, asr, 0, as.length);
        asr[as.length] = this.ram.size();
        return asr;
    }

    public int sizesMax() {
        int[] s;
        int m = 0;
        for (int element : s = this.sizes()) {
            if (element <= m) continue;
            m = element;
        }
        return m;
    }

    public int getSegmentCount() {
        return this.array.entries();
    }

    @Override
    public int minMem() {
        return 0xA00000;
    }

    @Override
    public ByteOrder termKeyOrdering() {
        return this.array.ordering();
    }

    @Override
    public long getBufferMaxAge() {
        return System.currentTimeMillis();
    }

    @Override
    public int getBufferMaxReferences() {
        return this.ram.maxReferences();
    }

    @Override
    public long getBufferMinAge() {
        return System.currentTimeMillis();
    }

    @Override
    public int getBufferSize() {
        return this.ram.size();
    }

    @Override
    public long getBufferSizeBytes() {
        return this.ram.usedMemory();
    }

    @Override
    public void setBufferMaxWordCount(int maxWords) {
        this.maxRamEntries = maxWords;
    }

    private class FlushThread
    extends Thread {
        public FlushThread(String name) {
            super("IndexCell.FlushThread(" + name + ")");
        }

        @Override
        public void run() {
            while (IndexCell.this.flushShallRun) {
                try {
                    this.flushBuffer();
                }
                catch (Throwable e) {
                    ConcurrentLog.logException(e);
                }
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flushBuffer() {
            Object object;
            long t = System.currentTimeMillis();
            if (IndexCell.this.ram.size() >= IndexCell.this.maxRamEntries || IndexCell.this.ram.size() > 2000 && !MemoryControl.request(0x7800000L, false) || !IndexCell.this.ram.isEmpty() && IndexCell.this.lastDump + 300000L < t) {
                object = IndexCell.this.merger;
                synchronized (object) {
                    if (IndexCell.this.ram.size() >= IndexCell.this.maxRamEntries || IndexCell.this.ram.size() > 3000 && !MemoryControl.request(0x5000000L, false) || !IndexCell.this.ram.isEmpty() && IndexCell.this.lastDump + 300000L < t) {
                        try {
                            ReferenceContainerCache ramdump;
                            IndexCell.this.lastDump = System.currentTimeMillis();
                            try {
                                IndexCell.this.removeDelayed();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            File dumpFile = IndexCell.this.array.newContainerBLOBFile();
                            ByteOrder termOrder = IndexCell.this.ram.termKeyOrdering();
                            int termSize = IndexCell.this.ram.termKeyLength();
                            FlushThread flushThread = this;
                            synchronized (flushThread) {
                                ramdump = IndexCell.this.ram;
                                IndexCell.this.ram = new ReferenceContainerCache(IndexCell.this.factory, termOrder, termSize);
                            }
                            IndexCell.this.merger.dump(ramdump, dumpFile, IndexCell.this.array);
                            IndexCell.this.lastDump = System.currentTimeMillis();
                        }
                        catch (Throwable e) {
                            ConcurrentLog.logException(e);
                        }
                    }
                }
            }
            if (IndexCell.this.array.entries() > 50 || IndexCell.this.lastCleanup + 60000L < t) {
                object = IndexCell.this.array;
                synchronized (object) {
                    if (IndexCell.this.array.entries() > 50 || IndexCell.this.lastCleanup + 60000L < System.currentTimeMillis()) {
                        try {
                            IndexCell.this.lastCleanup = System.currentTimeMillis();
                            IndexCell.this.shrink(IndexCell.this.targetFileSize, IndexCell.this.maxFileSize);
                            IndexCell.this.lastCleanup = System.currentTimeMillis();
                        }
                        catch (Throwable e) {
                            ConcurrentLog.logException(e);
                        }
                    }
                }
            }
        }
    }

    private static class RemoveReducer<ReferenceType extends Reference>
    implements ReferenceContainerArray.ContainerReducer<ReferenceType> {
        HandleSet urlHashes;

        public RemoveReducer(HandleSet urlHashes) {
            this.urlHashes = urlHashes;
        }

        public RemoveReducer(byte[] urlHashBytes) {
            this.urlHashes = new RowHandleSet(12, (ByteOrder)Word.commonHashOrder, 0);
            try {
                this.urlHashes.put(urlHashBytes);
            }
            catch (SpaceExceededException e) {
                ConcurrentLog.logException(e);
            }
        }

        @Override
        public ReferenceContainer<ReferenceType> reduce(ReferenceContainer<ReferenceType> container) {
            container.sort();
            container.removeEntries(this.urlHashes);
            return container;
        }
    }
}

