/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.rwi;

import java.io.IOException;
import java.util.Iterator;
import java.util.TreeMap;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.storage.HandleSet;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.index.Row;
import net.yacy.kelondro.rwi.Index;
import net.yacy.kelondro.rwi.Reference;
import net.yacy.kelondro.rwi.ReferenceContainer;
import net.yacy.kelondro.rwi.ReferenceFactory;
import net.yacy.kelondro.rwi.TermSearch;

public abstract class AbstractIndex<ReferenceType extends Reference>
implements Index<ReferenceType> {
    protected final ReferenceFactory<ReferenceType> factory;

    public AbstractIndex(ReferenceFactory<ReferenceType> factory) {
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void merge(Index<ReferenceType> otherIndex) throws IOException, SpaceExceededException {
        for (ReferenceContainer referenceContainer : otherIndex) {
            byte[] term = referenceContainer.getTermHash();
            AbstractIndex abstractIndex = this;
            synchronized (abstractIndex) {
                ReferenceContainer container = this.get(term, null);
                if (container == null) {
                    this.add(referenceContainer);
                } else {
                    container.merge(referenceContainer);
                    this.delete(term);
                    this.add(container);
                }
            }
        }
    }

    @Override
    public int remove(HandleSet termHashes, byte[] urlHashBytes) throws IOException {
        Iterator<byte[]> i = termHashes.iterator();
        int c = 0;
        while (i.hasNext()) {
            if (!this.remove(i.next(), urlHashBytes)) continue;
            ++c;
        }
        return c;
    }

    @Override
    public TreeMap<byte[], ReferenceContainer<ReferenceType>> searchConjunction(HandleSet wordHashes, HandleSet urlselection) {
        TreeMap<byte[], ReferenceContainer<ReferenceType>> containers = new TreeMap<byte[], ReferenceContainer<ReferenceType>>(Base64Order.enhancedCoder);
        for (byte[] singleHash : wordHashes) {
            ReferenceContainer singleContainer;
            try {
                singleContainer = this.get(singleHash, urlselection);
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
                continue;
            }
            if (singleContainer == null || singleContainer.isEmpty()) {
                return new TreeMap<byte[], ReferenceContainer<ReferenceType>>(Base64Order.enhancedCoder);
            }
            containers.put(singleHash, singleContainer);
        }
        return containers;
    }

    public TermSearch<ReferenceType> query(HandleSet queryHashes, HandleSet excludeHashes, HandleSet urlselection, ReferenceFactory<ReferenceType> termFactory, int maxDistance) throws SpaceExceededException {
        return new TermSearch<ReferenceType>(this, queryHashes, excludeHashes, urlselection, termFactory, maxDistance);
    }

    @Override
    public Row referenceRow() {
        return this.factory.getRow();
    }
}

