/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.logging;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import net.yacy.kelondro.util.MemoryControl;

public class GuiHandler
extends Handler {
    private static final int DEFAULT_SIZE = 10000;
    private static int size = 10000;
    private static String[] buffer;
    private static int start;
    private static int count;

    public GuiHandler() {
        LogManager manager = LogManager.getLogManager();
        String className = this.getClass().getName();
        String level = manager.getProperty(className + ".level");
        this.setLevel(level == null ? Level.INFO : Level.parse(level));
        this.setFilter(GuiHandler.makeFilter(manager.getProperty(className + ".filter")));
        this.setFormatter(GuiHandler.makeFormatter(manager.getProperty(className + ".formatter")));
        try {
            size = Integer.parseInt(manager.getProperty(className + ".size"));
        }
        catch (NumberFormatException e) {
            size = 10000;
        }
        buffer = new String[size];
        start = 0;
        count = 0;
    }

    private static Filter makeFilter(String name) {
        if (name == null) {
            return null;
        }
        try {
            return (Filter)Class.forName(name).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            System.err.println("Unable to load filter: " + name);
            return null;
        }
    }

    private static Formatter makeFormatter(String name) {
        if (name == null) {
            return null;
        }
        try {
            return (Formatter)Class.forName(name).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            return new SimpleFormatter();
        }
    }

    public final int getSize() {
        return size;
    }

    @Override
    public final synchronized void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        int ix = (start + count) % buffer.length;
        GuiHandler.buffer[ix] = this.getFormatter().format(record);
        if (count < buffer.length) {
            ++count;
        } else {
            ++start;
        }
        this.flush();
        if (MemoryControl.shortStatus()) {
            GuiHandler.clear();
        }
    }

    public final synchronized String[] getLogLines(boolean reversed, int lineCount) {
        if (lineCount > count || lineCount < 0) {
            lineCount = count;
        }
        ArrayList<String> logMessages = new ArrayList<String>(count);
        try {
            int theStart = reversed ? start + count - 1 : start + count - lineCount;
            String record = null;
            for (int i = 0; i < lineCount; ++i) {
                int ix = reversed ? Math.abs((theStart - i) % buffer.length) : (theStart + i) % buffer.length;
                record = buffer[ix];
                logMessages.add(record);
            }
            return logMessages.toArray(new String[logMessages.size()]);
        }
        catch (Exception ex) {
            this.reportError(null, ex, 5);
            return new String[]{"Error while formatting the logging message"};
        }
    }

    @Override
    public void flush() {
    }

    public static void clear() {
        Arrays.fill(buffer, null);
        start = 0;
        count = 0;
    }

    @Override
    public synchronized void close() throws SecurityException {
    }
}

