/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.data.navigation;

import java.util.Collection;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.order.ByteOrder;
import net.yacy.kelondro.data.navigation.NavigationReference;
import net.yacy.kelondro.index.Column;
import net.yacy.kelondro.index.Row;
import net.yacy.kelondro.rwi.AbstractReference;
import net.yacy.kelondro.rwi.Reference;

public final class NavigationReferenceRow
extends AbstractReference
implements NavigationReference,
Cloneable {
    public static final Row navEntryRow = new Row(new Column[]{new Column("n", 3, 3, 24, "navhash"), new Column("c", 4, 2, 1, "hitcount"), new Column("p", 4, 2, 2, "posintext"), new Column("f", 4, 2, 1, "reserve")}, (ByteOrder)Base64Order.enhancedCoder);
    private static final int col_navhash = 0;
    private static final int col_count = 1;
    private static final int col_pos = 2;
    private static final int col_flags = 3;
    private final Row.Entry entry;

    public NavigationReferenceRow(byte[] termhash, byte[] refhash, int count, int pos, byte flags) {
        assert (termhash.length == 12) : "termhash = " + ASCII.String(termhash);
        assert (refhash.length == 12) : "refhash = " + ASCII.String(refhash);
        this.entry = navEntryRow.newEntry();
        this.entry.setCol(0, ASCII.String(termhash) + ASCII.String(refhash));
        this.entry.setCol(1, count);
        this.entry.setCol(2, pos);
        this.entry.setCol(3, flags);
    }

    private NavigationReferenceRow(byte[] row) {
        this.entry = navEntryRow.newEntry(row);
    }

    public NavigationReferenceRow(Row.Entry entry2) {
        this.entry = entry2;
    }

    public NavigationReferenceRow clone() {
        byte[] b = new byte[NavigationReferenceRow.navEntryRow.objectsize];
        System.arraycopy(this.entry.bytes(), 0, b, 0, NavigationReferenceRow.navEntryRow.objectsize);
        return new NavigationReferenceRow(b);
    }

    @Override
    public String toPropertyForm() {
        return this.entry.toPropertyForm('=', true, true, false, false);
    }

    @Override
    public Row.Entry toKelondroEntry() {
        return this.entry;
    }

    @Override
    public String navigationHash() {
        return this.entry.getColASCII(0);
    }

    @Override
    public byte[] urlhash() {
        return ASCII.getBytes(this.navigationHash().substring(12));
    }

    @Override
    public byte[] termHash() {
        return ASCII.getBytes(this.navigationHash().substring(0, 12));
    }

    @Override
    public int hitcount() {
        return (int)this.entry.getColLong(1);
    }

    @Override
    public int position(int p) {
        assert (p == 0) : "p = " + p;
        return (int)this.entry.getColLong(2);
    }

    @Override
    public byte flags() {
        return (byte)this.entry.getColLong(3);
    }

    @Override
    public String toString() {
        return this.toPropertyForm();
    }

    @Override
    public int hashCode() {
        return this.navigationHash().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NavigationReferenceRow)) {
            return false;
        }
        NavigationReferenceRow other = (NavigationReferenceRow)obj;
        return this.navigationHash().equals(other.navigationHash());
    }

    @Override
    public boolean isOlder(Reference other) {
        return false;
    }

    @Override
    public void join(Reference oe) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long lastModified() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<Integer> positions() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int posintext() {
        throw new UnsupportedOperationException();
    }
}

