/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.blob;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import net.yacy.cora.util.ByteBuffer;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.blob.BEncodedHeap;
import net.yacy.kelondro.blob.TablesColumnIndex;
import net.yacy.kelondro.data.word.Word;

public class TablesColumnBLOBIndex
extends TablesColumnIndex {
    private final BEncodedHeap index;
    private static final byte SEPERATOR = 44;

    public TablesColumnBLOBIndex(BEncodedHeap bheap) {
        super(TablesColumnIndex.INDEXTYPE.BLOB);
        this.index = bheap;
    }

    public static Collection<byte[]> byteToCollection(byte[] b) {
        List<byte[]> PKset = ByteBuffer.split(b, (byte)44);
        return PKset;
    }

    public static byte[] CollectionToByte(Collection<byte[]> bc) {
        ByteBuffer buf = new ByteBuffer(15 * bc.size());
        Iterator<byte[]> iter = bc.iterator();
        while (iter.hasNext()) {
            buf.append(iter.next());
            buf.append((byte)44);
        }
        byte[] b = buf.getBytes();
        try {
            buf.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return b;
    }

    @Override
    public void deleteIndex(String columnName) {
        byte[] column = Word.word2hash(columnName);
        try {
            this.index.remove(column);
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        catch (SpaceExceededException e) {
            ConcurrentLog.logException(e);
        }
    }

    @Override
    protected void insertPK(String columnName, String columnValue, byte[] pk) {
        byte[] column = Word.word2hash(columnName);
        try {
            Collection<Object> PKset;
            Map<String, byte[]> valueIdxMap = this.index.get(column);
            if (valueIdxMap != null) {
                if (valueIdxMap.containsKey(columnValue)) {
                    PKset = TablesColumnBLOBIndex.byteToCollection(valueIdxMap.get(columnValue));
                    if (!ByteBuffer.contains(PKset, pk)) {
                        PKset.add(pk);
                    }
                } else {
                    PKset = new ArrayList(1);
                    PKset.add(pk);
                    valueIdxMap.put(columnValue, TablesColumnBLOBIndex.CollectionToByte(PKset));
                }
            } else {
                PKset = new ArrayList<byte[]>(1);
                PKset.add(pk);
                valueIdxMap = new ConcurrentHashMap<String, byte[]>();
            }
            valueIdxMap.put(columnValue, TablesColumnBLOBIndex.CollectionToByte(PKset));
            this.index.insert(column, valueIdxMap);
            return;
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        catch (SpaceExceededException e) {
            ConcurrentLog.logException(e);
        }
    }

    @Override
    protected void removePK(byte[] pk) {
        for (Map.Entry<byte[], Map<String, byte[]>> entry2 : this.index) {
            Iterator<Map.Entry<String, byte[]>> viter = entry2.getValue().entrySet().iterator();
            while (viter.hasNext()) {
                Map.Entry<String, byte[]> columnValue = viter.next();
                Collection<byte[]> PKset = TablesColumnBLOBIndex.byteToCollection(columnValue.getValue());
                ByteBuffer.remove(PKset, pk);
                if (PKset.isEmpty()) {
                    viter.remove();
                    continue;
                }
                columnValue.setValue(TablesColumnBLOBIndex.CollectionToByte(PKset));
            }
            try {
                this.index.insert(entry2.getKey(), entry2.getValue());
            }
            catch (SpaceExceededException e) {
                ConcurrentLog.logException(e);
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
        }
    }

    @Override
    public void clear() {
        this.index.clear();
    }

    @Override
    public Collection<String> columns() {
        return this.index.columns();
    }

    @Override
    public Set<String> keySet(String columnName) {
        byte[] column = Word.word2hash(columnName);
        if (this.index.containsKey((Object)column)) {
            try {
                return new TreeSet<String>(this.index.get(column).keySet());
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
            catch (SpaceExceededException e) {
                ConcurrentLog.logException(e);
            }
        }
        return new TreeSet<String>();
    }

    @Override
    public boolean containsKey(String columnName, String key) {
        byte[] column = Word.word2hash(columnName);
        if (this.index.containsKey((Object)column)) {
            try {
                return this.index.get(column).containsKey(key);
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
            catch (SpaceExceededException e) {
                ConcurrentLog.logException(e);
            }
        }
        return false;
    }

    @Override
    public boolean hasIndex(String columnName) {
        byte[] column = Word.word2hash(columnName);
        return this.index.containsKey((Object)column);
    }

    @Override
    public Collection<byte[]> get(String columnName, String key) {
        byte[] column = Word.word2hash(columnName.toLowerCase());
        try {
            return TablesColumnBLOBIndex.byteToCollection(this.index.get(column).get(key));
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        catch (SpaceExceededException e) {
            ConcurrentLog.logException(e);
        }
        return new ArrayList<byte[]>();
    }

    @Override
    public int size(String columnName) {
        byte[] column = Word.word2hash(columnName.toLowerCase());
        if (this.index.containsKey((Object)column)) {
            try {
                return this.index.get(column).size();
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
            catch (SpaceExceededException e) {
                ConcurrentLog.logException(e);
            }
        }
        return -1;
    }

    @Override
    public int size() {
        return this.index.size();
    }
}

