/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.blob;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.yacy.cora.order.ByteOrder;
import net.yacy.cora.order.CloneableIterator;
import net.yacy.cora.util.ByteArray;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.blob.BLOB;
import net.yacy.kelondro.util.MemoryControl;

public class Compressor
implements BLOB,
Iterable<byte[]> {
    private static byte[] gzipMagic = new byte[]{122, 124};
    private static byte[] plainMagic = new byte[]{112, 124};
    private final BLOB backend;
    private TreeMap<byte[], byte[]> buffer;
    private volatile long bufferlength;
    private final long maxbufferlength;
    private volatile long lockTimeout;
    private final ReentrantLock lock;
    private volatile int compressionLevel;

    public Compressor(BLOB backend, long buffersize, long lockTimeout, int compressionLevel) {
        this.backend = backend;
        this.maxbufferlength = buffersize;
        this.lockTimeout = lockTimeout;
        this.lock = new ReentrantLock();
        this.compressionLevel = Math.max(0, Math.min(9, compressionLevel));
        this.initBuffer();
    }

    @Override
    public long mem() {
        return this.backend.mem();
    }

    @Override
    public void optimize() {
        this.backend.optimize();
    }

    @Override
    public String name() {
        return this.backend.name();
    }

    @Override
    public void clear() throws IOException {
        this.lock.lock();
        try {
            this.initBuffer();
            this.backend.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void initBuffer() {
        this.buffer = new TreeMap(this.backend.ordering());
        this.bufferlength = 0L;
    }

    @Override
    public ByteOrder ordering() {
        return this.backend.ordering();
    }

    @Override
    public void close(boolean writeIDX) {
        this.lock.lock();
        try {
            this.flushAll();
            this.backend.close(writeIDX);
        }
        finally {
            this.lock.unlock();
        }
    }

    private static byte[] compress(byte[] b, int compressionLevel) {
        int l = b.length;
        if (l < 100) {
            return Compressor.markWithPlainMagic(b);
        }
        byte[] bb = Compressor.compressAddMagic(b, compressionLevel);
        if (bb.length >= l) {
            return Compressor.markWithPlainMagic(b);
        }
        return bb;
    }

    private static byte[] compressAddMagic(byte[] b, final int compressionLevel) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(b.length / 5);
            baos.write(gzipMagic);
            GZIPOutputStream os = new GZIPOutputStream((OutputStream)baos, 65536){
                {
                    super(arg0, arg1);
                    this.def.setLevel(compressionLevel);
                }
            };
            ((OutputStream)os).write(b);
            ((OutputStream)os).close();
            baos.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            ConcurrentLog.severe("KELONDRO", "Compressor", e);
            return null;
        }
    }

    private static byte[] markWithPlainMagic(byte[] b) {
        byte[] r = new byte[b.length + 2];
        r[0] = plainMagic[0];
        r[1] = plainMagic[1];
        System.arraycopy(b, 0, r, 2, b.length);
        return r;
    }

    private static byte[] decompress(byte[] b) {
        if (b == null) {
            return null;
        }
        if (ByteArray.startsWith(b, gzipMagic)) {
            ByteArrayInputStream bais = new ByteArrayInputStream(b);
            bais.read();
            bais.read();
            try {
                int n;
                GZIPInputStream gis = new GZIPInputStream(bais);
                ByteArrayOutputStream baos = new ByteArrayOutputStream(b.length);
                byte[] buf = new byte[4096];
                while ((n = ((InputStream)gis).read(buf)) > 0) {
                    baos.write(buf, 0, n);
                }
                ((InputStream)gis).close();
                bais.close();
                baos.close();
                return baos.toByteArray();
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
                return null;
            }
        }
        if (ByteArray.startsWith(b, plainMagic)) {
            byte[] r = new byte[b.length - 2];
            System.arraycopy(b, 2, r, 0, b.length - 2);
            return r;
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] get(byte[] key) throws IOException, SpaceExceededException {
        byte[] b = null;
        boolean locked = false;
        try {
            locked = this.lock.tryLock(this.lockTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ignored) {
            ConcurrentLog.fine("KELONDRO", "Compressor: Interrupted while acquiring a synchronzation lock on get()");
        }
        if (locked) {
            try {
                b = this.buffer.remove(key);
                if (b != null) {
                    this.bufferlength -= (long)b.length;
                    this.backend.insert(key, Compressor.compress(b, this.compressionLevel));
                    byte[] byArray = b;
                    return byArray;
                }
            }
            finally {
                this.lock.unlock();
            }
            b = this.backend.get(key);
            if (b == null) {
                return null;
            }
            if (!MemoryControl.request(b.length * 2, true)) {
                throw new SpaceExceededException(b.length * 2, "decompress needs 2 * " + b.length + " bytes");
            }
            return Compressor.decompress(b);
        }
        ConcurrentLog.fine("KELONDRO", "Compressor: Could not acquire a synchronization lock for retrieval within " + this.lockTimeout + " milliseconds");
        return b;
    }

    @Override
    public byte[] get(Object key) {
        if (!(key instanceof byte[])) {
            return null;
        }
        try {
            return this.get((byte[])key);
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        catch (SpaceExceededException e) {
            ConcurrentLog.logException(e);
        }
        return null;
    }

    @Override
    public boolean containsKey(byte[] key) {
        this.lock.lock();
        try {
            boolean bl = this.buffer.containsKey(key) || this.backend.containsKey(key);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int keylength() {
        return this.backend.keylength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long length() {
        this.lock.lock();
        try {
            long l = this.backend.length() + this.bufferlength;
            return l;
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
            long l = 0L;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long length(byte[] key) throws IOException {
        this.lock.lock();
        try {
            byte[] b = this.buffer.get(key);
            if (b != null) {
                long l = b.length;
                return l;
            }
            b = this.backend.get(key);
            if (b == null) {
                long l = 0L;
                return l;
            }
            long l = (b = Compressor.decompress(b)) == null ? 0L : (long)b.length;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    private int removeFromQueues(byte[] key) {
        byte[] b = this.buffer.remove(key);
        if (b != null) {
            return b.length;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(byte[] key, byte[] b) throws IOException {
        boolean locked = false;
        try {
            locked = this.lock.tryLock(this.lockTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ignored) {
            ConcurrentLog.fine("KELONDRO", "Compressor: Interrupted while acquiring a synchronzation lock on insert()");
        }
        if (locked) {
            try {
                this.delete(key);
                if (this.bufferlength + (long)(b.length * 2) > this.maxbufferlength) {
                    while (this.bufferlength + (long)(b.length * 2) > this.maxbufferlength && !this.buffer.isEmpty()) {
                        this.flushOne();
                    }
                    if (this.bufferlength + (long)(b.length * 2) > this.maxbufferlength) {
                        this.flushAll();
                    }
                }
                this.buffer.put(key, b);
                this.bufferlength += (long)b.length;
            }
            finally {
                this.lock.unlock();
            }
            if (MemoryControl.shortStatus()) {
                this.flushAll();
            }
        } else {
            ConcurrentLog.fine("KELONDRO", "Compressor: Could not acquire a synchronization lock for insertion within " + this.lockTimeout + " milliseconds");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(byte[] key) throws IOException {
        this.lock.lock();
        try {
            this.backend.delete(key);
            long rx = this.removeFromQueues(key);
            if (rx > 0L) {
                this.bufferlength -= rx;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int size() {
        this.lock.lock();
        try {
            int n = this.backend.size() + this.buffer.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        this.lock.lock();
        try {
            if (!this.backend.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            if (!this.buffer.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloneableIterator<byte[]> keys(boolean up, boolean rotating) throws IOException {
        this.lock.lock();
        try {
            this.flushAll();
            CloneableIterator<byte[]> cloneableIterator = this.backend.keys(up, rotating);
            return cloneableIterator;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloneableIterator<byte[]> keys(boolean up, byte[] firstKey) throws IOException {
        this.lock.lock();
        try {
            this.flushAll();
            CloneableIterator<byte[]> cloneableIterator = this.backend.keys(up, firstKey);
            return cloneableIterator;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Iterator<byte[]> iterator() {
        this.flushAll();
        try {
            return this.backend.keys(true, false);
        }
        catch (IOException e) {
            return null;
        }
    }

    private boolean flushOne() {
        if (this.buffer.isEmpty()) {
            return false;
        }
        Map.Entry<byte[], byte[]> entry2 = this.buffer.entrySet().iterator().next();
        this.buffer.remove(entry2.getKey());
        try {
            this.backend.insert(entry2.getKey(), Compressor.compress(entry2.getValue(), this.compressionLevel));
            this.bufferlength -= (long)entry2.getValue().length;
            return true;
        }
        catch (IOException e) {
            this.buffer.put(entry2.getKey(), entry2.getValue());
            return false;
        }
    }

    public void flushAll() {
        this.lock.lock();
        try {
            while (!this.buffer.isEmpty() && this.flushOne()) {
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int replace(byte[] key, BLOB.Rewriter rewriter) throws IOException, SpaceExceededException {
        byte[] b = this.get(key);
        if (b == null) {
            return 0;
        }
        byte[] c = rewriter.rewrite(b);
        int reduction = c.length - b.length;
        assert (reduction >= 0);
        if (reduction == 0) {
            return 0;
        }
        this.insert(key, c);
        return reduction;
    }

    @Override
    public int reduce(byte[] key, BLOB.Reducer reducer) throws IOException, SpaceExceededException {
        byte[] b = this.get(key);
        if (b == null) {
            return 0;
        }
        byte[] c = reducer.rewrite(b);
        int reduction = c.length - b.length;
        assert (reduction >= 0);
        if (reduction == 0) {
            return 0;
        }
        this.insert(key, c);
        return reduction;
    }

    public void setCompressionLevel(int compressionLevel) {
        this.compressionLevel = Math.max(0, Math.min(9, compressionLevel));
    }

    public void setLockTimeout(long lockTimeout) {
        this.lockTimeout = lockTimeout;
    }
}

