/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.http;

import net.yacy.cora.order.Base64Order;
import net.yacy.cora.order.Digest;
import net.yacy.search.Switchboard;
import net.yacy.server.serverAccessTracker;
import org.eclipse.jetty.util.security.Credential;

public class YaCyLegacyCredential
extends Credential {
    private static final long serialVersionUID = -3527894085562480001L;
    private String hash;
    private String foruser;
    private boolean isBase64enc;
    private Credential c;

    public static String calcHash(String pw) {
        return Digest.encodeMD5Hex(Base64Order.standardCoder.encodeString(pw));
    }

    public boolean check(Object credentials) {
        if (credentials instanceof Credential) {
            if (this.c == null) {
                return false;
            }
            Credential credential = (Credential)credentials;
            return credential.check((Object)this.c);
        }
        if (credentials instanceof String) {
            String pw = (String)credentials;
            if (this.isBase64enc) {
                if (serverAccessTracker.timeSinceAccessFromLocalhost() < 100L && pw.equals(this.hash)) {
                    return true;
                }
                return YaCyLegacyCredential.calcHash(this.foruser + ":" + pw).equals(this.hash);
            }
            if (this.hash.startsWith("MD5:") && this.hash != null) {
                String realm = Switchboard.getSwitchboard().getConfig("adminRealm", "");
                boolean success = Digest.encodeMD5Hex(this.foruser + ":" + realm + ":" + pw).equals(this.hash.substring(4));
                if (!success && this.foruser.equals(Switchboard.getSwitchboard().getConfig("adminAccountUserName", "admin")) && pw.equals(this.hash) && serverAccessTracker.timeSinceAccessFromLocalhost() < 100L) {
                    return true;
                }
                return success;
            }
            return Digest.encodeMD5Hex(this.foruser + ":" + pw).equals(this.hash);
        }
        throw new UnsupportedOperationException();
    }

    public static Credential getCredentialForAdmin(String username, String configHash) {
        YaCyLegacyCredential yc = new YaCyLegacyCredential();
        if (configHash.startsWith("MD5:")) {
            yc.isBase64enc = false;
            yc.c = Credential.getCredential((String)configHash);
        } else {
            yc.isBase64enc = true;
        }
        yc.foruser = username;
        yc.hash = configHash;
        return yc;
    }

    public static Credential getCredentialForUserDB(String username, String configHash) {
        YaCyLegacyCredential yc = new YaCyLegacyCredential();
        yc.c = Credential.getCredential((String)configHash);
        yc.foruser = username;
        yc.isBase64enc = false;
        yc.hash = configHash;
        return yc;
    }
}

