/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.awt.Dimension;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import net.yacy.cora.date.GenericFormatter;
import net.yacy.cora.date.ISO8601Formatter;
import net.yacy.cora.document.analysis.Classification;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.feed.RSSMessage;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.protocol.HeaderFramework;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.Memory;
import net.yacy.crawler.data.Cache;
import net.yacy.crawler.data.Transactions;
import net.yacy.data.URLLicense;
import net.yacy.data.UserDB;
import net.yacy.document.parser.html.IconEntry;
import net.yacy.http.servlets.TemplateMissingParameterException;
import net.yacy.kelondro.data.meta.URIMetadataNode;
import net.yacy.kelondro.util.Formatter;
import net.yacy.peers.Seed;
import net.yacy.peers.graphics.ProfilingGraph;
import net.yacy.search.EventTracker;
import net.yacy.search.Switchboard;
import net.yacy.search.navigator.Navigator;
import net.yacy.search.query.HeuristicResult;
import net.yacy.search.query.QueryParams;
import net.yacy.search.query.SearchEvent;
import net.yacy.search.query.SearchEventCache;
import net.yacy.search.query.SearchEventType;
import net.yacy.search.snippet.TextSnippet;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;
import net.yacy.utils.crypt;
import net.yacy.utils.nxTools;
import net.yacy.visualization.ImageViewer;

public class yacysearchitem {
    private static final String SHORTEN_SUFFIX = "...";
    private static final int SHORTEN_SUFFIX_LENGTH = "...".length();
    private static final int MAX_NAME_LENGTH = 60;
    private static final int MAX_URL_LENGTH = 120;
    private static final int DEFAULT_IMG_WIDTH = 256;
    private static final int DEFAULT_IMG_HEIGHT = 256;

    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        long timeout;
        if (post == null) {
            throw new TemplateMissingParameterException("The eventID parameter is required");
        }
        Switchboard sb = (Switchboard)env;
        serverObjects prop = new serverObjects();
        String eventID = post.get("eventID", "");
        boolean adminAuthenticated = sb.verifyAuthentication(header);
        UserDB.Entry user = sb.userDB != null ? sb.userDB.getUser(header) : null;
        boolean authenticated = adminAuthenticated || user != null;
        boolean extendedSearchRights = adminAuthenticated || user != null && user.hasRight(UserDB.AccessRight.EXTENDED_SEARCH_RIGHT);
        int item = post.getInt("item", -1);
        RequestHeader.FileType fileType = header.fileType();
        if (post.containsKey("auth") && !adminAuthenticated && user == null) {
            prop.authenticationRequired();
            return prop;
        }
        prop.put("content", "0");
        prop.put("rss", "0");
        prop.put("references", "0");
        prop.put("rssreferences", "0");
        prop.put("dynamic", "0");
        prop.put("localQuery", "0");
        prop.put("statistics", "0");
        SearchEvent theSearch = SearchEventCache.getEvent(eventID);
        if (theSearch == null) {
            return prop;
        }
        prop.put("statistics", "1");
        prop.put("statistics_offset", theSearch.query.neededResults() - theSearch.query.itemsPerPage() + 1);
        prop.put("statistics_itemscount", Formatter.number(Math.min(item < 0 ? theSearch.query.neededResults() : item + 1, theSearch.getResultCount())));
        prop.put("statistics_itemsperpage", Formatter.number(theSearch.query.itemsPerPage));
        prop.put("statistics_totalcount", Formatter.number(theSearch.getResultCount(), true));
        prop.put("statistics_localIndexCount", Formatter.number(theSearch.local_rwi_available.get() + theSearch.local_solr_stored.get() - theSearch.local_solr_evicted.get(), true));
        prop.put("statistics_remoteIndexCount", Formatter.number(theSearch.remote_rwi_available.get() + theSearch.remote_solr_available.get(), true));
        prop.put("statistics_remotePeerCount", Formatter.number(theSearch.remote_rwi_peerCount.get() + theSearch.remote_solr_peerCount.get(), true));
        prop.put("statistics_navurlBase", QueryParams.navurlBase(RequestHeader.FileType.HTML, theSearch.query, null, false, authenticated).toString());
        prop.put("statistics_localQuery", theSearch.query.isLocal() ? "1" : "0");
        prop.put("statistics_feedRunning", Boolean.toString(!theSearch.isFeedingFinished()));
        String target_special_pattern = sb.getConfig("search.target.special.pattern", "");
        boolean noreferrer = sb.getConfigBool("search.result.noreferrer", false);
        long l = item == 0 ? 10000L : (timeout = (long)(theSearch.query.isLocal() ? 1000 : 3000));
        if (theSearch.query.contentdom == Classification.ContentDomain.TEXT || theSearch.query.contentdom == Classification.ContentDomain.ALL) {
            boolean stealthmode;
            Collection<File> snapshotPaths;
            URIMetadataNode result = theSearch.oneResult(item, timeout);
            if (result == null) {
                return prop;
            }
            String resultUrlstring = result.urlstring();
            DigestURL resultURL = result.url();
            String target = sb.getConfig(resultUrlstring.matches(target_special_pattern) ? "search.target.special" : "search.target", "_self");
            String resource = theSearch.query.domType.toString();
            String origQ = theSearch.query.getQueryGoal().getQueryString(true);
            prop.put("content", 1L);
            String urlhash = ASCII.String(result.hash());
            if (adminAuthenticated) {
                yacysearchitem.addAuthorizedActions(sb, prop, theSearch, resultUrlstring, resource, origQ, urlhash, null);
            } else if (authenticated && user != null) {
                yacysearchitem.addAuthorizedActions(sb, prop, theSearch, resultUrlstring, resource, origQ, urlhash, user);
            } else {
                prop.put("content_authorized", "0");
            }
            if (header.isUserInRole(UserDB.AccessRight.ADMIN_RIGHT.toString()) && header.isUserInRole(UserDB.AccessRight.BOOKMARK_RIGHT.toString())) {
                System.out.println("booki");
            }
            prop.putHTML("content_title", result.title());
            prop.putXML("content_title-xml", result.title());
            prop.putJSON("content_title-json", result.title());
            prop.putHTML("content_showPictures_link", resultUrlstring);
            prop.put("content_showPictures_authSearch", authenticated);
            prop.put("content_nav-generation", theSearch.getNavGeneration());
            if (sb.getConfigBool("proxyURL.useforresults", false) && sb.getConfigBool("proxyURL", false)) {
                Object modifyURL = resultUrlstring;
                String tmprewritecfg = sb.getConfig("proxyURL.rewriteURLs", "all");
                if (tmprewritecfg.equals("all")) {
                    modifyURL = "./proxy.html?url=" + resultUrlstring;
                } else if (tmprewritecfg.equals("domainlist")) {
                    try {
                        if (sb.crawlStacker.urlInAcceptedDomain(new DigestURL(resultUrlstring)) == null) {
                            modifyURL = "./proxy.html?url=" + resultUrlstring;
                        }
                    }
                    catch (MalformedURLException e) {
                        ConcurrentLog.logException(e);
                    }
                } else if (tmprewritecfg.equals("yacy")) {
                    try {
                        if (new DigestURL(resultUrlstring).getHost().endsWith(".yacy")) {
                            modifyURL = "./proxy.html?url=" + resultUrlstring;
                        }
                    }
                    catch (MalformedURLException e) {
                        ConcurrentLog.logException(e);
                    }
                }
                prop.putXML("content_link", (String)modifyURL);
            } else {
                prop.putXML("content_link", resultUrlstring);
            }
            prop.put("content_noreferrer", noreferrer ? 1L : 0L);
            boolean isAtomFeed = header.get("EXT", "").equals("atom");
            String resultFileName = resultURL.getFileName();
            prop.putHTML("content_target", target);
            DigestURL faviconURL = null;
            boolean showFavicon = sb.getConfigBool("search.result.show.favicon", true);
            if ((fileType == RequestHeader.FileType.HTML && showFavicon || fileType == RequestHeader.FileType.JSON) && (resultURL.isHTTP() || resultURL.isHTTPS())) {
                faviconURL = yacysearchitem.getFaviconURL(result, new Dimension(16, 16));
            }
            if (faviconURL == null) {
                prop.put("content_favicon", 0L);
            } else {
                prop.put("content_favicon", 1L);
            }
            prop.putHTML("content_favicon_faviconUrl", yacysearchitem.processFaviconURL(ImageViewer.hasFullViewingRights(header, sb), faviconURL));
            prop.putHTML("content_favicon_urlhash", urlhash);
            if (result.limage() == 0) {
                if (faviconURL == null) {
                    prop.put("content_image", 0L);
                } else {
                    prop.put("content_image", 1L);
                    prop.putXML("content_image_url", faviconURL.toNormalform(true));
                }
            } else {
                try {
                    prop.putXML("content_image_url", result.imageURL());
                    prop.put("content_image", 1L);
                }
                catch (UnsupportedOperationException e) {
                    prop.put("content_image", 0L);
                }
            }
            prop.put("content_urlhash", urlhash);
            prop.put("content_ranking", Float.toString(result.score()));
            Date[] events = result.events();
            boolean showEvent = events != null && events.length > 0 && sb.getConfig("search.navigation", "").indexOf("date", 0) >= 0;
            prop.put("content_showEvent", showEvent ? 1L : 0L);
            Collection<File> collection = snapshotPaths = sb.getConfigBool("search.result.show.snapshots", true) ? Transactions.findPaths(result.url(), null, Transactions.State.ANY) : null;
            if (fileType == RequestHeader.FileType.HTML) {
                boolean showKeywords = sb.getConfigBool("search.result.show.keywords", false) && !result.dc_subject().isEmpty();
                prop.put("content_showKeywords", showKeywords);
                prop.put("content_showDate", sb.getConfigBool("search.result.show.date", true) && !showEvent ? 1L : 0L);
                prop.put("content_showSize", sb.getConfigBool("search.result.show.size", true) ? 1L : 0L);
                prop.put("content_showMetadata", sb.getConfigBool("search.result.show.metadata", true) ? 1L : 0L);
                prop.put("content_showParser", sb.getConfigBool("search.result.show.parser", true) ? 1L : 0L);
                prop.put("content_showCitation", sb.getConfigBool("search.result.show.citation", true) ? 1L : 0L);
                prop.put("content_showPictures", sb.getConfigBool("search.result.show.pictures", true) ? 1L : 0L);
                prop.put("content_showCache", sb.getConfigBool("search.result.show.cache", true) && Cache.has(resultURL.hash()) ? 1L : 0L);
                prop.put("content_showProxy", sb.getConfigBool("search.result.show.proxy", true) && sb.getConfigBool("proxyURL", false) ? 1L : 0L);
                prop.put("content_showIndexBrowser", sb.getConfigBool("search.result.show.indexbrowser", true) ? 1L : 0L);
                prop.put("content_showSnapshots", snapshotPaths != null && snapshotPaths.size() > 0 && sb.getConfigBool("search.result.show.snapshots", true) ? 1L : 0L);
                prop.put("content_showVocabulary", sb.getConfigBool("search.result.show.vocabulary", true) ? 1L : 0L);
                prop.put("content_showRanking", sb.getConfigBool("search.result.show.ranking", false) ? 1L : 0L);
                if (showEvent) {
                    prop.put("content_showEvent_date", GenericFormatter.RFC1123_SHORT_FORMATTER.format(events[0]));
                }
                if (showKeywords) {
                    Object rawNavQueryModifier;
                    String word;
                    int i;
                    StringTokenizer stoc = new StringTokenizer(result.dc_subject(), " ");
                    Navigator navi = theSearch.navigatorPlugins.get("keywords");
                    boolean naviAvail = navi != null;
                    int firstMaxKeywords = sb.getConfigInt("search.result.keywords.firstMaxCount", 100);
                    for (i = 0; stoc.hasMoreTokens() && i < firstMaxKeywords; ++i) {
                        word = stoc.nextToken();
                        prop.putHTML("content_showKeywords_keywords_" + i + "_tagword", word);
                        rawNavQueryModifier = naviAvail ? navi.getQueryModifier(word) : word;
                        prop.put("content_showKeywords_keywords_" + i + "_tagurl", QueryParams.navurl(fileType, 0, theSearch.query, (String)rawNavQueryModifier, naviAvail, authenticated).toString());
                    }
                    prop.put("content_showKeywords_keywords", i);
                    if (stoc.hasMoreTokens()) {
                        prop.put("content_showKeywords_moreKeywords", "1");
                        prop.put("content_showKeywords_moreKeywords_urlhash", urlhash);
                        i = 0;
                        while (stoc.hasMoreTokens()) {
                            word = stoc.nextToken();
                            prop.putHTML("content_showKeywords_moreKeywords_keywords_" + i + "_tagword", word);
                            rawNavQueryModifier = naviAvail ? navi.getQueryModifier(word) : word;
                            prop.put("content_showKeywords_moreKeywords_keywords_" + i + "_tagurl", QueryParams.navurl(fileType, 0, theSearch.query, (String)rawNavQueryModifier, naviAvail, authenticated).toString());
                            ++i;
                        }
                        prop.put("content_showKeywords_moreKeywords_keywords", i);
                    }
                }
                prop.put("content_showDate_date", GenericFormatter.RFC1123_SHORT_FORMATTER.format(result.moddate()));
                prop.putHTML("content_showSize_sizename", RSSMessage.sizename(result.filesize()));
                prop.put("content_showMetadata_urlhash", urlhash);
                prop.put("content_showParser_urlhash", urlhash);
                prop.put("content_showCitation_urlhash", urlhash);
                prop.putUrlEncodedHTML("content_showPictures_former", origQ);
                prop.put("content_showCache_link", resultUrlstring);
                prop.put("content_showProxy_link", resultUrlstring);
                prop.put("content_showIndexBrowser_link", resultUrlstring);
                if (sb.getConfigBool("search.result.show.vocabulary", true)) {
                    int c = 0;
                    for (Object key : result.getFieldNames()) {
                        if (!((String)key).startsWith("vocabulary_") || !((String)key).endsWith("_sxt")) continue;
                        Collection terms = result.getFieldValues((String)key);
                        prop.putHTML("content_showVocabulary_vocabulary_" + c + "_name", ((String)key).substring(11, ((String)key).length() - 4));
                        prop.putHTML("content_showVocabulary_vocabulary_" + c + "_terms", terms.toString());
                        ++c;
                    }
                    prop.put("content_showVocabulary_vocabulary", c);
                    prop.put("content_showVocabulary", 1L);
                } else {
                    prop.put("content_showVocabulary_vocabulary", 0L);
                    prop.put("content_showVocabulary", 0L);
                }
                if (snapshotPaths != null && snapshotPaths.size() > 0) {
                    String selectedExt = null;
                    for (File snapshot2 : snapshotPaths) {
                        String ext = MultiProtocolURL.getFileExtension(snapshot2.getName());
                        if ("jpg".equals(ext) || "png".equals(ext)) {
                            selectedExt = ext;
                            break;
                        }
                        if ("pdf".equals(ext)) {
                            selectedExt = ext;
                            continue;
                        }
                        if (!"xml".equals(ext) || selectedExt != null) continue;
                        selectedExt = ext;
                    }
                    if (selectedExt != null) {
                        prop.putHTML("content_showSnapshots_extension", selectedExt.toUpperCase(Locale.ROOT));
                        prop.putHTML("content_showSnapshots_link", "api/snapshot." + selectedExt + "?url=" + String.valueOf(resultURL));
                    } else {
                        prop.put("content_showSnapshots", 0L);
                    }
                }
                prop.put("content_showRanking_ranking", Float.toString(result.score()));
                prop.put("content_ranking", Float.toString(result.score()));
            }
            prop.put("content_urlhexhash", Seed.b64Hash2hexHash(urlhash));
            prop.putHTML("content_urlname", nxTools.shortenURLString(result.urlname(), 120));
            prop.put("content_date822", isAtomFeed ? ISO8601Formatter.FORMATTER.format(result.moddate()) : HeaderFramework.formatRFC1123(result.moddate()));
            if (showEvent) {
                prop.put("content_showEvent_date822", isAtomFeed ? ISO8601Formatter.FORMATTER.format(events[0]) : HeaderFramework.formatRFC1123(events[0]));
            }
            prop.putHTML("content_size", Integer.toString(result.filesize()));
            prop.putHTML("content_sizename", RSSMessage.sizename(result.filesize()));
            prop.putHTML("content_host", resultURL.getHost() == null ? "" : resultURL.getHost());
            prop.putXML("content_file", resultFileName);
            prop.putXML("content_path", resultURL.getPath());
            prop.put("content_nl", item == theSearch.query.offset ? 0L : 1L);
            prop.putHTML("content_publisher", result.dc_publisher());
            prop.putHTML("content_creator", result.dc_creator());
            prop.putHTML("content_subject", result.dc_subject());
            Iterator<String> query2 = theSearch.query.getQueryGoal().getIncludeStrings();
            StringBuilder s = new StringBuilder(theSearch.query.getQueryGoal().getIncludeSize() * 20);
            while (query2.hasNext()) {
                if (s.length() > 0) {
                    s.append(' ');
                }
                s.append(query2.next());
            }
            String words = MultiProtocolURL.escape(s.toString()).toString();
            prop.putUrlEncodedHTML("content_words", words);
            prop.putUrlEncodedHTML("content_showParser_words", words);
            prop.putUrlEncodedHTML("content_former", origQ);
            TextSnippet snippet = result.textSnippet();
            String desc = snippet == null ? "" : snippet.descriptionline(theSearch.query.getQueryGoal());
            prop.put("content_description", desc);
            prop.putXML("content_description-xml", desc);
            prop.putJSON("content_description-json", desc);
            prop.put("content_mimetype", result.mime());
            HeuristicResult heuristic = theSearch.getHeuristic(result.hash());
            if (heuristic == null) {
                prop.put("content_heuristic", 0L);
            } else {
                if (heuristic.redundant) {
                    prop.put("content_heuristic", 1L);
                } else {
                    prop.put("content_heuristic", 2L);
                }
                prop.put("content_heuristic_name", heuristic.heuristicName);
            }
            EventTracker.update(EventTracker.EClass.SEARCH, new ProfilingGraph.EventSearch(theSearch.query.id(true), SearchEventType.FINALIZATION, "" + item, 0, 0L), false);
            if (result.doctype() == 'i') {
                String license = URLLicense.aquireLicense(resultURL);
                prop.put("content_code", license);
            } else {
                prop.put("content_code", "");
            }
            if (result.lat() == 0.0 || result.lon() == 0.0) {
                prop.put("content_loc", 0L);
            } else {
                prop.put("content_loc", 1L);
                prop.put("content_loc_lat", result.lat());
                prop.put("content_loc_lon", result.lon());
            }
            boolean clustersearch = sb.isRobinsonMode() && sb.getConfig("cluster.mode", "").equals("publiccluster");
            boolean indexReceiveGranted = sb.getConfigBool("allowReceiveIndex.search", true) || clustersearch;
            boolean p2pmode = sb.peers != null && sb.peers.sizeConnected() > 0 && indexReceiveGranted;
            boolean bl = stealthmode = p2pmode && theSearch.query.isLocal();
            if ((sb.getConfigBool("heuristic.searchresults", false) || sb.getConfigBool("greedylearning.active", false) && sb.getConfigBool("greedylearning.enabled", false) && Memory.getSystemLoadAverage() < 1.0) && !stealthmode) {
                sb.heuristicSearchResults(result);
            }
            theSearch.query.transmitcount = item + 1;
            return prop;
        }
        if (theSearch.query.contentdom == Classification.ContentDomain.IMAGE) {
            yacysearchitem.processImage(sb, prop, item, theSearch, target_special_pattern, timeout, ImageViewer.hasFullViewingRights(header, sb), noreferrer);
            theSearch.query.transmitcount = item + 1;
            return prop;
        }
        if (theSearch.query.contentdom == Classification.ContentDomain.AUDIO || theSearch.query.contentdom == Classification.ContentDomain.VIDEO || theSearch.query.contentdom == Classification.ContentDomain.APP) {
            URIMetadataNode ms = theSearch.oneResult(item, timeout);
            prop.put("content", theSearch.query.contentdom.getCode() + 1);
            if (ms == null) {
                prop.put("content_item", "0");
            } else {
                String resultUrlstring = ms.url().toNormalform(true);
                String target = sb.getConfig(resultUrlstring.matches(target_special_pattern) ? "search.target.special" : "search.target", "_self");
                prop.putHTML("content_item_href", resultUrlstring);
                if (theSearch.query.contentdom == Classification.ContentDomain.AUDIO && extendedSearchRights) {
                    yacysearchitem.processEmbedAudio(prop, theSearch, ms);
                } else {
                    prop.put("content_item_embed", false);
                }
                prop.put("content_item_noreferrer", noreferrer ? 1L : 0L);
                prop.putHTML("content_item_hrefshort", nxTools.shortenURLString(resultUrlstring, 120));
                prop.putHTML("content_item_target", target);
                prop.putHTML("content_item_name", yacysearchitem.shorten(ms.title(), 60));
                prop.put("content_item_col", item % 2 == 0 ? "0" : "1");
                prop.put("content_item_nl", item == theSearch.query.offset ? 0L : 1L);
                prop.put("content_item", 1L);
            }
            theSearch.query.transmitcount = item + 1;
            return prop;
        }
        return prop;
    }

    private static void processEmbedAudio(serverObjects prop, SearchEvent theSearch, URIMetadataNode result) {
        String mediaType = result.mime();
        if (mediaType != null && mediaType.startsWith("audio/")) {
            prop.put("content_item_embed", true);
            prop.put("content_item_embed_list", false);
            prop.put("content_item_embed_audioSources", 1L);
            yacysearchitem.appendEmbeddedAudio(result, result.url(), prop, "content_item_embed_audioSources_0");
            prop.put("content_item_embed_audioSources_0_list", false);
        } else if (result.laudio() > 0 && !theSearch.query.isStrictContentDom()) {
            TreeSet<MultiProtocolURL> audioLinks = new TreeSet<MultiProtocolURL>(Comparator.comparing(MultiProtocolURL::getHost).thenComparing(MultiProtocolURL::getFile));
            int firstAudioLinksLimit = 3;
            int secondAudioLinksLimit = 50;
            yacysearchitem.filterAudioLinks(URIMetadataNode.getLinks(result, false), audioLinks, result.laudio());
            yacysearchitem.filterAudioLinks(URIMetadataNode.getLinks(result, true), audioLinks, result.laudio());
            if (!audioLinks.isEmpty()) {
                int i;
                prop.put("content_item_embed", true);
                boolean hasMoreThanOne = audioLinks.size() > 1;
                prop.put("content_item_embed_list", hasMoreThanOne);
                prop.put("content_item_embed_audioSources", Math.min(audioLinks.size(), 3));
                Iterator<MultiProtocolURL> linksIter = audioLinks.iterator();
                for (i = 0; linksIter.hasNext() && i < 3; ++i) {
                    yacysearchitem.appendEmbeddedAudio(result, linksIter.next(), prop, "content_item_embed_audioSources_" + i);
                    prop.put("content_item_embed_audioSources_" + i + "_list", hasMoreThanOne);
                }
                if (audioLinks.size() > 3) {
                    prop.put("content_item_embed_moreAudios", true);
                    prop.put("content_item_embed_moreAudios_firstLimit", 3L);
                    prop.put("content_item_embed_moreAudios_hiddenCount", String.valueOf(audioLinks.size() - 3));
                    prop.put("content_item_embed_moreAudios_expandableCount", String.valueOf(Math.min(audioLinks.size(), 50) - 3));
                    prop.put("content_item_embed_moreAudios_urlhash", ASCII.String(result.hash()));
                    prop.put("content_item_embed_moreAudios_audioSources", Math.min(audioLinks.size(), 50) - 3);
                    for (i = 0; linksIter.hasNext() && i < 47; ++i) {
                        yacysearchitem.appendEmbeddedAudio(result, linksIter.next(), prop, "content_item_embed_moreAudios_audioSources_" + i);
                    }
                } else {
                    prop.put("content_item_embed_moreAudios", false);
                }
                prop.put("content_item_embed_moreAudios_evenMore", audioLinks.size() > 50);
                if (audioLinks.size() > 50) {
                    prop.put("content_item_embed_moreAudios_evenMore_count", String.valueOf(audioLinks.size() - 50));
                    prop.put("content_item_embed_moreAudios_evenMore_urlhash", ASCII.String(result.hash()));
                }
            } else {
                prop.put("content_item_embed", false);
            }
        }
    }

    private static void appendEmbeddedAudio(URIMetadataNode mainResult, MultiProtocolURL audioLink, serverObjects prop, String propPrefix) {
        prop.putHTML(propPrefix + "_href", audioLink.toString());
        String title = audioLink.getHost().equals(mainResult.url().getHost()) ? yacysearchitem.shorten(audioLink.getFileName(), 60) : nxTools.shortenURLString(audioLink.toString(), 120);
        prop.putHTML(propPrefix + "_title", title);
    }

    protected static void filterAudioLinks(Iterator<String> linksIter, Set<MultiProtocolURL> target, int targetMaxSize) {
        while (linksIter.hasNext() && target.size() < targetMaxSize) {
            String linkStr = linksIter.next();
            try {
                MultiProtocolURL url = new MultiProtocolURL(linkStr);
                if (!Classification.isAudioExtension(MultiProtocolURL.getFileExtension(url.getFileName()))) continue;
                target.add(url);
            }
            catch (MalformedURLException malformedURLException) {}
        }
    }

    protected static DigestURL getFaviconURL(URIMetadataNode result, Dimension preferredSize) {
        DigestURL faviconURL;
        IconEntry faviconEntry = result.getFavicon(preferredSize);
        if (faviconEntry == null) {
            try {
                String defaultFaviconURL = result.url().getProtocol() + "://" + result.url().getHost() + (String)(result.url().getPort() != -1 ? ":" + result.url().getPort() : "") + "/favicon.ico";
                faviconURL = new DigestURL(defaultFaviconURL);
            }
            catch (MalformedURLException e1) {
                ConcurrentLog.logException(e1);
                faviconURL = null;
            }
        } else {
            faviconURL = faviconEntry.getUrl();
        }
        return faviconURL;
    }

    private static String processFaviconURL(boolean hasFullViewingRights, DigestURL faviconURL) {
        StringBuilder contentFaviconURL = new StringBuilder();
        if (faviconURL != null) {
            String iconUrlExt = MultiProtocolURL.getFileExtension(faviconURL.getFileName());
            String viewFaviconExt = !iconUrlExt.isEmpty() && ImageViewer.isBrowserRendered(iconUrlExt) ? iconUrlExt : "png";
            contentFaviconURL.append("ViewFavicon.").append(viewFaviconExt).append("?maxwidth=16&maxheight=16&isStatic=true&quadratic");
            if (hasFullViewingRights) {
                contentFaviconURL.append("&url=").append(faviconURL.toNormalform(true));
            } else {
                contentFaviconURL.append("&code=").append(URLLicense.aquireLicense(faviconURL));
            }
        }
        return contentFaviconURL.toString();
    }

    private static void addAuthorizedActions(Switchboard sb, serverObjects prop, SearchEvent theSearch, String resultUrlstring, String resource, String origQ, String urlhash, UserDB.Entry user) {
        String encodedURLString;
        boolean bookmarkexists;
        boolean bl = bookmarkexists = sb.bookmarksDB.getBookmark(urlhash) != null;
        if (user == null || user.hasRight(UserDB.AccessRight.BOOKMARK_RIGHT)) {
            prop.put("content_authorized_bookmark", !bookmarkexists);
        } else {
            prop.put("content_authorized_bookmark", "0");
        }
        StringBuilder linkBuilder = QueryParams.navurl(RequestHeader.FileType.HTML, theSearch.query.offset / theSearch.query.itemsPerPage(), theSearch.query, null, false, true);
        int baseUrlLength = linkBuilder.length();
        try {
            encodedURLString = URLEncoder.encode(crypt.simpleEncode(resultUrlstring), StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e1) {
            ConcurrentLog.warn("YACY_SEARCH_ITEM", "UTF-8 encoding is not supported!");
            encodedURLString = crypt.simpleEncode(resultUrlstring);
        }
        String bookmarkLink = linkBuilder.append("&bookmarkurl=").append(encodedURLString).append("&bookmarkref=" + urlhash).toString();
        linkBuilder.setLength(baseUrlLength);
        String deleteLink = linkBuilder.append("&deleteref=").append(urlhash).toString();
        linkBuilder.setLength(baseUrlLength);
        String recommendLink = linkBuilder.append("&recommendref=").append(urlhash).toString();
        linkBuilder.setLength(baseUrlLength);
        String blacklistLink = linkBuilder.append("&blacklisturl=").append(encodedURLString).toString();
        linkBuilder.setLength(baseUrlLength);
        prop.put("content_authorized_blacklist_blacklistlink", blacklistLink);
        prop.put("content_authorized_bookmark_bookmarklink", bookmarkLink);
        prop.put("content_authorized_recommend_deletelink", deleteLink);
        prop.put("content_authorized_recommend_recommendlink", recommendLink);
        if (user == null || user.hasRight(UserDB.AccessRight.ADMIN_RIGHT)) {
            prop.put("content_authorized_recommend", sb.peers.newsPool.getSpecific(2, "stippadd", "url", resultUrlstring) == null ? "1" : "0");
            prop.put("content_authorized_blacklist", "1");
        } else {
            prop.put("content_authorized_recommend", "0");
            prop.put("content_authorized_blacklist", "0");
        }
        prop.put("content_authorized", "1");
    }

    private static void processImage(Switchboard sb, serverObjects prop, int item, SearchEvent theSearch, String target_special_pattern, long timeout, boolean fullViewingRights, boolean noreferrer) {
        prop.put("content", theSearch.query.contentdom.getCode() + 1);
        try {
            SearchEvent.ImageResult image = theSearch.oneImageResult(item, timeout, theSearch.query.isStrictContentDom());
            String imageUrlstring = image.imageUrl.toNormalform(true);
            String imageUrlExt = MultiProtocolURL.getFileExtension(image.imageUrl.getFileName());
            String target = sb.getConfig(imageUrlstring.matches(target_special_pattern) ? "search.target.special" : "search.target", "_self");
            String license = URLLicense.aquireLicense(image.imageUrl);
            String viewImageExt = !imageUrlExt.isEmpty() && ImageViewer.isBrowserRendered(imageUrlExt) ? imageUrlExt : "png";
            StringBuilder thumbURLBuilder = new StringBuilder("ViewImage.").append(viewImageExt).append("?maxwidth=").append(256).append("&maxheight=").append(256).append("&isStatic=true&quadratic");
            if (fullViewingRights) {
                thumbURLBuilder.append("&url=").append(imageUrlstring);
            } else {
                thumbURLBuilder.append("&code=").append(URLLicense.aquireLicense(image.imageUrl));
            }
            String thumbURL = thumbURLBuilder.toString();
            prop.putHTML("content_item_hrefCache", thumbURL);
            if (fullViewingRights) {
                prop.putHTML("content_item_hrefFullPreview", "ViewImage." + viewImageExt + "?isStatic=true&url=" + imageUrlstring);
            } else {
                prop.putHTML("content_item_hrefFullPreview", thumbURL);
            }
            prop.putHTML("content_item_href", imageUrlstring);
            prop.putHTML("content_item_target", target);
            prop.put("content_item_code", license);
            prop.putHTML("content_item_name", yacysearchitem.shorten(image.imagetext, 60));
            prop.put("content_item_mimetype", image.mimetype);
            prop.put("content_item_fileSize", 0L);
            String itemWidth = "256px";
            String itemHeight = "256px";
            Object itemStyle = "";
            if (ImageViewer.isBrowserRendered(imageUrlExt)) {
                if (image.width > image.height) {
                    itemWidth = "";
                    itemHeight = "100%";
                    if (image.height > 0) {
                        double scale = 256.0 / (double)image.height;
                        int margin = (int)((double)(image.height - image.width) * (scale / 2.0));
                        itemStyle = "margin-left: " + margin + "px;";
                    }
                } else {
                    itemWidth = "100%";
                    itemHeight = "";
                    if (image.height > image.width && image.width > 0) {
                        double scale = 256.0 / (double)image.width;
                        int margin = (int)((double)(image.width - image.height) * (scale / 2.0));
                        itemStyle = "margin-top: " + margin + "px;";
                    }
                }
            }
            prop.put("content_item_width", itemWidth);
            prop.put("content_item_height", itemHeight);
            prop.put("content_item_style", (String)itemStyle);
            prop.put("content_item_attr", "");
            prop.put("content_item_urlhash", ASCII.String(image.imageUrl.hash()));
            prop.put("content_item_source", image.sourceUrl.toNormalform(true));
            prop.put("content_item_noreferrer", noreferrer ? 1L : 0L);
            prop.putXML("content_item_source-xml", image.sourceUrl.toNormalform(true));
            prop.put("content_item_sourcedom", image.sourceUrl.getHost());
            prop.put("content_item_nl", item == theSearch.query.offset ? 0L : 1L);
            prop.put("content_item", 1L);
        }
        catch (MalformedURLException e) {
            prop.put("content_item", "0");
        }
    }

    private static String shorten(String s, int length) {
        Object ret;
        if (s.length() <= length) {
            ret = s;
        } else {
            int p = s.lastIndexOf(46);
            if (p < 0) {
                ret = s.substring(0, length - SHORTEN_SUFFIX_LENGTH) + SHORTEN_SUFFIX;
            } else {
                assert (p >= 0);
                String ext = s.substring(p + 1);
                ret = ext.length() > 4 ? s.substring(0, length / 2 - 2) + SHORTEN_SUFFIX + s.substring(s.length() - (length / 2 - 2)) : s.substring(0, length - ext.length() - SHORTEN_SUFFIX_LENGTH) + SHORTEN_SUFFIX + ext;
            }
        }
        return ret;
    }
}

