/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot.yacy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import net.yacy.cora.document.analysis.Classification;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.feed.RSSMessage;
import net.yacy.cora.lod.vocabulary.Tagging;
import net.yacy.cora.protocol.Domains;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.sorting.ScoreMap;
import net.yacy.cora.sorting.WeakPriorityBlockingQueue;
import net.yacy.cora.storage.HandleSet;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.gui.Audio;
import net.yacy.kelondro.data.meta.URIMetadataNode;
import net.yacy.kelondro.data.word.WordReferenceFactory;
import net.yacy.kelondro.data.word.WordReferenceRow;
import net.yacy.kelondro.index.RowHandleSet;
import net.yacy.kelondro.rwi.ReferenceContainer;
import net.yacy.kelondro.util.Bitfield;
import net.yacy.kelondro.util.ISO639;
import net.yacy.kelondro.util.MemoryControl;
import net.yacy.peers.EventChannel;
import net.yacy.peers.Network;
import net.yacy.peers.Protocol;
import net.yacy.peers.Seed;
import net.yacy.peers.graphics.ProfilingGraph;
import net.yacy.search.EventTracker;
import net.yacy.search.Switchboard;
import net.yacy.search.index.Segment;
import net.yacy.search.query.AccessTracker;
import net.yacy.search.query.QueryGoal;
import net.yacy.search.query.QueryModifier;
import net.yacy.search.query.QueryParams;
import net.yacy.search.query.SearchEvent;
import net.yacy.search.query.SearchEventCache;
import net.yacy.search.query.SearchEventType;
import net.yacy.search.ranking.RankingProfile;
import net.yacy.server.serverCore;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;
import net.yacy.utils.crypt;

public final class search {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        int resultCount;
        long timer2;
        QueryGoal qg2;
        Seed remoteSeed;
        Bitfield constraint;
        Switchboard sb = (Switchboard)env;
        sb.remoteSearchLastAccess = System.currentTimeMillis();
        serverObjects prop = new serverObjects();
        prop.put("searchtime", "0");
        prop.put("references", "");
        prop.put("joincount", "0");
        prop.put("linkcount", "0");
        prop.put("links", "");
        prop.put("indexcount", "");
        prop.put("indexabstract", "");
        if (post == null || env == null) {
            return prop;
        }
        if (!Protocol.authentifyRequest(post, env)) {
            return prop;
        }
        String client = header.getRemoteAddr();
        String oseed = post.get("myseed", "");
        String query2 = post.get("query", "");
        String exclude = post.get("exclude", "");
        String urls2 = post.get("urls", "");
        String abstracts = post.get("abstracts", "");
        int count = Math.min((int)sb.getConfigLong("network.unit.remotesearch.maxcount", 10L), post.getInt("count", 10));
        long maxtime = Math.min((long)((int)sb.getConfigLong("network.unit.remotesearch.maxtime", 3000L)), post.getLong("time", 3000L));
        int maxdist = post.getInt("maxdist", Integer.MAX_VALUE);
        String prefer = post.get("prefer", "");
        String contentdom = post.get("contentdom", "all");
        boolean strictContentDom = post.getBoolean("strictContentDom");
        String filter = post.get("filter", ".*");
        int timezoneOffset = post.getInt("timezoneOffset", 0);
        QueryModifier modifier = new QueryModifier(timezoneOffset);
        modifier.sitehost = post.get("sitehost", "");
        if (modifier.sitehost.isEmpty()) {
            modifier.sitehost = null;
        }
        modifier.sitehash = post.get("sitehash", "");
        if (modifier.sitehash.isEmpty()) {
            modifier.sitehash = null;
        }
        modifier.author = post.get("author", "");
        if (modifier.author.isEmpty()) {
            modifier.author = null;
        }
        modifier.collection = post.get("collection", "");
        if (modifier.collection.isEmpty()) {
            modifier.collection = null;
        }
        modifier.filetype = post.get("filetype", "");
        if (modifier.filetype.isEmpty()) {
            modifier.filetype = null;
        }
        modifier.protocol = post.get("protocol", "");
        if (modifier.protocol.isEmpty()) {
            modifier.protocol = null;
        }
        modifier.parse(post.get("modifier", "").trim());
        String language = post.get("language", "");
        if (language == null || language.isEmpty() || !ISO639.exists(language)) {
            String agent = header.get("User-Agent");
            if (agent == null) {
                agent = System.getProperty("user.language");
            }
            String string = language = agent == null ? "en" : ISO639.userAgentLanguageDetection(agent);
            if (language == null) {
                language = "en";
            }
        }
        int partitions = post.getInt("partitions", 30);
        String profile2 = post.get("profile", "");
        if (profile2.length() > 0) {
            profile2 = crypt.simpleDecode(profile2);
        }
        Bitfield bitfield = constraint = post.containsKey("constraint") && post.get("constraint", "").length() > 0 ? new Bitfield(4, post.get("constraint", "______")) : null;
        if (constraint != null) {
            boolean allon = true;
            for (int i = 0; i < 32; ++i) {
                if (constraint.get(i)) continue;
                allon = false;
                break;
            }
            if (allon) {
                constraint = null;
            }
        }
        if (sb.isRobinsonMode() && !sb.isPublicRobinson()) {
            return prop;
        }
        TreeSet<Long> trackerHandles = sb.remoteSearchTracker.get(client);
        if (trackerHandles == null) {
            trackerHandles = new TreeSet();
        }
        boolean block = false;
        TreeSet<Long> treeSet = trackerHandles;
        synchronized (treeSet) {
            if (trackerHandles.tailSet(System.currentTimeMillis() - 3000L).size() > 1) {
                block = true;
            }
        }
        if (!block) {
            treeSet = trackerHandles;
            synchronized (treeSet) {
                if (trackerHandles.tailSet(System.currentTimeMillis() - 60000L).size() > 12) {
                    block = true;
                }
            }
        }
        if (!block) {
            treeSet = trackerHandles;
            synchronized (treeSet) {
                if (trackerHandles.tailSet(System.currentTimeMillis() - 600000L).size() > 36) {
                    block = true;
                }
            }
        }
        if (block && Domains.isLocal(client, null)) {
            block = false;
        }
        if (block) {
            return prop;
        }
        sb.intermissionAllThreads(100L);
        EventTracker.delete(EventTracker.EClass.SEARCH);
        HandleSet abstractSet = abstracts.isEmpty() || abstracts.equals("auto") ? null : QueryParams.hashes2Set(abstracts);
        try {
            remoteSeed = Seed.genRemoteSeed(oseed, false, client);
        }
        catch (IOException e) {
            Network.log.info("yacy.search: access with bad seed: " + e.getMessage());
            remoteSeed = null;
        }
        if (sb.peers == null) {
            Network.log.severe("yacy.search: seed cache not initialized");
        } else {
            sb.peers.peerActions.peerArrival(remoteSeed, true);
        }
        HandleSet queryhashes = QueryParams.hashes2Set(query2);
        HandleSet excludehashes = exclude.isEmpty() ? new RowHandleSet(WordReferenceRow.urlEntryRow.primaryKeyLength, WordReferenceRow.urlEntryRow.objectOrder, 0) : QueryParams.hashes2Set(exclude);
        long timestamp = System.currentTimeMillis();
        RankingProfile rankingProfile = profile2.isEmpty() ? new RankingProfile(Classification.ContentDomain.contentdomParser(contentdom)) : new RankingProfile("", profile2);
        StringBuilder indexabstract = new StringBuilder(6000);
        int indexabstractContainercount = 0;
        QueryParams theQuery = null;
        SearchEvent theSearch = null;
        ArrayList<WeakPriorityBlockingQueue.Element<URIMetadataNode>> accu = null;
        if (query2.isEmpty() && abstractSet != null) {
            Segment indexSegment = sb.index;
            qg2 = new QueryGoal(abstractSet, new RowHandleSet(WordReferenceRow.urlEntryRow.primaryKeyLength, WordReferenceRow.urlEntryRow.objectOrder, 0));
            theQuery = new QueryParams(qg2, modifier, maxdist, prefer, Classification.ContentDomain.contentdomParser(contentdom), language, timezoneOffset, new HashSet<Tagging.Metatag>(), null, count, 0, filter, null, null, QueryParams.Searchdom.LOCAL, null, false, null, 255, client, false, indexSegment, rankingProfile, header.get("User-Agent", ""), 0.0, 0.0, 0.0, new HashSet<String>());
            theQuery.setStrictContentDom(strictContentDom);
            Network.log.info("INIT HASH SEARCH (abstracts only): " + QueryParams.anonymizedQueryHashes(theQuery.getQueryGoal().getIncludeHashes()) + " - " + theQuery.itemsPerPage() + " links");
            timer2 = System.currentTimeMillis();
            TreeMap incc = indexSegment.termIndex() == null ? new TreeMap() : indexSegment.termIndex().searchConjunction(theQuery.getQueryGoal().getIncludeHashes(), QueryParams.hashes2Set(urls2));
            EventTracker.update(EventTracker.EClass.SEARCH, new ProfilingGraph.EventSearch(theQuery.id(true), SearchEventType.COLLECTION, "", incc.size(), System.currentTimeMillis() - timer2), false);
            if (incc != null) {
                for (Map.Entry entry2 : incc.entrySet()) {
                    byte[] wordhash = (byte[])entry2.getKey();
                    ReferenceContainer container = (ReferenceContainer)entry2.getValue();
                    indexabstractContainercount += container.size();
                    indexabstract.append("indexabstract.");
                    indexabstract.append(ASCII.String(wordhash));
                    indexabstract.append("=");
                    indexabstract.append(WordReferenceFactory.compressIndex(container, null, 1000L).toString());
                    indexabstract.append(serverCore.CRLF_STRING);
                }
            }
            prop.put("indexcount", "");
            prop.put("joincount", "0");
            prop.put("references", "");
        } else {
            int i;
            RowHandleSet allHashes = new RowHandleSet(WordReferenceRow.urlEntryRow.primaryKeyLength, WordReferenceRow.urlEntryRow.objectOrder, 0);
            try {
                allHashes.putAll(queryhashes);
            }
            catch (SpaceExceededException qg2) {
                // empty catch block
            }
            try {
                allHashes.putAll(excludehashes);
            }
            catch (SpaceExceededException qg2) {
                // empty catch block
            }
            qg2 = new QueryGoal(queryhashes, excludehashes);
            theQuery = new QueryParams(qg2, modifier, maxdist, prefer, Classification.ContentDomain.contentdomParser(contentdom), language, timezoneOffset, new HashSet<Tagging.Metatag>(), null, count, 0, filter, null, null, QueryParams.Searchdom.LOCAL, constraint, false, null, 255, client, false, sb.index, rankingProfile, header.get("User-Agent", ""), 0.0, 0.0, 0.0, new HashSet<String>());
            theQuery.setStrictContentDom(strictContentDom);
            Network.log.info("INIT HASH SEARCH (query-" + abstracts + "): " + QueryParams.anonymizedQueryHashes(theQuery.getQueryGoal().getIncludeHashes()) + " - " + theQuery.itemsPerPage() + " links");
            EventChannel.channels(EventChannel.REMOTESEARCH).addMessage(new RSSMessage("Remote Search Request from " + (remoteSeed == null ? "unknown" : remoteSeed.getName()), QueryParams.anonymizedQueryHashes(theQuery.getQueryGoal().getIncludeHashes()), ""));
            if (sb.getConfigBool("decoration.audio", false)) {
                Audio.Soundclip.remotesearch.play(-10.0f);
            }
            theSearch = SearchEventCache.getEvent(theQuery, sb.peers, sb.tables, null, abstracts.length() > 0, sb.loader, count, maxtime);
            if (theSearch.rwiProcess != null && theSearch.rwiProcess.isAlive()) {
                try {
                    theSearch.rwiProcess.join();
                }
                catch (InterruptedException timer2) {
                    // empty catch block
                }
            }
            if (theSearch.localsolrsearch != null && theSearch.localsolrsearch.isAlive()) {
                try {
                    theSearch.localsolrsearch.join();
                }
                catch (InterruptedException timer2) {
                    // empty catch block
                }
            }
            prop.put("joincount", Integer.toString(theSearch.getResultCount()));
            if (theSearch.getResultCount() > 0) {
                accu = theSearch.completeResults(maxtime);
            }
            if (theSearch.getResultCount() <= 0 || abstracts.isEmpty()) {
                prop.put("indexcount", "");
            } else {
                StringBuilder indexcount = new StringBuilder(6000);
                Iterator<Map.Entry<byte[], Integer>> i2 = theSearch.abstractsCount();
                while (i2.hasNext()) {
                    Map.Entry<byte[], Integer> entry3 = i2.next();
                    indexcount.append("indexcount.").append(ASCII.String(entry3.getKey())).append('=').append(entry3.getValue().toString()).append(serverCore.CRLF_STRING);
                }
                if (abstractSet != null) {
                    for (byte[] wordhash : abstractSet) {
                        indexabstractContainercount += theSearch.abstractsCount(wordhash);
                        indexabstract.append("indexabstract.").append(ASCII.String(wordhash)).append("=").append(theSearch.abstractsString(wordhash)).append(serverCore.CRLF_STRING);
                    }
                }
                prop.put("indexcount", indexcount.toString());
                if (theSearch.getAbstractsMaxCountHash() == null || urls2.length() != 0 || queryhashes.size() <= 1 || abstracts.isEmpty()) {
                    prop.put("indexabstract", "");
                } else if (abstracts.equals("auto")) {
                    indexabstractContainercount += theSearch.abstractsCount(theSearch.getAbstractsMaxCountHash());
                    indexabstract.append("indexabstract.").append(ASCII.String(theSearch.getAbstractsMaxCountHash())).append("=").append(theSearch.abstractsString(theSearch.getAbstractsMaxCountHash())).append(serverCore.CRLF_STRING);
                    if (theSearch.getAbstractsNearDHTHash() != null && !Arrays.equals(theSearch.getAbstractsNearDHTHash(), theSearch.getAbstractsMaxCountHash())) {
                        indexabstractContainercount += theSearch.abstractsCount(theSearch.getAbstractsNearDHTHash());
                        indexabstract.append("indexabstract.").append(ASCII.String(theSearch.getAbstractsNearDHTHash())).append("=").append(theSearch.abstractsString(theSearch.getAbstractsNearDHTHash())).append(serverCore.CRLF_STRING);
                    }
                }
            }
            if (partitions > 0) {
                sb.searchQueriesGlobal = (float)((double)sb.searchQueriesGlobal + 1.0 / (double)partitions);
            }
            timer2 = System.currentTimeMillis();
            ScoreMap<String> topicNavigator = theSearch.getTopics();
            StringBuilder refstr = new StringBuilder(6000);
            Iterator<String> navigatorIterator = topicNavigator.keys(false);
            for (i = 0; i < 5 && navigatorIterator.hasNext(); ++i) {
                String name = navigatorIterator.next();
                refstr.append(",").append(name);
            }
            prop.put("references", refstr.length() > 0 ? refstr.substring(1) : refstr.toString());
            EventTracker.update(EventTracker.EClass.SEARCH, new ProfilingGraph.EventSearch(theQuery.id(true), SearchEventType.REFERENCECOLLECTION, "", i, System.currentTimeMillis() - timer2), false);
        }
        prop.put("indexabstract", indexabstract.toString());
        int n = resultCount = theSearch == null ? 0 : theSearch.getResultCount();
        if (resultCount == 0 || accu == null || accu.isEmpty()) {
            prop.put("links", "");
            prop.put("linkcount", "0");
            prop.put("references", "");
        } else {
            long timer3 = System.currentTimeMillis();
            StringBuilder links = new StringBuilder(6000);
            String resource = null;
            for (int i = 0; i < accu.size(); ++i) {
                WeakPriorityBlockingQueue.Element<URIMetadataNode> entry4 = accu.get(i);
                resource = entry4.getElement().resource();
                if (resource == null) continue;
                links.append("resource").append(i).append('=').append(resource).append(serverCore.CRLF_STRING);
            }
            theQuery.transmitcount = accu.size() + 1;
            prop.put("links", links.toString());
            prop.put("linkcount", accu.size());
            EventTracker.update(EventTracker.EClass.SEARCH, new ProfilingGraph.EventSearch(theQuery.id(true), SearchEventType.RESULTLIST, "", accu.size(), System.currentTimeMillis() - timer3), false);
        }
        theQuery.remotepeer = client == null ? null : sb.peers.lookupByIP(Domains.dnsResolve(client), -1, true, false, false);
        theQuery.searchtime = System.currentTimeMillis() - timestamp;
        theQuery.urlretrievaltime = theSearch == null ? 0L : theSearch.getURLRetrievalTime();
        theQuery.snippetcomputationtime = theSearch == null ? 0L : theSearch.getSnippetComputationTime();
        AccessTracker.add(AccessTracker.Location.remote, theQuery, resultCount);
        TreeSet<Long> timer3 = trackerHandles;
        synchronized (timer3) {
            trackerHandles.add(theQuery.starttime);
            while (trackerHandles.size() > 36 && trackerHandles.remove(trackerHandles.first())) {
            }
        }
        sb.remoteSearchTracker.put(client, trackerHandles);
        if (MemoryControl.shortStatus()) {
            sb.remoteSearchTracker.clear();
        }
        Network.log.info("EXIT HASH SEARCH: " + QueryParams.anonymizedQueryHashes(theQuery.getQueryGoal().getIncludeHashes()) + " - " + resultCount + " links found, " + prop.get("linkcount", "?") + " links selected, " + indexabstractContainercount + " index abstracts, " + (System.currentTimeMillis() - timestamp) + " milliseconds");
        prop.put("searchtime", System.currentTimeMillis() - timestamp);
        int links = prop.getInt("linkcount", 0);
        sb.peers.mySeed().incSI(links);
        sb.peers.mySeed().incSU(links);
        return prop;
    }
}

