/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot.yacy;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.Date;
import net.yacy.cora.date.GenericFormatter;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.protocol.Domains;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.CommonPattern;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.data.MessageBoard;
import net.yacy.peers.Network;
import net.yacy.peers.Protocol;
import net.yacy.peers.Seed;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;
import net.yacy.utils.crypt;

public final class message {
    public static String dateString(Date date) {
        return GenericFormatter.SIMPLE_FORMATTER.format(date);
    }

    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        Switchboard sb = (Switchboard)env;
        serverObjects prop = new serverObjects();
        prop.put("messagesize", "0");
        prop.put("attachmentsize", "0");
        prop.put("response", "-1");
        if (post == null || env == null) {
            return prop;
        }
        if (!Protocol.authentifyRequest(post, env)) {
            return prop;
        }
        String process = post.get("process", "permission");
        String clientip = header.getRemoteAddr();
        InetAddress ias = clientip != null ? Domains.dnsResolve(clientip) : null;
        int messagesize = 10240;
        boolean attachmentsize = false;
        String youare = post.get("youare", "");
        if (sb.peers.mySeed() == null || !sb.peers.mySeed().hash.equals(youare)) {
            return prop;
        }
        if (sb.isRobinsonMode() && !sb.isPublicRobinson() && !sb.isInMyCluster(header.getRemoteAddr())) {
            return prop;
        }
        prop.put("messagesize", Integer.toString(10240));
        prop.put("attachmentsize", Integer.toString(0));
        if (process.equals("permission")) {
            prop.put("response", "Welcome to my peer!");
        }
        if (process.equals("post")) {
            Seed otherSeed;
            String otherSeedString = post.get("myseed", "");
            if (otherSeedString.isEmpty()) {
                return prop;
            }
            try {
                otherSeed = Seed.genRemoteSeed(otherSeedString, false, ias == null ? null : ias.getHostAddress());
            }
            catch (IOException e) {
                return prop;
            }
            String subject = crypt.simpleDecode(post.get("subject", ""));
            String message2 = crypt.simpleDecode(post.get("message", ""));
            if (subject == null || message2 == null) {
                return prop;
            }
            message2 = message2.trim();
            if ((subject = subject.trim()).isEmpty() || message2.isEmpty()) {
                return prop;
            }
            prop.put("response", "Thank you!");
            MessageBoard.entry msgEntry = null;
            byte[] mb = UTF8.getBytes(message2);
            msgEntry = sb.messageDB.newEntry("remote", otherSeed.get("Name", "anonymous"), otherSeed.hash, sb.peers.mySeed().getName(), sb.peers.mySeed().hash, subject, mb);
            sb.messageDB.write(msgEntry);
            message.messageForwardingViaEmail(sb, msgEntry);
            File notifierSource = new File(sb.getAppPath(), sb.getConfig("htRootPath", "htroot") + "/env/grafics/message.gif");
            File notifierDest = new File(sb.getDataPath("htDocsPath", "DATA/HTDOCS"), "notifier.gif");
            try {
                Files.copy((File)notifierSource, (File)notifierDest);
            }
            catch (IOException e) {
                ConcurrentLog.severe("MESSAGE", "NEW MESSAGE ARRIVED! (error: " + e.getMessage() + ")");
            }
        }
        return prop;
    }

    private static void messageForwardingViaEmail(Switchboard sb, MessageBoard.entry msgEntry) {
        try {
            if (!sb.getConfigBool("msgForwardingEnabled", false)) {
                return;
            }
            String sendMailTo = sb.getConfig("msgForwardingTo", "root@localhost").trim();
            String sendMailStr = sb.getConfig("msgForwardingCmd", "/usr/bin/sendmail") + " " + sendMailTo;
            String[] sendMail = CommonPattern.SPACE.split(sendMailStr.trim());
            StringBuilder emailTxt = new StringBuilder();
            emailTxt.append("To: ").append(sendMailTo).append("\nFrom: ").append("yacy@").append(sb.peers.mySeed().getName()).append("\nSubject: [YaCy] ").append(msgEntry.subject().replace('\n', ' ')).append("\nDate: ").append(msgEntry.date()).append("\n").append("\nMessage from: ").append(msgEntry.author()).append("/").append(msgEntry.authorHash()).append("\nMessage to:   ").append(msgEntry.recipient()).append("/").append(msgEntry.recipientHash()).append("\nCategory:     ").append(msgEntry.category()).append("\n===================================================================\n").append(UTF8.String(msgEntry.message()));
            Process process = Runtime.getRuntime().exec(sendMail);
            PrintWriter email = new PrintWriter(process.getOutputStream());
            email.print(emailTxt.toString());
            email.close();
        }
        catch (Exception e) {
            Network.log.warn("message: message forwarding via email failed. ", e);
        }
    }
}

