/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.federate.yacy.CacheStrategy;
import net.yacy.cora.language.synonyms.SynonymLibrary;
import net.yacy.cora.lod.vocabulary.DCTerms;
import net.yacy.cora.lod.vocabulary.Tagging;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.CommonPattern;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.crawler.retrieval.StreamResponse;
import net.yacy.data.TransactionManager;
import net.yacy.document.LibraryProvider;
import net.yacy.kelondro.data.meta.URIMetadataNode;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.repository.Blacklist;
import net.yacy.search.Switchboard;
import net.yacy.search.index.Segment;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class Vocabulary_p {
    private static final ConcurrentLog LOG = new ConcurrentLog(Vocabulary_p.class.getSimpleName());

    /*
     * WARNING - void declaration
     */
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        Tagging vocabulary;
        String discovername;
        String vocabularyName;
        Collection<Tagging> vocs;
        serverObjects prop;
        block59: {
            block60: {
                int csvFileStatus;
                File propFile;
                LinkedHashMap<String, Tagging.SOTuple> table;
                String discoverobjectspace;
                Switchboard sb;
                block61: {
                    Segment segment;
                    boolean discoverFromAuthor;
                    boolean discoverFromTitleSplitted;
                    boolean discoverFromTitle;
                    boolean discoverFromPath;
                    MultiProtocolURL discoveruri;
                    block62: {
                        String discoverFromCSVPath;
                        block63: {
                            sb = (Switchboard)env;
                            prop = new serverObjects();
                            String nextToken = TransactionManager.getTransactionToken(header);
                            prop.put("transactionToken", nextToken);
                            prop.put("edit_transactionToken", nextToken);
                            prop.put("create_transactionToken", nextToken);
                            vocs = LibraryProvider.autotagging.getVocabularies();
                            vocabularyName = post == null ? null : post.get("vocabulary", "");
                            discovername = post == null ? null : post.get("discovername", "");
                            Tagging tagging = vocabulary = vocabularyName == null || vocabularyName.length() == 0 ? null : LibraryProvider.autotagging.getVocabulary(vocabularyName);
                            if (vocabulary == null) {
                                vocabularyName = null;
                            }
                            if (post == null) break block59;
                            if (vocabulary != null || discovername == null || discovername.length() <= 0) break block60;
                            TransactionManager.checkPostTransaction(header, post);
                            discoverobjectspace = post.get("discoverobjectspace", "");
                            discoveruri = null;
                            if (discoverobjectspace.length() > 0) {
                                try {
                                    discoveruri = new MultiProtocolURL(discoverobjectspace);
                                }
                                catch (MalformedURLException malformedURLException) {
                                    // empty catch block
                                }
                            }
                            if (discoveruri == null) {
                                discoverobjectspace = "";
                            }
                            table = new LinkedHashMap<String, Tagging.SOTuple>();
                            propFile = LibraryProvider.autotagging.getVocabularyFile(discovername);
                            boolean discoverNot = post.get("discovermethod", "").equals("none");
                            discoverFromPath = post.get("discovermethod", "").equals("path");
                            discoverFromTitle = post.get("discovermethod", "").equals("title");
                            discoverFromTitleSplitted = post.get("discovermethod", "").equals("titlesplitted");
                            discoverFromAuthor = post.get("discovermethod", "").equals("author");
                            boolean discoverFromCSV = post.get("discovermethod", "").equals("csv");
                            discoverFromCSVPath = post.get("discoverpath", "").replaceAll("%20", " ");
                            segment = sb.index;
                            csvFileStatus = 0;
                            if (discoverNot) break block61;
                            if (!discoverFromCSV) break block62;
                            if (!discoverFromCSVPath.isEmpty()) break block63;
                            csvFileStatus = 1;
                            break block61;
                        }
                        DigestURL csvUrl = null;
                        if (discoverFromCSVPath.contains("://")) {
                            try {
                                csvUrl = new DigestURL(discoverFromCSVPath);
                            }
                            catch (MalformedURLException e) {
                                csvFileStatus = 5;
                                prop.put("create_csvFileStatus_csvUrl", discoverFromCSVPath);
                            }
                        } else {
                            File discoverFromCSVFile = new File(discoverFromCSVPath);
                            String csvPath = discoverFromCSVFile.getAbsolutePath();
                            if (!discoverFromCSVFile.exists()) {
                                csvFileStatus = 2;
                                prop.put("create_csvFileStatus_csvPath", csvPath);
                            } else if (!discoverFromCSVFile.canRead()) {
                                csvFileStatus = 3;
                                prop.put("create_csvFileStatus_csvFile", csvPath);
                            } else if (discoverFromCSVFile.isDirectory()) {
                                csvFileStatus = 4;
                                prop.put("create_csvFileStatus_csvPath", csvPath);
                            } else {
                                try {
                                    csvUrl = new DigestURL(discoverFromCSVFile);
                                }
                                catch (MalformedURLException e) {
                                    csvFileStatus = 5;
                                    prop.put("create_csvFileStatus_csvUrl", "file://" + discoverFromCSVFile.getAbsolutePath());
                                }
                            }
                        }
                        if (csvUrl == null) break block61;
                        try {
                            Vocabulary_p.handleDiscoverFromCSV(sb, post, table, csvUrl);
                        }
                        catch (IOException e) {
                            LOG.warn("Could not read CSV file at " + String.valueOf(csvUrl), e);
                            csvFileStatus = 3;
                            prop.put("create_csvFileStatus_csvFile", csvUrl.toString());
                        }
                        break block61;
                    }
                    Iterator<DigestURL> ui = segment.urlSelector(discoveruri, Long.MAX_VALUE, 100000);
                    while (ui.hasNext()) {
                        URIMetadataNode m;
                        DigestURL u = ui.next();
                        String u0 = u.toNormalform(true);
                        String t = "";
                        if (discoverFromPath) {
                            int p;
                            int slp;
                            int exp = u0.lastIndexOf(46);
                            if (exp < 0 || (slp = u0.lastIndexOf(47, exp)) < 0) continue;
                            t = u0.substring(slp, exp);
                            while ((p = t.indexOf(58)) >= 0) {
                                t = t.substring(p + 1);
                            }
                            while ((p = t.indexOf(61)) >= 0) {
                                t = t.substring(p + 1);
                            }
                        }
                        if (discoverFromTitle || discoverFromTitleSplitted) {
                            URIMetadataNode m2 = segment.fulltext().getMetadata(u.hash());
                            if (m2 != null) {
                                t = m2.dc_title();
                            }
                            if (t.endsWith(".jpg") || t.endsWith(".gif")) continue;
                        }
                        if (discoverFromAuthor && (m = segment.fulltext().getMetadata(u.hash())) != null) {
                            t = m.dc_creator();
                        }
                        if ((t = t.replaceAll("_", " ").replaceAll("\"", " ").replaceAll("'", " ").replaceAll(",", " ").replaceAll("  ", " ").trim()).isEmpty()) continue;
                        if (discoverFromTitleSplitted) {
                            String[] ts;
                            for (String string : ts = CommonPattern.SPACES.split(t)) {
                                if (string.isEmpty() || string.endsWith(".jpg") || string.endsWith(".gif")) continue;
                                table.put(string, new Tagging.SOTuple(Tagging.normalizeTerm(string), u0));
                            }
                            continue;
                        }
                        if (discoverFromAuthor) {
                            String[] ts;
                            for (String string : ts = CommonPattern.SEMICOLON.split(t)) {
                                void var31_67;
                                if (string.isEmpty()) continue;
                                int p = string.indexOf(44);
                                if (p >= 0) {
                                    String string2 = string.substring(p + 1).trim() + " " + string.substring(0, p).trim();
                                }
                                table.put((String)var31_67, new Tagging.SOTuple(Tagging.normalizeTerm((String)var31_67), u0));
                            }
                            continue;
                        }
                        table.put(t, new Tagging.SOTuple(Tagging.normalizeTerm(t), u0));
                    }
                }
                prop.put("create_csvFileStatus", csvFileStatus);
                if (csvFileStatus == 0) {
                    try {
                        Tagging newvoc = new Tagging(discovername, propFile, discoverobjectspace, table);
                        prop.put("create_vocabWriteError", false);
                        LibraryProvider.autotagging.addVocabulary(newvoc);
                        vocabularyName = discovername;
                        vocabulary = newvoc;
                        sb.tables.recordAPICall(post, "Vocabulary_p.html", "crawler", "vocabulary creation for " + discovername);
                    }
                    catch (IOException e) {
                        prop.put("create_vocabWriteError", true);
                        String vocabPath = propFile.getAbsolutePath();
                        prop.put("create_vocabWriteError_vocabPath", vocabPath);
                        LOG.severe("Could not write vocabulary file at " + vocabPath, e);
                    }
                }
                break block59;
            }
            if (vocabulary != null && post.containsKey("set")) {
                TransactionManager.checkPostTransaction(header, post);
                try {
                    String term;
                    vocabulary.setObjectspace(post.get("objectspace", vocabulary.getObjectspace() == null ? "" : vocabulary.getObjectspace()));
                    if (post.get("add_new", "").equals("checked") && post.get("newterm", "").length() > 0) {
                        Object objectlink = post.get("newobjectlink", "");
                        if (((String)objectlink).length() > 0) {
                            try {
                                objectlink = new MultiProtocolURL((String)objectlink).toNormalform(true);
                            }
                            catch (MalformedURLException discoveruri) {
                                // empty catch block
                            }
                        }
                        vocabulary.put(post.get("newterm", ""), post.get("newsynonyms", ""), (String)objectlink);
                    }
                    for (Map.Entry<String, String> e : post.entrySet()) {
                        if (!e.getKey().startsWith("modify_") || !e.getValue().equals("checked")) continue;
                        term = e.getKey().substring(7);
                        String synonyms = post.get("synonyms_" + term, "");
                        String objectlink = post.get("objectlink_" + term, "");
                        vocabulary.put(term, synonyms, objectlink);
                    }
                    if (post.get("clear_table", "").equals("checked")) {
                        vocabulary.clear();
                    }
                    if (post.get("delete_vocabulary", "").equals("checked")) {
                        LibraryProvider.autotagging.deleteVocabulary(vocabularyName);
                        vocabulary = null;
                        vocabularyName = null;
                    }
                    if (vocabulary != null && vocabulary.size() > 0) {
                        for (Map.Entry<String, String> e : post.entrySet()) {
                            if (!e.getKey().startsWith("delete_") || !e.getValue().equals("checked")) continue;
                            term = e.getKey().substring(7);
                            vocabulary.delete(term);
                        }
                    }
                    if (vocabulary != null && post.containsKey("set")) {
                        boolean isFacet = post.getBoolean("isFacet");
                        vocabulary.setFacet(isFacet);
                        Set<String> omit = env.getConfigSet("search.result.show.vocabulary.omit");
                        if (isFacet) {
                            omit.remove(vocabularyName);
                        } else {
                            omit.add(vocabularyName);
                        }
                        env.setConfig("search.result.show.vocabulary.omit", omit);
                        boolean isMatchFromLinkedData = post.getBoolean("vocabularies.matchLinkedData");
                        vocabulary.setMatchFromLinkedData(isMatchFromLinkedData);
                        Set<String> matchLinkedDataVocs = env.getConfigSet("vocabularies.matchLinkedData.names");
                        if (isMatchFromLinkedData) {
                            matchLinkedDataVocs.add(vocabularyName);
                        } else {
                            matchLinkedDataVocs.remove(vocabularyName);
                        }
                        env.setConfig("vocabularies.matchLinkedData.names", matchLinkedDataVocs);
                    }
                }
                catch (IOException e) {
                    ConcurrentLog.logException(e);
                }
            }
        }
        int count = 0;
        for (Tagging v : vocs) {
            prop.put("vocabularyset_" + count + "_name", v.getName());
            prop.put("vocabularyset_" + count + "_selected", vocabularyName != null && vocabularyName.equals(v.getName()) || discovername != null && discovername.equals(v.getName()) ? 1L : 0L);
            ++count;
        }
        prop.put("vocabularyset", count);
        prop.put("create", vocabularyName == null ? 1L : 0L);
        if (vocabulary == null) {
            prop.put("edit", 0L);
        } else {
            prop.put("edit", 1L);
            boolean editable = vocabulary.getFile() != null && vocabulary.getFile().exists();
            prop.put("edit_editable", editable ? 1L : 0L);
            prop.putHTML("edit_editable_file", editable ? vocabulary.getFile().getAbsolutePath() : "");
            prop.putHTML("edit_name", vocabulary.getName());
            prop.putXML("edit_namexml", vocabulary.getName());
            prop.putHTML("edit_namespace", vocabulary.getNamespace());
            prop.put("edit_isFacet", vocabulary.isFacet() ? 1L : 0L);
            prop.put("edit_vocabularies.matchLinkedData", vocabulary.isMatchFromLinkedData());
            prop.put("edit_size", vocabulary.size());
            prop.putHTML("edit_predicate", vocabulary.getPredicate());
            prop.putHTML("edit_prefix", "tags");
            prop.putHTML("edit_editable_objectspace", vocabulary.getObjectspace() == null ? "" : vocabulary.getObjectspace());
            prop.putHTML("edit_editable_objectspacepredicate", DCTerms.references.getPredicate());
            int c = 0;
            boolean dark = false;
            int osl = vocabulary.getObjectspace() == null ? 0 : vocabulary.getObjectspace().length();
            Map<String, Tagging.SOTuple> list2 = vocabulary.list();
            prop.put("edit_size", list2.size());
            for (Map.Entry<String, Tagging.SOTuple> entry2 : list2.entrySet()) {
                prop.put("edit_terms_" + c + "_editable", editable ? 1L : 0L);
                prop.put("edit_terms_" + c + "_dark", dark ? 1L : 0L);
                dark = !dark;
                prop.putXML("edit_terms_" + c + "_label", osl > entry2.getValue().getObjectlink().length() ? entry2.getKey() : entry2.getValue().getObjectlink().substring(osl));
                prop.putHTML("edit_terms_" + c + "_term", entry2.getKey());
                prop.putXML("edit_terms_" + c + "_termxml", entry2.getKey());
                prop.putHTML("edit_terms_" + c + "_editable_term", entry2.getKey());
                String synonymss = entry2.getValue().getSynonymsCSV();
                prop.putHTML("edit_terms_" + c + "_editable_synonyms", synonymss);
                if (synonymss.length() > 0) {
                    String[] synonymsa = entry2.getValue().getSynonymsList();
                    for (int i = 0; i < synonymsa.length; ++i) {
                        prop.put("edit_terms_" + c + "_synonyms_" + i + "_altLabel", synonymsa[i]);
                    }
                    prop.put("edit_terms_" + c + "_synonyms", synonymsa.length);
                } else {
                    prop.put("edit_terms_" + c + "_synonyms", 0L);
                }
                prop.putXML("edit_terms_" + c + "_editable_objectlink", entry2.getValue().getObjectlink());
                if (++c <= 3000) continue;
                break;
            }
            prop.put("edit_terms", c);
        }
        prop.putHTML("create_charset_0_name", "autodetect");
        prop.put("create_charset_0_selected", 1L);
        int c = 1;
        for (String cs : Charset.availableCharsets().keySet()) {
            prop.putHTML("create_charset_" + c + "_name", cs);
            prop.put("create_charset_" + c + "_selected", 0L);
            ++c;
        }
        prop.put("create_charset", c);
        return prop;
    }

    private static List<String> parseCSVLine(String line, Pattern separatorPattern, String escape, StringBuilder multiLineContent) {
        ArrayList<String> fields = new ArrayList<String>();
        String[] tokens = separatorPattern.split(line);
        if (tokens.length == 0) {
            tokens = new String[]{line};
        }
        if (multiLineContent.length() > 0) {
            int closingEscapeIndex = -1;
            for (int index2 = 0; index2 < tokens.length; ++index2) {
                if (!tokens[index2].endsWith(escape)) continue;
                closingEscapeIndex = index2;
                break;
            }
            if (closingEscapeIndex >= 0) {
                multiLineContent.append("\n").append(line);
                tokens = separatorPattern.split(multiLineContent.toString());
                multiLineContent.setLength(0);
                if (tokens.length == 0) {
                    tokens = new String[]{line};
                }
            } else {
                multiLineContent.append("\n").append(line);
                return fields;
            }
        }
        StringBuilder escapedSeparatorContent = new StringBuilder();
        for (String field : tokens) {
            if (escapedSeparatorContent.length() == 0) {
                if (field.startsWith(escape) && !field.endsWith(escape)) {
                    escapedSeparatorContent.append(field).append(separatorPattern.toString());
                    continue;
                }
            } else {
                if (field.endsWith(escape)) {
                    escapedSeparatorContent.append(field);
                    fields.add(escapedSeparatorContent.toString());
                    escapedSeparatorContent.setLength(0);
                    continue;
                }
                escapedSeparatorContent.append(field).append(separatorPattern.toString());
                continue;
            }
            fields.add(field);
        }
        if (escapedSeparatorContent.length() > 0) {
            multiLineContent.setLength(0);
            multiLineContent.append(line);
        }
        return fields;
    }

    protected static void handleDiscoverFromCSV(Switchboard sb, serverObjects post, Map<String, Tagging.SOTuple> table, DigestURL csvFileUrl) throws IOException, UnsupportedEncodingException, FileNotFoundException {
        StreamResponse streamResponse;
        Pattern separatorPattern;
        boolean discoverreadcolumn;
        boolean discoverenrichsynonyms;
        int discovercolumnobjectlink;
        int discovercolumnsynonyms;
        int discovercolumnliteral;
        int lineStart;
        String charsetName;
        block36: {
            charsetName = post.get("charset", StandardCharsets.UTF_8.name());
            String columnSeparator = post.get("columnSeparator", ";");
            String escapeChar = "\"";
            lineStart = post.getInt("discoverLineStart", 0);
            discovercolumnliteral = post.getInt("discovercolumnliteral", 0);
            discovercolumnsynonyms = post.getInt("discovercolumnsynonyms", -1);
            discovercolumnobjectlink = post.getInt("discovercolumnobjectlink", -1);
            discoverenrichsynonyms = post.get("discoversynonymsmethod", "none").equals("enrichsynonyms");
            discoverreadcolumn = post.get("discoversynonymsmethod", "none").equals("readcolumn");
            separatorPattern = Pattern.compile(columnSeparator);
            if (charsetName.equals("autodetect")) {
                streamResponse = sb.loader.openInputStream(sb.loader.request(csvFileUrl, true, false), CacheStrategy.IFFRESH, Blacklist.BlacklistType.CRAWLER, ClientIdentification.yacyInternetCrawlerAgent, Integer.MAX_VALUE);
                try {
                    if (streamResponse == null || streamResponse.getContentStream() == null) {
                        throw new IOException("Could not get CSV content at " + String.valueOf(csvFileUrl));
                    }
                    charsetName = streamResponse.getResponse().getCharacterEncoding();
                    if (charsetName == null) {
                        List<String> charsets = FileUtils.detectCharset(streamResponse.getContentStream());
                        charsetName = charsets.get(0);
                        LOG.info("detected charset: " + charsetName + " used to read " + csvFileUrl.toString());
                        break block36;
                    }
                    LOG.info("detected charset: " + charsetName + " used to read " + csvFileUrl.toString());
                    try (InputStreamReader reader = new InputStreamReader(streamResponse.getContentStream(), charsetName);
                         BufferedReader bufferedReader = new BufferedReader(reader);){
                        Vocabulary_p.discoverFromCSVReader(table, "\"", lineStart, discovercolumnliteral, discovercolumnsynonyms, discovercolumnobjectlink, discoverenrichsynonyms, discoverreadcolumn, separatorPattern, bufferedReader);
                    }
                    return;
                }
                finally {
                    if (streamResponse != null) {
                        streamResponse.close();
                    }
                }
            }
        }
        streamResponse = sb.loader.openInputStream(sb.loader.request(csvFileUrl, true, false), CacheStrategy.IFFRESH, Blacklist.BlacklistType.CRAWLER, ClientIdentification.yacyInternetCrawlerAgent, Integer.MAX_VALUE);
        try {
            if (streamResponse == null || streamResponse.getContentStream() == null) {
                throw new IOException("Could not get CSV content at " + String.valueOf(csvFileUrl));
            }
            try (InputStreamReader reader = new InputStreamReader(streamResponse.getContentStream(), charsetName);
                 BufferedReader bufferedReader = new BufferedReader(reader);){
                Vocabulary_p.discoverFromCSVReader(table, "\"", lineStart, discovercolumnliteral, discovercolumnsynonyms, discovercolumnobjectlink, discoverenrichsynonyms, discoverreadcolumn, separatorPattern, bufferedReader);
            }
        }
        finally {
            if (streamResponse != null) {
                streamResponse.close();
            }
        }
    }

    protected static void discoverFromCSVReader(Map<String, Tagging.SOTuple> table, String escapeChar, int lineStart, int literalsColumn, int synonymsColumn, int discovercolumnobjectlink, boolean discoverenrichsynonyms, boolean readSynonymFromColumn, Pattern separatorPattern, BufferedReader reader) throws IOException {
        String line = null;
        StringBuilder multiLineContent = new StringBuilder();
        HashMap<String, String> synonym2literal = new HashMap<String, String>();
        int lineIndex = -1;
        while ((line = reader.readLine()) != null) {
            String objectlink;
            Object literal;
            if (++lineIndex < lineStart || line.length() == 0) continue;
            List<String> fields = Vocabulary_p.parseCSVLine(line, separatorPattern, escapeChar, multiLineContent);
            if (multiLineContent.length() > 0) continue;
            Object object = literal = literalsColumn < 0 || fields.size() <= literalsColumn ? null : fields.get(literalsColumn).trim();
            if (literal == null) continue;
            literal = Vocabulary_p.normalizeLiteral(literal, escapeChar);
            String string = objectlink = discovercolumnobjectlink < 0 || fields.size() <= discovercolumnobjectlink ? null : fields.get(discovercolumnobjectlink).trim();
            if (((String)literal).length() <= 0) continue;
            Object synonyms = "";
            if (discoverenrichsynonyms) {
                Set<String> sy = SynonymLibrary.getSynonyms((String)literal);
                if (sy != null) {
                    for (String s : sy) {
                        synonyms = (String)synonyms + "," + s;
                    }
                }
            } else if (readSynonymFromColumn) {
                synonyms = synonymsColumn < 0 || fields.size() <= synonymsColumn ? null : fields.get(synonymsColumn).trim();
                synonyms = Vocabulary_p.normalizeLiteral((String)synonyms, escapeChar);
            } else {
                synonyms = Tagging.normalizeTerm((String)literal);
            }
            if (((String)synonyms).length() > 0) {
                String oldliteral = (String)synonym2literal.get(synonyms);
                if (oldliteral != null && !((String)literal).equals(oldliteral)) {
                    table.remove(oldliteral);
                    String newliteral = oldliteral + "," + (String)literal;
                    literal = newliteral;
                }
                synonym2literal.put((String)synonyms, (String)literal);
            }
            table.put((String)literal, new Tagging.SOTuple((String)synonyms, objectlink == null ? "" : objectlink));
        }
    }

    private static String normalizeLiteral(String literal, String escapeChar) {
        if (literal == null) {
            return "";
        }
        if (literal.length() > 1 && literal.startsWith(escapeChar) && literal.endsWith(escapeChar)) {
            literal = literal.replace("\"\"", "\"");
        }
        if (literal.length() > 0 && (literal.charAt(0) == '\"' || literal.charAt(0) == '\'')) {
            literal = literal.substring(1);
        }
        if (literal.length() > 0 && (literal.charAt(literal.length() - 1) == '\"' || literal.charAt(literal.length() - 1) == '\'')) {
            literal = literal.substring(0, literal.length() - 1);
        }
        return literal;
    }
}

