/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.http.servlets.TemplateMissingParameterException;
import net.yacy.peers.graphics.EncodedImage;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;
import net.yacy.visualization.ImageViewer;

public class ViewImage {
    private static final ImageViewer VIEWER = new ImageViewer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object respond(RequestHeader header, serverObjects post, serverSwitch env) throws IOException {
        EncodedImage encodedImage;
        Switchboard sb = (Switchboard)env;
        if (post == null) {
            throw new TemplateMissingParameterException("please fill at least url or code parameter");
        }
        String ext = header.get("EXT", null);
        boolean auth = ImageViewer.hasFullViewingRights(header, sb);
        DigestURL url = VIEWER.parseURL(post, auth);
        ImageInputStream imageInStream = null;
        InputStream inStream = null;
        try {
            String urlExt = MultiProtocolURL.getFileExtension(url.getFileName());
            if (ext != null && ext.equalsIgnoreCase(urlExt) && ImageViewer.isBrowserRendered(urlExt)) {
                InputStream inputStream = VIEWER.openInputStream(post, sb.loader, auth, url);
                return inputStream;
            }
            if (url.isFile()) {
                imageInStream = ImageIO.createImageInputStream(url.getFSFile());
            } else {
                inStream = VIEWER.openInputStream(post, sb.loader, auth, url);
                imageInStream = ImageIO.createImageInputStream(inStream);
            }
            encodedImage = VIEWER.parseAndScale(post, auth, url, ext, imageInStream);
        }
        catch (Exception e) {
            encodedImage = new EncodedImage(new byte[0], ext, post.getBoolean("isStatic"));
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return encodedImage;
    }
}

