/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.io.File;
import java.util.List;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.search.Switchboard;
import net.yacy.search.index.Segment;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;
import org.apache.solr.common.SolrException;

public class IndexExportImportSolr_p {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        File dump;
        Switchboard sb = (Switchboard)env;
        serverObjects prop = new serverObjects();
        Segment segment = sb.index;
        long ucount = segment.fulltext().collectionSize();
        prop.put("indexdump", 0L);
        prop.put("indexRestore", 0L);
        prop.put("dumprestore", 1L);
        prop.put("dumprestore_dumpRestoreEnabled", sb.getConfigBool("core.service.fulltext", true));
        List<File> dumpFiles = segment.fulltext().dumpFiles();
        prop.put("dumprestore_dumpfile", dumpFiles.size() == 0 ? "" : dumpFiles.get(dumpFiles.size() - 1).getAbsolutePath());
        prop.put("dumprestore_optimizemax", 10L);
        prop.putNum("ucount", ucount);
        if (post == null || env == null) {
            return prop;
        }
        if (post.containsKey("indexdump")) {
            try {
                dump = segment.fulltext().dumpEmbeddedSolr();
                prop.put("indexdump", 1L);
                prop.put("indexdump_dumpfile", dump.getAbsolutePath());
                dumpFiles = segment.fulltext().dumpFiles();
                prop.put("dumprestore_dumpfile", dumpFiles.size() == 0 ? "" : dumpFiles.get(dumpFiles.size() - 1).getAbsolutePath());
            }
            catch (SolrException e) {
                if (SolrException.ErrorCode.SERVICE_UNAVAILABLE.code == e.code()) {
                    prop.put("indexdump", 2L);
                }
                prop.put("indexdump", 3L);
            }
        }
        if (post.containsKey("indexrestore")) {
            try {
                dump = new File(post.get("dumpfile", ""));
                segment.fulltext().restoreEmbeddedSolr(dump);
                prop.put("indexRestore", 1L);
            }
            catch (SolrException e) {
                if (SolrException.ErrorCode.SERVICE_UNAVAILABLE.code == e.code()) {
                    prop.put("indexRestore", 2L);
                }
                prop.put("indexRestore", 3L);
            }
        }
        prop.putNum("ucount", ucount);
        return prop;
    }
}

