/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.net.MalformedURLException;
import java.time.Duration;
import java.util.Properties;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.data.TransactionManager;
import net.yacy.http.servlets.YaCyDefaultServlet;
import net.yacy.search.Switchboard;
import net.yacy.search.query.SearchEventCache;
import net.yacy.search.snippet.TextSnippet;
import net.yacy.server.http.HTTPDFileHandler;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class ConfigPortal_p {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        serverObjects prop = new serverObjects();
        Switchboard sb = (Switchboard)env;
        if (post != null) {
            boolean newStrictContentDom;
            boolean oldStrictContentDom;
            boolean newJsResort;
            boolean oldJsResort;
            TransactionManager.checkPostTransaction(header, post);
            boolean cleanSearchCache = false;
            if (post.containsKey("popup")) {
                String popup = post.get("popup", "status");
                if ("front".equals(popup)) {
                    sb.setConfig("browserPopUpPage", "index.html");
                } else if ("search".equals(popup)) {
                    sb.setConfig("browserPopUpPage", "yacysearch.html");
                } else if ("interactive".equals(popup)) {
                    sb.setConfig("browserPopUpPage", "yacyinteractive.html");
                } else {
                    sb.setConfig("browserPopUpPage", "Status.html");
                }
                sb.setConfig("browserPopUpPage", sb.getConfig("browserPopUpPage", "index.html"));
                HTTPDFileHandler.initDefaultPath();
            }
            if (post.containsKey("searchpage_set")) {
                String newGreeting = post.get("promoteSearchPageGreeting", "");
                sb.tables.recordAPICall(post, "ConfigPortal_p.html", "configuration", "new portal design. greeting: " + newGreeting);
                sb.setConfig("promoteSearchPageGreeting", newGreeting);
                sb.setConfig("promoteSearchPageGreeting.homepage", post.get("promoteSearchPageGreeting.homepage", ""));
                sb.setConfig("promoteSearchPageGreeting.largeImage", post.get("promoteSearchPageGreeting.largeImage", ""));
                sb.setConfig("promoteSearchPageGreeting.smallImage", post.get("promoteSearchPageGreeting.smallImage", ""));
                sb.setConfig("promoteSearchPageGreeting.imageAlt", post.get("promoteSearchPageGreeting.imageAlt", ""));
                sb.setConfig("search.target", post.get("target", "_self"));
                sb.setConfig("search.target.special", post.get("target_special", "_self"));
                sb.setConfig("search.target.special.pattern", post.get("target_special_pattern", "_self"));
                sb.setConfig("search.items", post.getInt("maximumRecords", 10));
                sb.setConfig("indexForward", post.get("indexForward", ""));
                HTTPDFileHandler.indexForward = post.get("indexForward", "");
                sb.setConfig("publicTopmenu", !post.containsKey("publicTopmenu") || post.getBoolean("publicTopmenu"));
                sb.setConfig("publicSearchpage", !post.containsKey("publicSearchpage") || post.getBoolean("publicSearchpage"));
                sb.setConfig("search.options", post.getBoolean("search.options"));
                oldJsResort = sb.getConfigBool("search.jsresort", false);
                newJsResort = post.getBoolean("search.jsresort");
                cleanSearchCache = cleanSearchCache || oldJsResort != newJsResort;
                sb.setConfig("search.jsresort", newJsResort);
                oldStrictContentDom = sb.getConfigBool("search.strictContentDom", false);
                newStrictContentDom = post.getBoolean("search.strictContentDom");
                cleanSearchCache = cleanSearchCache || oldStrictContentDom != newStrictContentDom;
                sb.setConfig("search.strictContentDom", newStrictContentDom);
                sb.setConfig("remotesearch.https.preferred", post.getBoolean("remotesearch.https.preferred"));
                sb.setConfig("greedylearning.active", post.getBoolean("greedylearning.active"));
                boolean storeresult = post.getBoolean("remotesearch.result.store");
                sb.setConfig("remotesearch.result.store", storeresult);
                sb.setConfig("remotesearch.result.store.maxsize", post.getLong("remotesearch.result.store.maxsize", -1L));
                sb.setConfig("search.verify", post.get("search.verify", "ifexist"));
                sb.setConfig("search.verify.delete", post.getBoolean("search.verify.delete"));
                sb.setConfig("about.headline", post.get("about.headline", ""));
                sb.setConfig("about.body", post.get("about.body", ""));
                String excludehosts = post.get("search.excludehosts", "");
                sb.setConfig("search.excludehosts", excludehosts);
                try {
                    sb.setConfig("search.excludehosth", DigestURL.hosthashes(excludehosts));
                }
                catch (MalformedURLException e) {
                    ConcurrentLog.logException(e);
                    sb.setConfig("search.excludehosth", "");
                }
            }
            if (post.containsKey("searchpage_default")) {
                Properties config = sb.loadDefaultConfig();
                sb.setConfig("promoteSearchPageGreeting", config.getProperty("promoteSearchPageGreeting", "P2P Web Search"));
                sb.setConfig("promoteSearchPageGreeting.homepage", config.getProperty("promoteSearchPageGreeting.homepage", "https://yacy.net"));
                sb.setConfig("promoteSearchPageGreeting.largeImage", config.getProperty("promoteSearchPageGreeting.largeImage", "env/grafics/YaCyLogo_120ppi.png"));
                sb.setConfig("promoteSearchPageGreeting.smallImage", config.getProperty("promoteSearchPageGreeting.smallImage", "env/grafics/YaCyLogo_60ppi.png"));
                sb.setConfig("promoteSearchPageGreeting.imageAlt", config.getProperty("promoteSearchPageGreeting.imageAlt", "YaCy project web site"));
                sb.setConfig("browserPopUpPage", config.getProperty("browserPopUpPage", "Status.html"));
                sb.setConfig("indexForward", config.getProperty("indexForward", ""));
                HTTPDFileHandler.indexForward = "";
                sb.setConfig("search.target", config.getProperty("search.target", "_self"));
                sb.setConfig("search.target.special", config.getProperty("search.target.special", "_self"));
                sb.setConfig("search.target.special.pattern", config.getProperty("search.target.special.pattern", ""));
                sb.setConfig("publicTopmenu", config.getProperty("publicTopmenu", "true"));
                sb.setConfig("publicSearchpage", config.getProperty("publicSearchpage", "true"));
                sb.setConfig("search.navigation", config.getProperty("search.navigation", "hosts,authors,namespace,topics"));
                sb.setConfig("search.options", config.getProperty("search.options", "true"));
                oldJsResort = sb.getConfigBool("search.jsresort", false);
                newJsResort = Boolean.parseBoolean(config.getProperty("search.jsresort", String.valueOf(false)));
                cleanSearchCache = cleanSearchCache || oldJsResort != newJsResort;
                sb.setConfig("search.jsresort", newJsResort);
                oldStrictContentDom = sb.getConfigBool("search.strictContentDom", false);
                newStrictContentDom = Boolean.parseBoolean(config.getProperty("search.strictContentDom", String.valueOf(false)));
                cleanSearchCache = cleanSearchCache || oldStrictContentDom != newStrictContentDom;
                sb.setConfig("search.strictContentDom", newStrictContentDom);
                sb.setConfig("remotesearch.https.preferred", Boolean.parseBoolean(config.getProperty("remotesearch.https.preferred", String.valueOf(false))));
                sb.setConfig("greedylearning.active", config.getProperty("greedylearning.active"));
                sb.setConfig("remotesearch.result.store", config.getProperty("remotesearch.result.store"));
                sb.setConfig("remotesearch.result.store.maxsize", config.getProperty("remotesearch.result.store.maxsize"));
                sb.setConfig("search.verify", config.getProperty("search.verify", "iffresh"));
                sb.setConfig("search.verify.delete", config.getProperty("search.verify.delete", "true"));
                sb.setConfig("about.headline", config.getProperty("about.headline", ""));
                sb.setConfig("about.body", config.getProperty("about.body", ""));
                sb.setConfig("search.excludehosts", config.getProperty("search.excludehosts", ""));
                sb.setConfig("search.excludehosth", config.getProperty("search.excludehosth", ""));
            }
            if (cleanSearchCache) {
                SearchEventCache.cleanupEvents(true);
            }
        }
        try {
            prop.put("transactionToken", TransactionManager.getTransactionToken(header));
        }
        catch (IllegalArgumentException e) {
            sb.log.fine("access by unauthorized or unknown user: no transaction token delivered");
        }
        prop.putHTML("promoteSearchPageGreeting", sb.getConfig("promoteSearchPageGreeting", ""));
        prop.putHTML("promoteSearchPageGreeting.homepage", sb.getConfig("promoteSearchPageGreeting.homepage", ""));
        prop.putHTML("promoteSearchPageGreeting.largeImage", sb.getConfig("promoteSearchPageGreeting.largeImage", ""));
        prop.putHTML("promoteSearchPageGreeting.smallImage", sb.getConfig("promoteSearchPageGreeting.smallImage", ""));
        prop.putHTML("promoteSearchPageGreeting.imageAlt", sb.getConfig("promoteSearchPageGreeting.imageAlt", ""));
        prop.putHTML("indexForward", sb.getConfig("indexForward", ""));
        prop.put("publicTopmenu", sb.getConfigBool("publicTopmenu", false) ? 1L : 0L);
        prop.put("publicSearchpage", sb.getConfigBool("publicSearchpage", false) ? 1L : 0L);
        prop.put("search.options", sb.getConfigBool("search.options", false) ? 1L : 0L);
        prop.put("search.jsresort", sb.getConfigBool("search.jsresort", false) ? 1L : 0L);
        prop.put("search.strictContentDom", sb.getConfigBool("search.strictContentDom", false) ? 1L : 0L);
        prop.put("remotesearch.https.preferred", sb.getConfigBool("remotesearch.https.preferred", false) ? 1L : 0L);
        boolean textSnippetsStatisticsEnabled = sb.getConfigBool("debug.snippets.statistics.enabled", false);
        prop.put("debug.snippets.statistics.enabled", textSnippetsStatisticsEnabled);
        prop.put("greedylearning.active", sb.getConfigBool("greedylearning.active", false) ? 1L : 0L);
        prop.put("greedylearning.limit.doccount", sb.getConfig("greedylearning.limit.doccount", "0"));
        prop.put("remotesearch.result.store", sb.getConfigBool("remotesearch.result.store", true) ? 1L : 0L);
        long resultStoredMaxSize = sb.getConfigLong("remotesearch.result.store.maxsize", -1L);
        if (resultStoredMaxSize > 0L) {
            prop.put("remotesearch.result.store.maxsize", resultStoredMaxSize);
        } else {
            prop.put("remotesearch.result.store.maxsize", "");
        }
        if (textSnippetsStatisticsEnabled) {
            long totalSnippets = TextSnippet.statistics.getTotalSnippets();
            long totalSnippetsInitTime = TextSnippet.statistics.getTotalInitTime();
            prop.put("debug.snippets.statistics.enabled_totalSnippets", totalSnippets);
            prop.put("debug.snippets.statistics.enabled_totalFromSolr", TextSnippet.statistics.getTotalFromSolr());
            prop.put("debug.snippets.statistics.enabled_totalFromCache", TextSnippet.statistics.getTotalFromCache());
            prop.put("debug.snippets.statistics.enabled_totalFromMetadata", TextSnippet.statistics.getTotalFromMetadata());
            prop.put("debug.snippets.statistics.enabled_totalFromWeb", TextSnippet.statistics.getTotalFromWeb());
            prop.put("debug.snippets.statistics.enabled_totalFailures", TextSnippet.statistics.getTotalFailures());
            prop.put("debug.snippets.statistics.enabled_snippetsMeanTime", ConfigPortal_p.formatDuration(totalSnippets > 0L ? totalSnippetsInitTime / totalSnippets : 0L));
            prop.put("debug.snippets.statistics.enabled_snippetsMaxTime", ConfigPortal_p.formatDuration(TextSnippet.statistics.getMaxInitTime()));
        }
        prop.put("search.verify.nocache", sb.getConfig("search.verify", "").equals("nocache") ? 1L : 0L);
        prop.put("search.verify.iffresh", sb.getConfig("search.verify", "").equals("iffresh") ? 1L : 0L);
        prop.put("search.verify.ifexist", sb.getConfig("search.verify", "").equals("ifexist") ? 1L : 0L);
        prop.put("search.verify.cacheonly", sb.getConfig("search.verify", "").equals("cacheonly") ? 1L : 0L);
        prop.put("search.verify.false", sb.getConfig("search.verify", "").equals("false") ? 1L : 0L);
        prop.put("search.verify.delete", sb.getConfigBool("search.verify.delete", true) ? 1L : 0L);
        prop.put("about.headline", sb.getConfig("about.headline", ""));
        prop.put("about.body", sb.getConfig("about.body", ""));
        prop.put("search.excludehosts", sb.getConfig("search.excludehosts", ""));
        prop.put("search.excludehosth", sb.getConfig("search.excludehosth", ""));
        String browserPopUpPage = sb.getConfig("browserPopUpPage", "ConfigBasic.html");
        prop.put("popupFront", 0L);
        prop.put("popupSearch", 0L);
        prop.put("popupInteractive", 0L);
        prop.put("popupStatus", 0L);
        if (browserPopUpPage.startsWith("index")) {
            prop.put("popupFront", 1L);
        } else if (browserPopUpPage.startsWith("yacysearch")) {
            prop.put("popupSearch", 1L);
        } else if (browserPopUpPage.startsWith("yacyinteractive")) {
            prop.put("popupInteractive", 1L);
        } else {
            prop.put("popupStatus", 1L);
        }
        prop.put("maximumRecords", sb.getConfigInt("search.items", 10));
        String target = sb.getConfig("search.target", "_self");
        prop.put("target_selected_blank", "_blank".equals(target) ? 1L : 0L);
        prop.put("target_selected_self", "_self".equals(target) ? 1L : 0L);
        prop.put("target_selected_parent", "_parent".equals(target) ? 1L : 0L);
        prop.put("target_selected_top", "_top".equals(target) ? 1L : 0L);
        prop.put("target_selected_searchresult", "searchresult".equals(target) ? 1L : 0L);
        String target_special = sb.getConfig("search.target.special", "_self");
        prop.put("target_selected_special_blank", "_blank".equals(target_special) ? 1L : 0L);
        prop.put("target_selected_special_self", "_self".equals(target_special) ? 1L : 0L);
        prop.put("target_selected_special_parent", "_parent".equals(target_special) ? 1L : 0L);
        prop.put("target_selected_special_top", "_top".equals(target_special) ? 1L : 0L);
        prop.put("target_selected_special_searchresult", "searchresult".equals(target_special) ? 1L : 0L);
        prop.put("target_special_pattern", sb.getConfig("search.target.special.pattern", ""));
        prop.put("myContext", YaCyDefaultServlet.getContext(header, sb));
        return prop;
    }

    private static String formatDuration(long durationValue) {
        Duration duration = Duration.ofMillis(durationValue);
        String formattedDuration = duration.getSeconds() > 0L ? duration.getSeconds() + "s" : duration.toMillis() + "ms";
        return formattedDuration;
    }
}

