/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.crawler.data.Cache;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class ConfigHTCache_p {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) throws IOException {
        Switchboard sb = (Switchboard)env;
        serverObjects prop = new serverObjects();
        if (post != null && post.containsKey("set")) {
            String oldProxyCachePath = env.getConfig("proxyCache", "DATA/HTCACHE");
            String newProxyCachePath = post.get("HTCachePath", "DATA/HTCACHE");
            if ((newProxyCachePath = newProxyCachePath.replace('\\', '/')).endsWith("/")) {
                newProxyCachePath = newProxyCachePath.substring(0, newProxyCachePath.length() - 1);
            }
            env.setConfig("proxyCache", newProxyCachePath);
            File cache = env.getDataPath("proxyCache", oldProxyCachePath);
            if (!cache.isDirectory() && !cache.isFile()) {
                cache.mkdirs();
            }
            int newProxyCacheSize = Math.max(post.getInt("maxCacheSize", 64), 0);
            env.setConfig("proxyCacheSize", newProxyCacheSize);
            Cache.setMaxCacheSize((long)newProxyCacheSize * 1024L * 1024L);
            int newCompressionLevel = Math.max(0, Math.min(9, post.getInt("compressionLevel", 9)));
            env.setConfig("proxyCache.compressionLevel", newCompressionLevel);
            Cache.setCompressionLevel(newCompressionLevel);
            long newLockTimeout = Math.max(10L, Math.min(60000L, post.getLong("lockTimeout", 2000L)));
            env.setConfig("proxyCache.sync.lockTimeout", newLockTimeout);
            Cache.setLockTimeout(newLockTimeout);
        }
        if (post != null && post.containsKey("deletecomplete")) {
            if ("on".equals(post.get("deleteCache", ""))) {
                Cache.clear();
            }
            if ("on".equals(post.get("deleteRobots", ""))) {
                sb.robots.clear();
            }
        }
        prop.put("HTCachePath", env.getConfig("proxyCache", "DATA/HTCACHE"));
        int configuredCompressionLevel = env.getConfigInt("proxyCache.compressionLevel", 9);
        int levelsCount = 0;
        for (int level = 0; level <= 9; ++level) {
            if (level == configuredCompressionLevel) {
                prop.put("compressionLevels_" + levelsCount + "_selected", "1");
            } else {
                prop.put("compressionLevels_" + levelsCount + "_selected", "0");
            }
            prop.put("compressionLevels_" + levelsCount + "_value", level);
            prop.put("compressionLevels_" + levelsCount + "_name", level);
            if (level == 0) {
                prop.put("compressionLevels_" + levelsCount + "_name", "0 - No compression");
            } else if (level == 1) {
                prop.put("compressionLevels_" + levelsCount + "_name", "1 - Best speed");
            } else if (level == 9) {
                prop.put("compressionLevels_" + levelsCount + "_name", "9 - Best compression");
            }
            ++levelsCount;
        }
        prop.put("compressionLevels", levelsCount);
        prop.put("lockTimeout", env.getConfigLong("proxyCache.sync.lockTimeout", 2000L));
        prop.put("actualCacheSize", Cache.getActualCacheSize() / 1024L / 1024L);
        prop.put("actualCacheDocCount", Cache.getActualCacheDocCount());
        prop.put("docSizeAverage", Cache.getActualCacheDocCount() == 0L ? 0L : Cache.getActualCacheSize() / Cache.getActualCacheDocCount() / 1024L);
        prop.put("maxCacheSize", env.getConfigLong("proxyCacheSize", 64L));
        long hits = Cache.getHits();
        long totalRequests = Cache.getTotalRequests();
        prop.put("hits", hits);
        prop.put("requests", totalRequests);
        prop.put("hitRate", NumberFormat.getPercentInstance().format(Cache.getHitRate()));
        return prop;
    }
}

