/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.parser;

import java.io.IOException;
import java.io.InputStream;
import net.yacy.document.parser.AbstractCompressorParser;
import net.yacy.kelondro.util.MemoryControl;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZUtils;

public class XZParser
extends AbstractCompressorParser {
    public XZParser() {
        super("XZ Compressed Archive Parser");
        this.SUPPORTED_EXTENSIONS.add("xz");
        this.SUPPORTED_EXTENSIONS.add("txz");
        this.SUPPORTED_MIME_TYPES.add("application/x-xz");
    }

    @Override
    protected CompressorInputStream createDecompressStream(InputStream source) throws IOException {
        long availableMemory = MemoryControl.available();
        long maxKBytes = (long)((double)availableMemory * 0.25 / 1024.0);
        return new XZCompressorInputStream(source, false, (int)Math.min(Integer.MAX_VALUE, maxKBytes));
    }

    @Override
    protected String getUncompressedFilename(String filename) {
        return XZUtils.getUncompressedFileName((String)filename);
    }
}

