/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.storage;

import java.lang.invoke.CallSite;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import net.yacy.cora.storage.ARC;
import net.yacy.cora.storage.SimpleARC;

public final class HashARC<K, V>
extends SimpleARC<K, V>
implements Map<K, V>,
Iterable<Map.Entry<K, V>>,
ARC<K, V> {
    public static final boolean accessOrder = false;

    public HashARC(int cacheSize) {
        this.cacheSize = cacheSize / 2;
        this.levelA = Collections.synchronizedMap(new LinkedHashMap<K, V>(1, 0.1f, false){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                return this.size() > HashARC.this.cacheSize;
            }
        });
        this.levelB = Collections.synchronizedMap(new LinkedHashMap<K, V>(1, 0.1f, false){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                return this.size() > HashARC.this.cacheSize;
            }
        });
    }

    public static void main(String[] args) {
        Random r = new Random();
        int testsize = 10000;
        HashARC<Object, Object> a = new HashARC<Object, Object>(20000);
        HashMap<CallSite, CallSite> b = new HashMap<CallSite, CallSite>();
        for (int i = 0; i < 10000; ++i) {
            String key = "k" + r.nextInt();
            String value = "v" + r.nextInt();
            a.insertIfAbsent((Object)key, (Object)value);
            b.put((CallSite)((Object)key), (CallSite)((Object)value));
        }
        int h = 5000;
        for (Map.Entry entry2 : b.entrySet()) {
            a.put((String)entry2.getKey(), (String)entry2.getValue());
            if (h-- > 0) continue;
            break;
        }
        for (Map.Entry entry2 : b.entrySet()) {
            if (!a.containsKey((Object)((String)entry2.getKey()))) {
                System.out.println("missing: " + (String)entry2.getKey());
                continue;
            }
            if (((String)a.get((Object)((String)entry2.getKey()))).equals(entry2.getValue())) continue;
            System.out.println("wrong: a = " + (String)entry2.getKey() + "," + (String)a.get((Object)((String)entry2.getKey())) + "; v = " + (String)entry2.getValue());
        }
        System.out.println("finished test!");
    }
}

