/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.sorting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.yacy.cora.sorting.AbstractScoreMap;
import net.yacy.cora.sorting.ScoreMap;
import net.yacy.cora.sorting.ScoreMapUpdatesListener;

public class ConcurrentScoreMap<E>
extends AbstractScoreMap<E>
implements ScoreMap<E> {
    protected final ConcurrentHashMap<E, AtomicInteger> map = new ConcurrentHashMap();
    private long gcount = 0L;
    private ScoreMapUpdatesListener updatesListener;

    public ConcurrentScoreMap() {
        this(null);
    }

    public ConcurrentScoreMap(ScoreMapUpdatesListener updatesListener) {
        this.updatesListener = updatesListener;
    }

    private void dispatchUpdateToListener() {
        if (this.updatesListener != null) {
            this.updatesListener.updatedScoreMap();
        }
    }

    @Override
    public Iterator<E> iterator() {
        return ((ConcurrentHashMap.KeySetView)this.map.keySet()).iterator();
    }

    @Override
    public synchronized void clear() {
        this.map.clear();
        this.gcount = 0L;
        this.dispatchUpdateToListener();
    }

    @Override
    public int shrinkToMaxSize(int maxsize) {
        if (this.map.size() <= maxsize) {
            return 0;
        }
        int deletedNb = 0;
        int minScore = this.getMinScore();
        while (this.map.size() > maxsize) {
            deletedNb += this.shrinkToMinScore(++minScore);
        }
        return deletedNb;
    }

    @Override
    public int shrinkToMinScore(int minScore) {
        Iterator<Map.Entry<E, AtomicInteger>> i = this.map.entrySet().iterator();
        int deletedNb = 0;
        while (i.hasNext()) {
            Map.Entry<E, AtomicInteger> entry2 = i.next();
            if (entry2.getValue().intValue() >= minScore) continue;
            i.remove();
            ++deletedNb;
        }
        if (deletedNb > 0) {
            this.dispatchUpdateToListener();
        }
        return deletedNb;
    }

    public long totalCount() {
        return this.gcount;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean sizeSmaller(int size) {
        return this.map.size() < size;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public void inc(E obj) {
        if (obj == null) {
            return;
        }
        this.map.putIfAbsent(obj, new AtomicInteger(0));
        this.map.get(obj).incrementAndGet();
        ++this.gcount;
        this.dispatchUpdateToListener();
    }

    @Override
    public void dec(E obj) {
        if (obj == null) {
            return;
        }
        this.map.putIfAbsent(obj, new AtomicInteger(0));
        this.map.get(obj).decrementAndGet();
        --this.gcount;
        this.dispatchUpdateToListener();
    }

    @Override
    public void set(E obj, int newScore) {
        if (obj == null) {
            return;
        }
        AtomicInteger old = this.map.putIfAbsent(obj, new AtomicInteger(newScore));
        if (old != null) {
            this.gcount -= (long)old.intValue();
            this.map.get(obj).set(newScore);
        }
        this.gcount += (long)newScore;
        this.dispatchUpdateToListener();
    }

    @Override
    public void inc(E obj, int incrementScore) {
        if (obj == null) {
            return;
        }
        this.map.putIfAbsent(obj, new AtomicInteger(0));
        this.map.get(obj).addAndGet(incrementScore);
        this.gcount += (long)incrementScore;
        this.dispatchUpdateToListener();
    }

    @Override
    public void dec(E obj, int decrementScore) {
        this.inc(obj, -decrementScore);
    }

    @Override
    public int delete(E obj) {
        if (obj == null) {
            return 0;
        }
        AtomicInteger score = this.map.remove(obj);
        if (score == null) {
            return 0;
        }
        this.gcount -= (long)score.intValue();
        this.dispatchUpdateToListener();
        return score.intValue();
    }

    @Override
    public boolean containsKey(E obj) {
        return this.map.containsKey(obj);
    }

    @Override
    public int get(E obj) {
        if (obj == null) {
            return 0;
        }
        AtomicInteger score = this.map.get(obj);
        if (score == null) {
            return 0;
        }
        return score.intValue();
    }

    public int getMinScore() {
        if (this.map.isEmpty()) {
            return -1;
        }
        int minScore = Integer.MAX_VALUE;
        for (Map.Entry<E, AtomicInteger> entry2 : this.map.entrySet()) {
            if (entry2.getValue().intValue() >= minScore) continue;
            minScore = entry2.getValue().intValue();
        }
        return minScore;
    }

    public int getMaxScore() {
        if (this.map.isEmpty()) {
            return -1;
        }
        int maxScore = Integer.MIN_VALUE;
        for (Map.Entry<E, AtomicInteger> entry2 : this.map.entrySet()) {
            if (entry2.getValue().intValue() <= maxScore) continue;
            maxScore = entry2.getValue().intValue();
        }
        return maxScore;
    }

    @Override
    public String toString() {
        return this.map.toString();
    }

    @Override
    public Iterator<E> keys(boolean up) {
        TreeMap m = new TreeMap();
        for (Map.Entry<E, AtomicInteger> entry2 : this.map.entrySet()) {
            Integer is = entry2.getValue().intValue();
            HashSet s = (HashSet)m.get(is);
            if (s == null) {
                s = new HashSet();
                s.add(entry2.getKey());
                m.put(is, s);
                continue;
            }
            s.add(entry2.getKey());
        }
        ArrayList l = new ArrayList(m.size());
        for (Set f : m.values()) {
            for (Object e : f) {
                l.add(e);
            }
        }
        if (up) {
            return l.iterator();
        }
        ArrayList r = new ArrayList(l.size());
        for (int i = l.size() - 1; i >= 0; --i) {
            r.add(l.get(i));
        }
        return r.iterator();
    }

    public Iterator<E> keysByNaturalOrder(boolean up) {
        TreeSet<Object> sortedKeys = up ? new TreeSet() : new TreeSet(Collections.reverseOrder());
        for (Object key : this.map.keySet()) {
            sortedKeys.add(key);
        }
        return sortedKeys.iterator();
    }

    public void setUpdatesListener(ScoreMapUpdatesListener updatesListener) {
        this.updatesListener = updatesListener;
    }

    public static void main(String[] args) {
        ConcurrentScoreMap<String> a = new ConcurrentScoreMap<String>();
        a.set("a", 55);
        a.set("b", 3);
        a.set("c", 80);
        Iterator i = a.keys(true);
        while (i.hasNext()) {
            System.out.println((String)i.next());
        }
    }
}

