/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.protocol.http;

import java.io.IOException;
import net.yacy.cora.protocol.http.StrictSizeLimitEntityWrapper;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.protocol.HttpContext;

public class StrictSizeLimitResponseInterceptor
implements HttpResponseInterceptor {
    private final long maxBytes;

    public StrictSizeLimitResponseInterceptor(long maxBytes) {
        if (maxBytes < 0L) {
            throw new IllegalArgumentException("The maxBytes parameter must be greater or equals than zero");
        }
        this.maxBytes = maxBytes;
    }

    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            response.setEntity((HttpEntity)new StrictSizeLimitEntityWrapper(entity, this.maxBytes));
        }
    }
}

