/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.federate.yacy;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.TreeMap;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.federate.yacy.Peer;
import net.yacy.cora.federate.yacy.api.Network;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.protocol.http.HTTPClient;
import net.yacy.cora.util.ConcurrentLog;

public class Peers
extends TreeMap<byte[], Peer>
implements Serializable {
    private static final ConcurrentLog log = new ConcurrentLog(Peers.class.getName());
    private static final long serialVersionUID = -2939656606305545080L;
    private long lastBootstrap = 0L;

    public Peers() {
        super(Base64Order.enhancedCoder);
    }

    public void refresh() {
        if (System.currentTimeMillis() - this.lastBootstrap < 60000L) {
            return;
        }
        this.lastBootstrap = System.currentTimeMillis();
        new Thread("Peers.refresh"){

            @Override
            public void run() {
                String[] peers = Peers.bootstrapList(Peers.this.select(false, false));
                Peers.this.bootstrap(peers, 1);
            }
        }.start();
    }

    public void bootstrap(String[] peers, int selection) {
        int loops = 0;
        while (this.size() == 0 || loops++ == 0) {
            if (selection > peers.length) {
                selection = peers.length;
            }
            HashSet<Integer> s = new HashSet<Integer>();
            Random r = new Random(System.currentTimeMillis());
            while (s.size() < selection) {
                s.add(r.nextInt(peers.length));
            }
            ArrayList<2> t = new ArrayList<2>();
            for (Integer n : s) {
                final String bp = peers[n];
                Thread t0 = new Thread(this, "Peers.bootstrap-" + bp){
                    final /* synthetic */ Peers this$0;
                    {
                        this.this$0 = this$0;
                        super(arg0);
                    }

                    @Override
                    public void run() {
                        try {
                            Peers ps = Network.getNetwork(bp);
                            int c0 = this.this$0.size();
                            for (Peer p : ps.values()) {
                                this.this$0.add(p);
                            }
                            int c1 = this.this$0.size();
                            log.info("bootstrap with peer " + bp + ": added " + (c1 - c0) + " peers");
                        }
                        catch (IOException e) {
                            log.info("bootstrap with peer " + bp + ": FAILED - " + e.getMessage());
                        }
                    }
                };
                t0.start();
                t.add(t0);
            }
            for (Thread thread : t) {
                try {
                    thread.join(10000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.lastBootstrap = System.currentTimeMillis();
        log.info("bootstrap finished: " + this.size() + " peers");
    }

    public synchronized void add(Peer peer) {
        String hash = (String)peer.get(Peer.Schema.hash);
        if (hash == null) {
            return;
        }
        Peer p = this.put(ASCII.getBytes(hash), peer);
        if (p == null) {
            return;
        }
        if (p.lastseenTime() < peer.lastseenTime()) {
            this.put(ASCII.getBytes(hash), p);
        }
    }

    public synchronized Peer get(String hash) {
        return (Peer)super.get(ASCII.getBytes(hash));
    }

    public synchronized List<Peer> select(boolean requireNode, boolean requireSolr) {
        ArrayList<Peer> l = new ArrayList<Peer>();
        for (Peer p : this.values()) {
            if (requireNode && !((String)p.get(Peer.Schema.nodestate)).equals("1") || requireSolr && !p.supportsSolr()) continue;
            l.add(p);
        }
        return l;
    }

    public static synchronized String[] bootstrapList(List<Peer> peers) {
        ArrayList<String> l = new ArrayList<String>();
        for (Peer p : peers) {
            l.add((String)p.get(Peer.Schema.address));
        }
        return l.toArray(new String[l.size()]);
    }

    public static void main(String[] args) {
        String[] bootstrapPeers = new String[]{"search.yacy.net", "yacy.dyndns.org:8000", "yacy-websuche.mxchange.org:8090", "sokrates.homeunix.net:6070", "sokrates.homeunix.net:9090", "141.52.175.27:8080", "62.75.214.113:8080", "141.52.175.30:8080"};
        Peers peers = new Peers();
        peers.bootstrap(bootstrapPeers, 4);
        List<Peer> nodes = peers.select(false, true);
        for (Peer p : nodes) {
            log.info((String)p.get(Peer.Schema.fullname) + " - " + (String)p.get(Peer.Schema.address));
        }
        try {
            HTTPClient.closeConnectionManager();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

