/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.federate.solr.instance;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.yacy.cora.federate.solr.connector.ShardSelection;
import net.yacy.cora.federate.solr.instance.RemoteInstance;
import net.yacy.cora.federate.solr.instance.ServerShard;
import net.yacy.cora.federate.solr.instance.SolrInstance;
import org.apache.solr.client.solrj.SolrClient;

public class ShardInstance
implements SolrInstance {
    private final ArrayList<RemoteInstance> instances;
    private final ShardSelection.Method method;
    private SolrClient defaultServer;
    private Map<String, SolrClient> serverCache;
    private final boolean writeEnabled;

    public ShardInstance(ArrayList<RemoteInstance> instances, ShardSelection.Method method, boolean writeEnabled) {
        this.instances = instances;
        this.method = method;
        this.writeEnabled = writeEnabled;
        this.defaultServer = null;
        this.serverCache = new ConcurrentHashMap<String, SolrClient>();
    }

    @Override
    public String getDefaultCoreName() {
        return this.instances.get(0).getDefaultCoreName();
    }

    @Override
    public Collection<String> getCoreNames() {
        return this.instances.get(0).getCoreNames();
    }

    @Override
    public SolrClient getDefaultServer() {
        if (this.defaultServer != null) {
            return this.defaultServer;
        }
        ArrayList<SolrClient> server = new ArrayList<SolrClient>(this.instances.size());
        for (int i = 0; i < this.instances.size(); ++i) {
            server.set(i, this.instances.get(i).getDefaultServer());
        }
        this.defaultServer = new ServerShard(server, this.method, this.writeEnabled);
        return this.defaultServer;
    }

    @Override
    public SolrClient getServer(String name) {
        SolrClient s = this.serverCache.get(name);
        if (s != null) {
            return s;
        }
        ArrayList<SolrClient> server = new ArrayList<SolrClient>(this.instances.size());
        for (int i = 0; i < this.instances.size(); ++i) {
            server.add(i, this.instances.get(i).getServer(name));
        }
        s = new ServerShard(server, this.method, this.writeEnabled);
        this.serverCache.put(name, s);
        return s;
    }

    @Override
    public void close() {
        for (RemoteInstance instance : this.instances) {
            instance.close();
        }
    }

    public ArrayList<String> getAdminInterfaces(boolean toExternalAddress, String externalHost) {
        ArrayList<String> a = new ArrayList<String>();
        for (RemoteInstance i : this.instances) {
            a.add(i.getAdminInterface(toExternalAddress, externalHost));
        }
        return a;
    }
}

