/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.ai.llama3.Tensor;

import java.nio.ByteBuffer;
import net.yacy.ai.llama3.Model.GGMLType;
import net.yacy.ai.llama3.Tensor.AbstractFloatTensor;
import net.yacy.ai.llama3.Tensor.ArrayFloatTensor;
import net.yacy.ai.llama3.Tensor.FloatTensor;

public final class Q8_0FloatTensor
extends AbstractFloatTensor {
    final int size;
    final ByteBuffer buffer;

    public Q8_0FloatTensor(int size, ByteBuffer buffer) {
        this.size = size;
        this.buffer = buffer;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void setFloat(int index2, float value) {
        throw new UnsupportedOperationException("setFloat");
    }

    @Override
    public GGMLType type() {
        return GGMLType.Q8_0;
    }

    @Override
    public final float getFloat(int index2) {
        assert (0 <= index2 && index2 < this.size);
        int blockIndex = index2 / GGMLType.Q8_0.blockSize;
        int withinBlockIndex = index2 % GGMLType.Q8_0.blockSize;
        int blockOffset = blockIndex * GGMLType.Q8_0.typeSize;
        byte quant = this.buffer.get((int)((long)(blockOffset + 2 + withinBlockIndex)));
        long offset = blockOffset;
        float scale = AbstractFloatTensor.float16ToFloat(this.buffer.getShort((int)offset));
        return (float)quant * scale;
    }

    @Override
    public float dot(int thisOffset, FloatTensor that, int thatOffset, int size) {
        assert (0 <= thisOffset && thisOffset + size <= this.size);
        assert (0 <= thatOffset && thatOffset + size <= that.size());
        float result = 0.0f;
        int firstBlock = thisOffset / GGMLType.Q8_0.blockSize;
        int lastBlock = (thisOffset + size - 1) / GGMLType.Q8_0.blockSize;
        for (int block = firstBlock; block <= lastBlock; ++block) {
            int blockStart = block * GGMLType.Q8_0.blockSize;
            int blockEnd = blockStart + GGMLType.Q8_0.blockSize;
            int start = Math.max(thisOffset, blockStart);
            int end = Math.min(thisOffset + size, blockEnd);
            int length = end - start;
            int blockOffset = block * GGMLType.Q8_0.typeSize;
            long offset = blockOffset;
            float thisScale = AbstractFloatTensor.float16ToFloat(this.buffer.getShort((int)offset));
            float blockSum = 0.0f;
            int withinBlockStart = start % GGMLType.Q8_0.blockSize;
            int memOffset = blockOffset + 2 + withinBlockStart;
            int thatoffset = thatOffset + (start - thisOffset);
            if (that instanceof ArrayFloatTensor) {
                ArrayFloatTensor thatArray = (ArrayFloatTensor)that;
                for (int i = 0; i < length; ++i) {
                    blockSum += (float)this.buffer.get((int)((long)memOffset++)) * thatArray.getFloat(thatoffset++);
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    blockSum += (float)this.buffer.get((int)((long)memOffset++)) * that.getFloat(thatoffset++);
                }
            }
            result += thisScale * blockSum;
        }
        return result;
    }

    @Override
    public void copyTo(int thisOffset, FloatTensor that, int thatOffset, int size) {
        assert (0 <= thisOffset && thisOffset + size <= this.size);
        assert (0 <= thatOffset && thatOffset + size <= that.size());
        int endOffset = thatOffset + size;
        for (int i = thatOffset; i < endOffset; ++i) {
            int index2 = i - thatOffset + thisOffset;
            int blockIndex = index2 / GGMLType.Q8_0.blockSize;
            int withinBlockIndex = index2 % GGMLType.Q8_0.blockSize;
            int blockOffset = blockIndex * GGMLType.Q8_0.typeSize;
            byte quant = this.buffer.get((int)((long)(blockOffset + 2 + withinBlockIndex)));
            long offset = blockOffset;
            float scale = AbstractFloatTensor.float16ToFloat(this.buffer.getShort((int)offset));
            that.setFloat(i, (float)quant * scale);
        }
    }
}

