/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import java.util.Comparator;
import java.util.List;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.function.Function2;

public class SourceSorter<TAccumulate, TSource, TSortKey> {
    private final Function2<TAccumulate, TSource, TAccumulate> accumulatorAdder;
    private final Function1<TSource, TSortKey> keySelector;
    private final Comparator<TSortKey> comparator;

    public SourceSorter(Function2<TAccumulate, TSource, TAccumulate> accumulatorAdder, Function1<TSource, TSortKey> keySelector, Comparator<TSortKey> comparator) {
        this.accumulatorAdder = accumulatorAdder;
        this.keySelector = keySelector;
        this.comparator = comparator;
    }

    public void sortAndAccumulate(Iterable<TSource> sourceIterable, TAccumulate accumulator) {
        List sorted = Linq4j.asEnumerable(sourceIterable).orderBy(this.keySelector, this.comparator).toList();
        Object accumulator1 = accumulator;
        for (Object source : sorted) {
            accumulator1 = this.accumulatorAdder.apply(accumulator1, source);
        }
    }
}

