/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.graph;

import java.awt.Font;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import java.util.TimeZone;
import org.rrd4j.ConsolFun;
import org.rrd4j.core.Util;
import org.rrd4j.core.XmlTemplate;
import org.rrd4j.graph.RrdGraphConstants;
import org.rrd4j.graph.RrdGraphDef;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class RrdGraphDefTemplate
extends XmlTemplate
implements RrdGraphConstants {
    private static final String COLOR = "color";
    private static final String LEGEND = "legend";
    private static final String DATASOURCE = "datasource";
    private static final String WIDTH = "width";
    private static final String SOURCE = "source";
    private static final String SHOW_GRID = "show_grid";
    private RrdGraphDef rrdGraphDef;

    public RrdGraphDefTemplate(InputSource inputSource) throws IOException {
        super(inputSource);
    }

    public RrdGraphDefTemplate(File xmlFile) throws IOException {
        super(xmlFile);
    }

    public RrdGraphDefTemplate(String xmlString) throws IOException {
        super(xmlString);
    }

    public RrdGraphDef getRrdGraphDef() {
        Node[] childNodes;
        if (!this.root.getTagName().equals("rrd_graph_def")) {
            throw new IllegalArgumentException("XML definition must start with <rrd_graph_def>");
        }
        this.validateTagsOnlyOnce(this.root, new String[]{"filename", "span", "options", "datasources", "graph"});
        this.rrdGraphDef = new RrdGraphDef();
        for (Node childNode : childNodes = RrdGraphDefTemplate.getChildNodes(this.root)) {
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("filename")) {
                this.resolveFilename(childNode);
                continue;
            }
            if (nodeName.equals("span")) {
                this.resolveSpan(childNode);
                continue;
            }
            if (nodeName.equals("options")) {
                this.resolveOptions(childNode);
                continue;
            }
            if (nodeName.equals("datasources")) {
                this.resolveDatasources(childNode);
                continue;
            }
            if (!nodeName.equals("graph")) continue;
            this.resolveGraphElements(childNode);
        }
        return this.rrdGraphDef;
    }

    private void resolveGraphElements(Node graphNode) {
        Node[] childNodes;
        this.validateTagsOnlyOnce(graphNode, new String[]{"area*", "line*", "stack*", "print*", "gprint*", "hrule*", "vrule*", "comment*"});
        for (Node childNode : childNodes = RrdGraphDefTemplate.getChildNodes(graphNode)) {
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("area")) {
                this.resolveArea(childNode);
                continue;
            }
            if (nodeName.equals("line")) {
                this.resolveLine(childNode);
                continue;
            }
            if (nodeName.equals("stack")) {
                this.resolveStack(childNode);
                continue;
            }
            if (nodeName.equals("print")) {
                this.resolvePrint(childNode, false);
                continue;
            }
            if (nodeName.equals("gprint")) {
                this.resolvePrint(childNode, true);
                continue;
            }
            if (nodeName.equals("hrule")) {
                this.resolveHRule(childNode);
                continue;
            }
            if (nodeName.equals("vrule")) {
                this.resolveVRule(childNode);
                continue;
            }
            if (!nodeName.equals("comment")) continue;
            this.rrdGraphDef.comment(this.getValue(childNode, false));
        }
    }

    private void resolveVRule(Node parentNode) {
        Node[] childNodes;
        this.validateTagsOnlyOnce(parentNode, new String[]{"time", COLOR, LEGEND});
        long timestamp = Long.MIN_VALUE;
        Paint color = null;
        String legend = null;
        for (Node childNode : childNodes = RrdGraphDefTemplate.getChildNodes(parentNode)) {
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("time")) {
                timestamp = Util.getTimestamp(this.getValue(childNode));
                continue;
            }
            if (nodeName.equals(COLOR)) {
                color = this.getValueAsColor(childNode);
                continue;
            }
            if (!nodeName.equals(LEGEND)) continue;
            legend = this.getValue(childNode);
        }
        if (timestamp == Long.MIN_VALUE || color == null) {
            throw new IllegalArgumentException("Incomplete VRULE settings");
        }
        this.rrdGraphDef.vrule(timestamp, color, legend);
    }

    private void resolveHRule(Node parentNode) {
        Node[] childNodes;
        this.validateTagsOnlyOnce(parentNode, new String[]{"value", COLOR, LEGEND});
        double value = Double.NaN;
        Paint color = null;
        String legend = null;
        for (Node childNode : childNodes = RrdGraphDefTemplate.getChildNodes(parentNode)) {
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("value")) {
                value = this.getValueAsDouble(childNode);
                continue;
            }
            if (nodeName.equals(COLOR)) {
                color = this.getValueAsColor(childNode);
                continue;
            }
            if (!nodeName.equals(LEGEND)) continue;
            legend = this.getValue(childNode);
        }
        if (Double.isNaN(value) || color == null) {
            throw new IllegalArgumentException("Incomplete HRULE settings");
        }
        this.rrdGraphDef.hrule(value, color, legend);
    }

    private void resolvePrint(Node parentNode, boolean isInGraph) {
        Node[] childNodes;
        this.validateTagsOnlyOnce(parentNode, new String[]{DATASOURCE, "cf", "format"});
        String datasource = null;
        String format = null;
        ConsolFun consolFun = null;
        for (Node childNode : childNodes = RrdGraphDefTemplate.getChildNodes(parentNode)) {
            String nodeName = childNode.getNodeName();
            if (nodeName.equals(DATASOURCE)) {
                datasource = this.getValue(childNode);
                continue;
            }
            if (nodeName.equals("cf")) {
                consolFun = ConsolFun.valueOf(this.getValue(childNode));
                continue;
            }
            if (!nodeName.equals("format")) continue;
            format = this.getValue(childNode);
        }
        if (datasource != null && consolFun != null && format != null) {
            if (isInGraph) {
                this.rrdGraphDef.gprint(datasource, consolFun, format);
            } else {
                this.rrdGraphDef.print(datasource, consolFun, format);
            }
        } else if (datasource != null && format != null) {
            if (isInGraph) {
                this.rrdGraphDef.gprint(datasource, format);
            } else {
                this.rrdGraphDef.print(datasource, format);
            }
        } else {
            throw new IllegalArgumentException("Incomplete " + (isInGraph ? "GRPINT" : "PRINT") + " settings");
        }
    }

    private void resolveStack(Node parentNode) {
        Node[] childNodes;
        this.validateTagsOnlyOnce(parentNode, new String[]{DATASOURCE, COLOR, LEGEND});
        String datasource = null;
        String legend = null;
        Paint color = null;
        for (Node childNode : childNodes = RrdGraphDefTemplate.getChildNodes(parentNode)) {
            String nodeName = childNode.getNodeName();
            if (nodeName.equals(DATASOURCE)) {
                datasource = this.getValue(childNode);
                continue;
            }
            if (nodeName.equals(COLOR)) {
                color = this.getValueAsColor(childNode);
                continue;
            }
            if (!nodeName.equals(LEGEND)) continue;
            legend = this.getValue(childNode);
        }
        if (datasource != null) {
            if (color != null) {
                this.rrdGraphDef.stack(datasource, color, legend);
            } else {
                this.rrdGraphDef.stack(datasource, BLIND_COLOR, legend);
            }
        } else {
            throw new IllegalArgumentException("Incomplete STACK settings");
        }
    }

    private void resolveLine(Node parentNode) {
        Node[] childNodes;
        this.validateTagsOnlyOnce(parentNode, new String[]{DATASOURCE, COLOR, LEGEND, WIDTH});
        String datasource = null;
        String legend = null;
        Paint color = null;
        float width = 1.0f;
        for (Node childNode : childNodes = RrdGraphDefTemplate.getChildNodes(parentNode)) {
            String nodeName = childNode.getNodeName();
            if (nodeName.equals(DATASOURCE)) {
                datasource = this.getValue(childNode);
                continue;
            }
            if (nodeName.equals(COLOR)) {
                color = this.getValueAsColor(childNode);
                continue;
            }
            if (nodeName.equals(LEGEND)) {
                legend = this.getValue(childNode);
                continue;
            }
            if (!nodeName.equals(WIDTH)) continue;
            width = (float)this.getValueAsDouble(childNode);
        }
        if (datasource != null) {
            if (color != null) {
                this.rrdGraphDef.line(datasource, color, legend, width);
            } else {
                this.rrdGraphDef.line(datasource, (Paint)BLIND_COLOR, legend, width);
            }
        } else {
            throw new IllegalArgumentException("Incomplete LINE settings");
        }
    }

    private void resolveArea(Node parentNode) {
        Node[] childNodes;
        this.validateTagsOnlyOnce(parentNode, new String[]{DATASOURCE, COLOR, LEGEND});
        String datasource = null;
        String legend = null;
        Paint color = null;
        for (Node childNode : childNodes = RrdGraphDefTemplate.getChildNodes(parentNode)) {
            String nodeName = childNode.getNodeName();
            if (nodeName.equals(DATASOURCE)) {
                datasource = this.getValue(childNode);
                continue;
            }
            if (nodeName.equals(COLOR)) {
                color = this.getValueAsColor(childNode);
                continue;
            }
            if (!nodeName.equals(LEGEND)) continue;
            legend = this.getValue(childNode);
        }
        if (datasource != null) {
            if (color != null) {
                this.rrdGraphDef.area(datasource, color, legend);
            } else {
                this.rrdGraphDef.area(datasource, (Paint)BLIND_COLOR, legend);
            }
        } else {
            throw new IllegalArgumentException("Incomplete AREA settings");
        }
    }

    private void resolveDatasources(Node datasourcesNode) {
        Node[] childNodes;
        this.validateTagsOnlyOnce(datasourcesNode, new String[]{"def*", "cdef*", "sdef*"});
        for (Node childNode : childNodes = RrdGraphDefTemplate.getChildNodes(datasourcesNode)) {
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("def")) {
                this.resolveDef(childNode);
                continue;
            }
            if (nodeName.equals("cdef")) {
                this.resolveCDef(childNode);
                continue;
            }
            if (!nodeName.equals("sdef")) continue;
            this.resolveSDef(childNode);
        }
    }

    private void resolveSDef(Node parentNode) {
        Node[] childNodes;
        this.validateTagsOnlyOnce(parentNode, new String[]{"name", SOURCE, "cf", "percentile"});
        String name = null;
        String source = null;
        ConsolFun consolFun = null;
        boolean ispercentile = false;
        double percentile = Double.NaN;
        for (Node childNode : childNodes = RrdGraphDefTemplate.getChildNodes(parentNode)) {
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("name")) {
                name = this.getValue(childNode);
                continue;
            }
            if (nodeName.equals(SOURCE)) {
                source = this.getValue(childNode);
                continue;
            }
            if (nodeName.equals("cf")) {
                String cfName = this.getValue(childNode);
                if ("percent".equals(cfName)) {
                    ispercentile = true;
                    continue;
                }
                consolFun = ConsolFun.valueOf(cfName);
                continue;
            }
            if (!nodeName.equals("percentile")) continue;
            percentile = this.getValueAsDouble(childNode);
        }
        if (name != null && source != null && consolFun != null) {
            this.rrdGraphDef.datasource(name, source, consolFun);
        } else if (ispercentile && !Double.isNaN(percentile)) {
            this.rrdGraphDef.percentile(name, source, percentile);
        } else {
            throw new IllegalArgumentException("Incomplete SDEF settings");
        }
    }

    private void resolveCDef(Node parentNode) {
        Node[] childNodes;
        this.validateTagsOnlyOnce(parentNode, new String[]{"name", "rpn"});
        String name = null;
        String rpn = null;
        for (Node childNode : childNodes = RrdGraphDefTemplate.getChildNodes(parentNode)) {
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("name")) {
                name = this.getValue(childNode);
                continue;
            }
            if (!nodeName.equals("rpn")) continue;
            rpn = this.getValue(childNode);
        }
        if (name == null || rpn == null) {
            throw new IllegalArgumentException("Incomplete CDEF settings");
        }
        this.rrdGraphDef.datasource(name, rpn);
    }

    private void resolveDef(Node parentNode) {
        Node[] childNodes;
        this.validateTagsOnlyOnce(parentNode, new String[]{"name", "rrd", SOURCE, "cf", "backend"});
        String name = null;
        String rrd = null;
        String source = null;
        String backend = null;
        ConsolFun consolFun = null;
        for (Node childNode : childNodes = RrdGraphDefTemplate.getChildNodes(parentNode)) {
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("name")) {
                name = this.getValue(childNode);
                continue;
            }
            if (nodeName.equals("rrd")) {
                rrd = this.getValue(childNode);
                continue;
            }
            if (nodeName.equals(SOURCE)) {
                source = this.getValue(childNode);
                continue;
            }
            if (nodeName.equals("cf")) {
                consolFun = ConsolFun.valueOf(this.getValue(childNode));
                continue;
            }
            if (!nodeName.equals("backend")) continue;
            backend = this.getValue(childNode);
        }
        if (name == null || rrd == null || source == null || consolFun == null) {
            throw new IllegalArgumentException("Incomplete DEF settings");
        }
        this.rrdGraphDef.datasource(name, rrd, source, consolFun, backend);
    }

    private void resolveFilename(Node filenameNode) {
        String filename = this.getValue(filenameNode);
        this.rrdGraphDef.setFilename(filename);
    }

    private void resolveSpan(Node spanNode) {
        this.validateTagsOnlyOnce(spanNode, new String[]{"start", "end"});
        String startStr = this.getChildValue(spanNode, "start");
        String endStr = this.getChildValue(spanNode, "end");
        long[] span = Util.getTimestamps(startStr, endStr);
        this.rrdGraphDef.setStartTime(span[0]);
        this.rrdGraphDef.setEndTime(span[1]);
    }

    private void resolveOptions(Node rootOptionNode) {
        Node[] optionNodes;
        this.validateTagsOnlyOnce(rootOptionNode, new String[]{"anti_aliasing", "use_pool", "time_grid", "value_grid", "alt_y_grid", "alt_y_mrtg", "no_minor_grid", "alt_autoscale", "alt_autoscale_max", "units_exponent", "units_length", "vertical_label", WIDTH, "height", "interlaced", "image_info", "image_format", "image_quality", "background_image", "overlay_image", "unit", "lazy", "min_value", "max_value", "rigid", "base", "logarithmic", "colors", "no_legend", "only_graph", "force_rules_legend", "title", "step", "fonts", "first_day_of_week", "signature", "timezone"});
        for (Node optionNode : optionNodes = RrdGraphDefTemplate.getChildNodes(rootOptionNode)) {
            String option = optionNode.getNodeName();
            if (option.equals("use_pool")) {
                this.rrdGraphDef.setPoolUsed(this.getValueAsBoolean(optionNode));
                continue;
            }
            if (option.equals("anti_aliasing")) {
                this.rrdGraphDef.setAntiAliasing(this.getValueAsBoolean(optionNode));
                continue;
            }
            if (option.equals("time_grid")) {
                this.resolveTimeGrid(optionNode);
                continue;
            }
            if (option.equals("value_grid")) {
                this.resolveValueGrid(optionNode);
                continue;
            }
            if (option.equals("no_minor_grid")) {
                this.rrdGraphDef.setNoMinorGrid(this.getValueAsBoolean(optionNode));
                continue;
            }
            if (option.equals("alt_y_grid")) {
                this.rrdGraphDef.setAltYGrid(this.getValueAsBoolean(optionNode));
                continue;
            }
            if (option.equals("alt_y_mrtg")) {
                this.rrdGraphDef.setAltYMrtg(this.getValueAsBoolean(optionNode));
                continue;
            }
            if (option.equals("alt_autoscale")) {
                this.rrdGraphDef.setAltAutoscale(this.getValueAsBoolean(optionNode));
                continue;
            }
            if (option.equals("alt_autoscale_max")) {
                this.rrdGraphDef.setAltAutoscaleMax(this.getValueAsBoolean(optionNode));
                continue;
            }
            if (option.equals("units_exponent")) {
                this.rrdGraphDef.setUnitsExponent(this.getValueAsInt(optionNode));
                continue;
            }
            if (option.equals("units_length")) {
                this.rrdGraphDef.setUnitsLength(this.getValueAsInt(optionNode));
                continue;
            }
            if (option.equals("vertical_label")) {
                this.rrdGraphDef.setVerticalLabel(this.getValue(optionNode));
                continue;
            }
            if (option.equals(WIDTH)) {
                this.rrdGraphDef.setWidth(this.getValueAsInt(optionNode));
                continue;
            }
            if (option.equals("height")) {
                this.rrdGraphDef.setHeight(this.getValueAsInt(optionNode));
                continue;
            }
            if (option.equals("interlaced")) {
                this.rrdGraphDef.setInterlaced(this.getValueAsBoolean(optionNode));
                continue;
            }
            if (option.equals("image_info")) {
                this.rrdGraphDef.setImageInfo(this.getValue(optionNode));
                continue;
            }
            if (option.equals("image_format")) {
                this.rrdGraphDef.setImageFormat(this.getValue(optionNode));
                continue;
            }
            if (option.equals("image_quality")) {
                this.rrdGraphDef.setImageQuality((float)this.getValueAsDouble(optionNode));
                continue;
            }
            if (option.equals("background_image")) {
                this.rrdGraphDef.setBackgroundImage(this.getValue(optionNode));
                continue;
            }
            if (option.equals("overlay_image")) {
                this.rrdGraphDef.setOverlayImage(this.getValue(optionNode));
                continue;
            }
            if (option.equals("unit")) {
                this.rrdGraphDef.setUnit(this.getValue(optionNode));
                continue;
            }
            if (option.equals("lazy")) {
                this.rrdGraphDef.setLazy(this.getValueAsBoolean(optionNode));
                continue;
            }
            if (option.equals("min_value")) {
                this.rrdGraphDef.setMinValue(this.getValueAsDouble(optionNode));
                continue;
            }
            if (option.equals("max_value")) {
                this.rrdGraphDef.setMaxValue(this.getValueAsDouble(optionNode));
                continue;
            }
            if (option.equals("rigid")) {
                this.rrdGraphDef.setRigid(this.getValueAsBoolean(optionNode));
                continue;
            }
            if (option.equals("base")) {
                this.rrdGraphDef.setBase(this.getValueAsDouble(optionNode));
                continue;
            }
            if (option.equals("logarithmic")) {
                this.rrdGraphDef.setLogarithmic(this.getValueAsBoolean(optionNode));
                continue;
            }
            if (option.equals("colors")) {
                this.resolveColors(optionNode);
                continue;
            }
            if (option.equals("no_legend")) {
                this.rrdGraphDef.setNoLegend(this.getValueAsBoolean(optionNode));
                continue;
            }
            if (option.equals("only_graph")) {
                this.rrdGraphDef.setOnlyGraph(this.getValueAsBoolean(optionNode));
                continue;
            }
            if (option.equals("force_rules_legend")) {
                this.rrdGraphDef.setForceRulesLegend(this.getValueAsBoolean(optionNode));
                continue;
            }
            if (option.equals("title")) {
                this.rrdGraphDef.setTitle(this.getValue(optionNode));
                continue;
            }
            if (option.equals("step")) {
                this.rrdGraphDef.setStep(this.getValueAsLong(optionNode));
                continue;
            }
            if (option.equals("fonts")) {
                this.resolveFonts(optionNode);
                continue;
            }
            if (option.equals("first_day_of_week")) {
                int dayIndex = RrdGraphDefTemplate.resolveFirstDayOfWeek(this.getValue(optionNode));
                this.rrdGraphDef.setFirstDayOfWeek(dayIndex);
                continue;
            }
            if (option.equals("signature")) {
                this.rrdGraphDef.setShowSignature(this.getValueAsBoolean(optionNode));
                continue;
            }
            if (!option.equals("timezone")) continue;
            this.rrdGraphDef.setTimeZone(TimeZone.getTimeZone(this.getValue(optionNode)));
        }
    }

    private static int resolveFirstDayOfWeek(String firstDayOfWeek) {
        if (firstDayOfWeek.equalsIgnoreCase("sunday")) {
            return 1;
        }
        if (firstDayOfWeek.equalsIgnoreCase("monday")) {
            return 2;
        }
        if (firstDayOfWeek.equalsIgnoreCase("tuesday")) {
            return 3;
        }
        if (firstDayOfWeek.equalsIgnoreCase("wednesday")) {
            return 4;
        }
        if (firstDayOfWeek.equalsIgnoreCase("thursday")) {
            return 5;
        }
        if (firstDayOfWeek.equalsIgnoreCase("friday")) {
            return 6;
        }
        if (firstDayOfWeek.equalsIgnoreCase("saturday")) {
            return 7;
        }
        throw new IllegalArgumentException("Never heard for this day of week: " + firstDayOfWeek);
    }

    private void resolveFonts(Node parentNode) {
        Node[] childNodes;
        this.validateTagsOnlyOnce(parentNode, new String[]{"small_font", "large_font"});
        for (Node childNode : childNodes = RrdGraphDefTemplate.getChildNodes(parentNode)) {
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("small_font")) {
                this.rrdGraphDef.setFont(RrdGraphConstants.FontTag.DEFAULT, this.resolveFont(childNode));
                continue;
            }
            if (!nodeName.equals("large_font")) continue;
            this.rrdGraphDef.setFont(RrdGraphConstants.FontTag.TITLE, this.resolveFont(childNode));
        }
    }

    private Font resolveFont(Node parentNode) {
        Node[] childNodes;
        this.validateTagsOnlyOnce(parentNode, new String[]{"name", "style", "size"});
        String name = null;
        String style = null;
        int size = 0;
        for (Node childNode : childNodes = RrdGraphDefTemplate.getChildNodes(parentNode)) {
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("name")) {
                name = this.getValue(childNode);
                continue;
            }
            if (nodeName.equals("style")) {
                style = this.getValue(childNode).toLowerCase();
                continue;
            }
            if (!nodeName.equals("size")) continue;
            size = this.getValueAsInt(childNode);
        }
        if (name != null && style != null && size > 0) {
            boolean isItalic = style.contains("italic");
            boolean isBold = style.contains("bold");
            int fstyle = 0;
            if (isItalic && isBold) {
                fstyle = 3;
            } else if (isItalic) {
                fstyle = 2;
            } else if (isBold) {
                fstyle = 1;
            }
            return new Font(name, fstyle, size);
        }
        throw new IllegalArgumentException("Incomplete font specification");
    }

    private void resolveColors(Node parentNode) {
        Node[] childNodes;
        String[] copy = new String[COLOR_NAMES.length];
        System.arraycopy(COLOR_NAMES, 0, copy, 0, COLOR_NAMES.length);
        this.validateTagsOnlyOnce(parentNode, copy);
        for (Node childNode : childNodes = RrdGraphDefTemplate.getChildNodes(parentNode)) {
            String colorName = childNode.getNodeName();
            this.rrdGraphDef.setColor(colorName, this.getValueAsColor(childNode));
        }
    }

    private void resolveValueGrid(Node parentNode) {
        Node[] childNodes;
        int NOT_SET;
        this.validateTagsOnlyOnce(parentNode, new String[]{SHOW_GRID, "grid_step", "label_factor"});
        boolean showGrid = true;
        double gridStep = Double.NaN;
        int labelFactor = NOT_SET = Integer.MIN_VALUE;
        for (Node childNode : childNodes = RrdGraphDefTemplate.getChildNodes(parentNode)) {
            String nodeName = childNode.getNodeName();
            if (nodeName.equals(SHOW_GRID)) {
                showGrid = this.getValueAsBoolean(childNode);
                continue;
            }
            if (nodeName.equals("grid_step")) {
                gridStep = this.getValueAsDouble(childNode);
                continue;
            }
            if (!nodeName.equals("label_factor")) continue;
            labelFactor = this.getValueAsInt(childNode);
        }
        this.rrdGraphDef.setDrawYGrid(showGrid);
        if (!Double.isNaN(gridStep) && labelFactor != NOT_SET) {
            this.rrdGraphDef.setValueAxis(gridStep, labelFactor);
        } else if (!Double.isNaN(gridStep) || labelFactor != NOT_SET) {
            throw new IllegalArgumentException("Incomplete value axis settings");
        }
    }

    private void resolveTimeGrid(Node parentNode) {
        Node[] childNodes;
        this.validateTagsOnlyOnce(parentNode, new String[]{SHOW_GRID, "minor_grid_unit", "minor_grid_unit_count", "major_grid_unit", "major_grid_unit_count", "label_unit", "label_unit_count", "label_span", "label_format"});
        boolean showGrid = true;
        int NOT_SET = Integer.MIN_VALUE;
        int minorGridUnit = Integer.MIN_VALUE;
        int minorGridUnitCount = Integer.MIN_VALUE;
        int majorGridUnit = Integer.MIN_VALUE;
        int majorGridUnitCount = Integer.MIN_VALUE;
        int labelUnit = Integer.MIN_VALUE;
        int labelUnitCount = Integer.MIN_VALUE;
        int labelSpan = Integer.MIN_VALUE;
        String labelFormat = null;
        for (Node childNode : childNodes = RrdGraphDefTemplate.getChildNodes(parentNode)) {
            String nodeName = childNode.getNodeName();
            if (nodeName.equals(SHOW_GRID)) {
                showGrid = this.getValueAsBoolean(childNode);
                continue;
            }
            if (nodeName.equals("minor_grid_unit")) {
                minorGridUnit = RrdGraphDefTemplate.resolveTimeUnit(this.getValue(childNode));
                continue;
            }
            if (nodeName.equals("minor_grid_unit_count")) {
                minorGridUnitCount = this.getValueAsInt(childNode);
                continue;
            }
            if (nodeName.equals("major_grid_unit")) {
                majorGridUnit = RrdGraphDefTemplate.resolveTimeUnit(this.getValue(childNode));
                continue;
            }
            if (nodeName.equals("major_grid_unit_count")) {
                majorGridUnitCount = this.getValueAsInt(childNode);
                continue;
            }
            if (nodeName.equals("label_unit")) {
                labelUnit = RrdGraphDefTemplate.resolveTimeUnit(this.getValue(childNode));
                continue;
            }
            if (nodeName.equals("label_unit_count")) {
                labelUnitCount = this.getValueAsInt(childNode);
                continue;
            }
            if (nodeName.equals("label_span")) {
                labelSpan = this.getValueAsInt(childNode);
                continue;
            }
            if (!nodeName.equals("label_format")) continue;
            labelFormat = this.getValue(childNode);
        }
        this.rrdGraphDef.setDrawXGrid(showGrid);
        if (minorGridUnit != Integer.MIN_VALUE && minorGridUnitCount != Integer.MIN_VALUE && majorGridUnit != Integer.MIN_VALUE && majorGridUnitCount != Integer.MIN_VALUE && labelUnit != Integer.MIN_VALUE && labelUnitCount != Integer.MIN_VALUE && labelSpan != Integer.MIN_VALUE && labelFormat != null) {
            this.rrdGraphDef.setTimeAxis(minorGridUnit, minorGridUnitCount, majorGridUnit, majorGridUnitCount, labelUnit, labelUnitCount, labelSpan, labelFormat);
        } else if (minorGridUnit != Integer.MIN_VALUE || minorGridUnitCount != Integer.MIN_VALUE || majorGridUnit != Integer.MIN_VALUE || majorGridUnitCount != Integer.MIN_VALUE || labelUnit != Integer.MIN_VALUE || labelUnitCount != Integer.MIN_VALUE || labelSpan != Integer.MIN_VALUE || labelFormat != null) {
            throw new IllegalArgumentException("Incomplete time axis settings");
        }
    }

    private static int resolveTimeUnit(String unit) {
        if (unit.equalsIgnoreCase("second")) {
            return 13;
        }
        if (unit.equalsIgnoreCase("minute")) {
            return 12;
        }
        if (unit.equalsIgnoreCase("hour")) {
            return 11;
        }
        if (unit.equalsIgnoreCase("day")) {
            return 5;
        }
        if (unit.equalsIgnoreCase("week")) {
            return 3;
        }
        if (unit.equalsIgnoreCase("month")) {
            return 2;
        }
        if (unit.equalsIgnoreCase("year")) {
            return 1;
        }
        throw new IllegalArgumentException("Unknown time unit specified: " + unit);
    }
}

