/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.common;

import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jwat.common.ByteCountingPushBackInputStream;
import org.jwat.common.Diagnostics;
import org.jwat.common.HeaderLine;
import org.jwat.common.HeaderLineReader;
import org.jwat.common.MaxLengthRecordingInputStream;
import org.jwat.common.PayloadWithHeaderAbstract;

public class HttpHeader
extends PayloadWithHeaderAbstract {
    public static final int HT_RESPONSE = 1;
    public static final int HT_REQUEST = 2;
    public static final String PROTOCOL_HTTP = "http";
    public static final String PROTOCOL_HTTPS = "https";
    protected static final String HTTP_VERSION_SUFFIX = "HTTP/";
    protected static final String CONTENT_TYPE = "Content-Type".toUpperCase();
    public int headerType;
    public String method;
    public String requestUri;
    public String httpVersion;
    public Integer httpVersionMajor;
    public Integer httpVersionMinor;
    public String statusCodeStr;
    public Integer statusCode;
    public String reasonPhrase;
    protected List<HeaderLine> headerList = new LinkedList<HeaderLine>();
    protected Map<String, HeaderLine> headerMap = new HashMap<String, HeaderLine>();
    public String contentType;

    protected HttpHeader() {
    }

    public static boolean isSupported(String protocol) {
        return PROTOCOL_HTTP.equalsIgnoreCase(protocol) || PROTOCOL_HTTPS.equalsIgnoreCase(protocol);
    }

    public static HttpHeader processPayload(int headerType, ByteCountingPushBackInputStream pbin, long length, String digestAlgorithm) throws IOException {
        if (headerType != 1 && headerType != 2) {
            throw new IllegalArgumentException("Invalid 'headerType' argument: " + headerType);
        }
        if (pbin == null) {
            throw new IllegalArgumentException("The inputstream 'pbin' is null");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("The 'length' is less than zero: " + length);
        }
        HttpHeader hh = new HttpHeader();
        hh.headerType = headerType;
        hh.in_pb = pbin;
        hh.totalLength = length;
        hh.digestAlgorithm = digestAlgorithm;
        hh.diagnostics = new Diagnostics();
        hh.initProcess();
        return hh;
    }

    @Override
    protected boolean readHeader(MaxLengthRecordingInputStream in, long payloadLength) throws IOException {
        PushbackInputStream pbin = new PushbackInputStream(in, this.in_pb.getPushbackSize());
        HeaderLineReader hlr = HeaderLineReader.getHeaderLineReader();
        hlr.bNameValue = false;
        hlr.encoding = 2;
        hlr.bLWS = false;
        hlr.bQuotedText = false;
        hlr.bEncodedWords = false;
        boolean bValidHttpHeader = false;
        HeaderLine line = hlr.readLine(pbin);
        int bfErrors = 0;
        if (!hlr.bEof && line.type == 1 && line.line != null && line.line.length() > 0) {
            bfErrors = line.bfErrors & 0xFFFFFF7F;
            if (this.headerType == 1) {
                bValidHttpHeader = this.isHttpStatusLineValid(line.line);
            } else if (this.headerType == 2) {
                bValidHttpHeader = this.isHttpRequestLineValid(line.line);
            } else {
                throw new IllegalStateException("Invalid headerType!");
            }
        }
        hlr.bNameValue = true;
        hlr.bLWS = true;
        hlr.bQuotedText = true;
        hlr.bEncodedWords = true;
        boolean bLoop = bValidHttpHeader;
        while (bLoop) {
            line = hlr.readLine(pbin);
            bfErrors |= line.bfErrors;
            if (!hlr.bEof) {
                switch (line.type) {
                    case 2: {
                        HeaderLine tmpLine;
                        if (CONTENT_TYPE.equals(line.name.toUpperCase())) {
                            this.contentType = line.value;
                        }
                        if ((tmpLine = this.headerMap.get(line.name.toLowerCase())) == null) {
                            this.headerMap.put(line.name.toLowerCase(), line);
                        } else {
                            tmpLine.lines.add(line);
                        }
                        this.headerList.add(line);
                        break;
                    }
                    case 1: {
                        if (line.line.length() != 0) break;
                        bLoop = false;
                    }
                }
                continue;
            }
            if ((bfErrors & 1) == 0 || (long)in.record.size() != payloadLength) {
                bValidHttpHeader = false;
            }
            bLoop = false;
        }
        HeaderLineReader.report_error(bfErrors, this.diagnostics);
        if (bValidHttpHeader) {
            this.payloadLength = payloadLength - (long)in.record.size();
        }
        return bValidHttpHeader;
    }

    protected boolean isHttpStatusLineValid(String statusLine) {
        boolean bIsHttpStatusLineValid;
        boolean bl = bIsHttpStatusLineValid = statusLine != null && statusLine.length() > 0;
        if (bIsHttpStatusLineValid) {
            int idx = statusLine.indexOf(32);
            if (idx > 0) {
                bIsHttpStatusLineValid = this.isHttpVersionValid(statusLine.substring(0, idx));
            } else {
                if (idx == -1) {
                    this.httpVersion = statusLine;
                }
                bIsHttpStatusLineValid = false;
            }
            if (bIsHttpStatusLineValid) {
                int prevIdx = ++idx;
                if ((idx = statusLine.indexOf(32, idx)) == -1) {
                    idx = statusLine.length();
                }
                if (idx > prevIdx) {
                    this.statusCodeStr = statusLine.substring(prevIdx, idx);
                    try {
                        this.statusCode = Integer.parseInt(this.statusCodeStr);
                        if (this.statusCode < 100 || this.statusCode > 999) {
                            bIsHttpStatusLineValid = false;
                        }
                    }
                    catch (NumberFormatException e) {
                        bIsHttpStatusLineValid = false;
                    }
                } else {
                    bIsHttpStatusLineValid = false;
                }
                if (bIsHttpStatusLineValid && idx < statusLine.length()) {
                    this.reasonPhrase = statusLine.substring(++idx);
                }
            }
        }
        return bIsHttpStatusLineValid;
    }

    protected boolean isHttpVersionValid(String versionString) {
        this.httpVersion = versionString;
        boolean bIsHttpVersionValid = versionString.startsWith(HTTP_VERSION_SUFFIX);
        if (bIsHttpVersionValid) {
            int idx = versionString.indexOf(46, HTTP_VERSION_SUFFIX.length());
            if (idx > 0) {
                try {
                    this.httpVersionMajor = Integer.parseInt(versionString.substring(HTTP_VERSION_SUFFIX.length(), idx));
                    if (this.httpVersionMajor < 0) {
                        bIsHttpVersionValid = false;
                    }
                }
                catch (NumberFormatException e) {
                    bIsHttpVersionValid = false;
                }
                try {
                    this.httpVersionMinor = Integer.parseInt(versionString.substring(idx + 1));
                    if (this.httpVersionMinor < 0) {
                        bIsHttpVersionValid = false;
                    }
                }
                catch (NumberFormatException e) {
                    bIsHttpVersionValid = false;
                }
            } else {
                bIsHttpVersionValid = false;
            }
        } else if (versionString.equals("HTTP")) {
            this.httpVersionMajor = 1;
            this.httpVersionMinor = 0;
            bIsHttpVersionValid = true;
        }
        return bIsHttpVersionValid;
    }

    protected boolean isHttpRequestLineValid(String requestLine) {
        boolean bIsHttpRequestLineValid;
        boolean bl = bIsHttpRequestLineValid = requestLine != null && requestLine.length() > 0;
        if (bIsHttpRequestLineValid) {
            int idx = requestLine.indexOf(32);
            if (idx > 0) {
                this.method = requestLine.substring(0, idx);
            } else {
                if (idx == -1) {
                    this.method = requestLine;
                }
                bIsHttpRequestLineValid = false;
            }
            if (bIsHttpRequestLineValid) {
                int prevIdx = ++idx;
                if ((idx = requestLine.indexOf(32, idx)) > prevIdx) {
                    this.requestUri = requestLine.substring(prevIdx, idx);
                } else {
                    if (idx == -1) {
                        this.requestUri = requestLine.substring(prevIdx);
                    }
                    bIsHttpRequestLineValid = false;
                }
                if (bIsHttpRequestLineValid) {
                    bIsHttpRequestLineValid = this.isHttpVersionValid(requestLine.substring(++idx));
                }
            }
        }
        return bIsHttpRequestLineValid;
    }

    @Override
    public List<HeaderLine> getHeaderList() {
        return Collections.unmodifiableList(this.headerList);
    }

    @Override
    public HeaderLine getHeader(String field) {
        if (field != null && field.length() > 0) {
            return this.headerMap.get(field.toLowerCase());
        }
        return null;
    }

    public String getProtocolStatusCodeStr() {
        return this.statusCodeStr;
    }

    public Integer getProtocolStatusCode() {
        return this.statusCode;
    }

    public String getProtocolVersion() {
        return this.httpVersion;
    }

    public String getProtocolContentType() {
        return this.contentType;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(256);
        builder.append("\nHttpHeader : [\n");
        if (this.statusCode != null) {
            builder.append(", HttpResultCode: ").append(this.statusCode);
        }
        if (this.httpVersion != null) {
            builder.append(", HttpProtocolVersion: ").append(this.httpVersion);
        }
        if (this.contentType != null) {
            builder.append(", HttpContentType: ").append(this.contentType);
        }
        builder.append("]\n");
        return builder.toString();
    }
}

