/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import org.jwat.common.ByteArrayOutputStreamWithUnread;
import org.jwat.common.Diagnosis;
import org.jwat.common.DiagnosisType;
import org.jwat.common.Diagnostics;
import org.jwat.common.HeaderLine;
import org.jwat.common.UTF8;

public class HeaderLineReader {
    protected static final int S_LINE = 0;
    protected static final int S_NAME = 1;
    protected static final int S_VALUE = 2;
    protected static final int S_LWS = 3;
    protected static final int S_QUOTED_TEXT = 4;
    protected static final int S_QUOTED_PAIR = 5;
    protected static final int S_QUOTED_LWS = 6;
    protected static final int CC_CONTROL = 1;
    protected static final int CC_SEPARATOR_WS = 2;
    public static final String separatorsWs = "()<>@,;:\\\"/[]?={} \t";
    public static final byte[] charCharacteristicsTab;
    public static final int ENC_RAW = 0;
    public static final int ENC_US_ASCII = 1;
    public static final int ENC_ISO8859_1 = 2;
    public static final int ENC_UTF8 = 3;
    protected final UTF8 utf8 = new UTF8();
    public static final int EOL_LF = 0;
    public static final int EOL_CRLF = 1;
    public boolean bNameValue;
    public int encoding = 0;
    public int eol = 1;
    public boolean bLWS;
    public boolean bQuotedText;
    public boolean bEncodedWords;
    protected final StringBuffer lineSb = new StringBuffer();
    protected final StringBuffer nvSb = new StringBuffer();
    protected ByteArrayOutputStreamWithUnread bytesOut = new ByteArrayOutputStreamWithUnread();
    public static final int E_BIT_EOF = 1;
    public static final int E_BIT_MISPLACED_CR = 2;
    public static final int E_BIT_MISSING_CR = 4;
    public static final int E_BIT_UNEXPECTED_CR = 8;
    public static final int E_BIT_INVALID_UTF8_ENCODING = 16;
    public static final int E_BIT_INVALID_US_ASCII_CHAR = 32;
    public static final int E_BIT_INVALID_CONTROL_CHAR = 64;
    public static final int E_BIT_INVALID_SEPARATOR_CHAR = 128;
    public static final int E_BIT_MISSING_QUOTE = 256;
    public static final int E_BIT_MISSING_QUOTED_PAIR_CHAR = 512;
    public static final int E_BIT_INVALID_QUOTED_PAIR_CHAR = 1024;
    public static final int E_BIT_INVALID_CHARSET = 2048;
    protected boolean bCr = false;
    protected boolean bValidChar;
    public boolean bEof;
    public int bfErrors;

    protected HeaderLineReader() {
    }

    public static HeaderLineReader getReader() {
        return new HeaderLineReader();
    }

    public static HeaderLineReader getLineReader() {
        HeaderLineReader hlr = new HeaderLineReader();
        hlr.bNameValue = false;
        hlr.encoding = 1;
        return hlr;
    }

    public static HeaderLineReader getHeaderLineReader() {
        HeaderLineReader hlr = new HeaderLineReader();
        hlr.bNameValue = true;
        hlr.encoding = 2;
        hlr.eol = 1;
        hlr.bLWS = true;
        hlr.bQuotedText = true;
        hlr.bEncodedWords = true;
        return hlr;
    }

    public HeaderLine readLine(PushbackInputStream in) throws IOException {
        HeaderLine headerLine = new HeaderLine();
        int state = !this.bNameValue ? 0 : 1;
        this.lineSb.setLength(0);
        this.nvSb.setLength(0);
        this.bytesOut = new ByteArrayOutputStreamWithUnread();
        this.bfErrors = 0;
        this.bCr = false;
        boolean bLoop = true;
        while (bLoop) {
            int c = in.read();
            if (c != -1) {
                this.bytesOut.write(c);
            }
            block0 : switch (state) {
                case 0: {
                    switch (c) {
                        case -1: {
                            this.bfErrors |= 1;
                            headerLine.type = 1;
                            headerLine.line = this.lineSb.toString();
                            this.lineSb.setLength(0);
                            bLoop = false;
                            break block0;
                        }
                        case 13: {
                            this.bCr = true;
                            break block0;
                        }
                        case 10: {
                            headerLine.type = 1;
                            headerLine.line = this.lineSb.toString();
                            this.lineSb.setLength(0);
                            this.check_eol();
                            bLoop = false;
                            break block0;
                        }
                    }
                    if (this.bCr) {
                        this.bfErrors |= 2;
                        this.bCr = false;
                    }
                    if ((c = this.decode(c, in)) == -1) {
                        this.bfErrors |= 1;
                        headerLine.type = 1;
                        headerLine.line = this.lineSb.toString();
                        this.lineSb.setLength(0);
                        bLoop = false;
                        break;
                    }
                    if (this.bValidChar && this.encoding != 0 && c < 256 && (charCharacteristicsTab[c] & 1) == 1) {
                        this.bValidChar = false;
                        this.bfErrors |= 0x40;
                    }
                    if (!this.bValidChar) break;
                    this.lineSb.append((char)c);
                    break;
                }
                case 1: {
                    switch (c) {
                        case -1: {
                            this.bfErrors |= 1;
                            headerLine.type = 1;
                            headerLine.line = this.lineSb.toString();
                            this.lineSb.setLength(0);
                            this.nvSb.setLength(0);
                            bLoop = false;
                            break block0;
                        }
                        case 13: {
                            this.bCr = true;
                            break block0;
                        }
                        case 10: {
                            headerLine.type = 1;
                            headerLine.line = this.lineSb.toString();
                            this.lineSb.setLength(0);
                            this.nvSb.setLength(0);
                            this.check_eol();
                            bLoop = false;
                            break block0;
                        }
                        case 58: {
                            headerLine.type = (byte)2;
                            headerLine.name = this.nvSb.toString();
                            this.lineSb.setLength(0);
                            this.nvSb.setLength(0);
                            if (this.bCr) {
                                this.bfErrors |= 2;
                                this.bCr = false;
                            }
                            state = 2;
                            break block0;
                        }
                    }
                    if (this.bCr) {
                        this.bfErrors |= 2;
                        this.bCr = false;
                    }
                    if ((c = this.decode(c, in)) == -1) {
                        this.bfErrors |= 1;
                        headerLine.type = 1;
                        headerLine.line = this.lineSb.toString();
                        this.lineSb.setLength(0);
                        this.nvSb.setLength(0);
                        bLoop = false;
                        break;
                    }
                    if (this.bValidChar && this.encoding != 0 && c < 256 && (charCharacteristicsTab[c] & 1) == 1) {
                        this.bValidChar = false;
                        this.bfErrors |= 0x40;
                    }
                    if (this.bValidChar) {
                        this.lineSb.append((char)c);
                        if (c < 256 && (charCharacteristicsTab[c] & 2) == 2) {
                            this.bValidChar = false;
                            this.bfErrors |= 0x80;
                        }
                    }
                    if (!this.bValidChar) break;
                    this.nvSb.append((char)c);
                    break;
                }
                case 2: {
                    switch (c) {
                        case -1: {
                            this.bfErrors |= 1;
                            headerLine.value = HeaderLineReader.trim(this.nvSb);
                            this.nvSb.setLength(0);
                            bLoop = false;
                            break block0;
                        }
                        case 13: {
                            this.bCr = true;
                            break block0;
                        }
                        case 10: {
                            this.check_eol();
                            if (this.bLWS) {
                                state = 3;
                                break block0;
                            }
                            headerLine.value = HeaderLineReader.trim(this.nvSb);
                            this.nvSb.setLength(0);
                            bLoop = false;
                            break block0;
                        }
                    }
                    if (this.bCr) {
                        this.bfErrors |= 2;
                        this.bCr = false;
                    }
                    if ((c = this.decode(c, in)) == -1) {
                        this.bfErrors |= 1;
                        headerLine.value = HeaderLineReader.trim(this.nvSb);
                        this.nvSb.setLength(0);
                        bLoop = false;
                        break;
                    }
                    if (this.bValidChar && this.encoding != 0 && c < 256 && (charCharacteristicsTab[c] & 1) == 1) {
                        this.bValidChar = false;
                        this.bfErrors |= 0x40;
                    }
                    if (!this.bValidChar) break;
                    switch (c) {
                        case 34: {
                            this.nvSb.append((char)c);
                            if (!this.bQuotedText) break block0;
                            state = 4;
                            break block0;
                        }
                    }
                    this.nvSb.append((char)c);
                    break;
                }
                case 3: {
                    switch (c) {
                        case -1: {
                            headerLine.value = HeaderLineReader.trim(this.nvSb);
                            this.nvSb.setLength(0);
                            bLoop = false;
                            break block0;
                        }
                        case 9: 
                        case 32: {
                            this.nvSb.append(" ");
                            state = 2;
                            break block0;
                        }
                    }
                    in.unread(c);
                    this.bytesOut.unread(c);
                    headerLine.value = HeaderLineReader.trim(this.nvSb);
                    this.nvSb.setLength(0);
                    bLoop = false;
                    break;
                }
                case 4: {
                    switch (c) {
                        case -1: {
                            this.bfErrors |= 0x101;
                            headerLine.value = HeaderLineReader.trim(this.nvSb);
                            this.nvSb.setLength(0);
                            bLoop = false;
                            break block0;
                        }
                        case 34: {
                            if (this.bCr) {
                                this.bfErrors |= 2;
                                this.bCr = false;
                            }
                            this.nvSb.append((char)c);
                            state = 2;
                            break block0;
                        }
                        case 92: {
                            if (this.bCr) {
                                this.bfErrors |= 2;
                                this.bCr = false;
                            }
                            state = 5;
                            break block0;
                        }
                        case 13: {
                            this.bCr = true;
                            break block0;
                        }
                        case 10: {
                            this.check_eol();
                            if (this.bLWS) {
                                state = 6;
                                break block0;
                            }
                            headerLine.value = HeaderLineReader.trim(this.nvSb);
                            this.nvSb.setLength(0);
                            bLoop = false;
                            break block0;
                        }
                    }
                    if (this.bCr) {
                        this.bfErrors |= 2;
                        this.bCr = false;
                    }
                    if ((c = this.decode(c, in)) == -1) {
                        this.bfErrors |= 0x101;
                        headerLine.value = HeaderLineReader.trim(this.nvSb);
                        this.nvSb.setLength(0);
                        bLoop = false;
                        break;
                    }
                    if (this.bValidChar && this.encoding != 0 && c < 256 && (charCharacteristicsTab[c] & 1) == 1) {
                        this.bValidChar = false;
                        this.bfErrors |= 0x40;
                    }
                    if (!this.bValidChar) break;
                    this.nvSb.append((char)c);
                    break;
                }
                case 5: {
                    switch (c) {
                        case -1: {
                            this.nvSb.append('\\');
                            this.bfErrors |= 0x301;
                            headerLine.value = HeaderLineReader.trim(this.nvSb);
                            this.nvSb.setLength(0);
                            bLoop = false;
                            break block0;
                        }
                    }
                    c = this.decode(c, in);
                    if (c == -1) {
                        this.bfErrors |= 0x301;
                        headerLine.value = HeaderLineReader.trim(this.nvSb);
                        this.nvSb.setLength(0);
                        bLoop = false;
                        break;
                    }
                    this.nvSb.append('\\');
                    this.nvSb.append((char)c);
                    if (!this.bValidChar) {
                        this.bfErrors |= 0x400;
                    }
                    state = 4;
                    break;
                }
                case 6: {
                    switch (c) {
                        case -1: {
                            this.bfErrors |= 0x100;
                            headerLine.value = HeaderLineReader.trim(this.nvSb);
                            this.nvSb.setLength(0);
                            bLoop = false;
                            break block0;
                        }
                        case 9: 
                        case 32: {
                            this.nvSb.append(" ");
                            state = 4;
                            break block0;
                        }
                    }
                    in.unread(c);
                    this.bytesOut.unread(c);
                    this.bfErrors |= 0x100;
                    headerLine.value = HeaderLineReader.trim(this.nvSb);
                    this.nvSb.setLength(0);
                    bLoop = false;
                }
            }
        }
        headerLine.raw = this.bytesOut.toByteArray();
        headerLine.bfErrors = this.bfErrors;
        this.bEof = headerLine.raw.length == 0;
        return headerLine;
    }

    protected int decode(int c, InputStream in) throws IOException {
        switch (this.encoding) {
            case 3: {
                c = this.utf8.readUtf8(c, in);
                this.bytesOut.write(this.utf8.chars_read);
                this.bValidChar = this.utf8.bValidChar;
                if (c == -1 || this.bValidChar) break;
                this.bfErrors |= 0x10;
                break;
            }
            case 1: {
                boolean bl = this.bValidChar = c <= 127;
                if (this.bValidChar) break;
                this.bfErrors |= 0x20;
                break;
            }
            default: {
                this.bValidChar = true;
            }
        }
        return c;
    }

    protected void check_eol() {
        switch (this.eol) {
            case 0: {
                if (this.bCr) break;
                this.bfErrors |= 8;
                break;
            }
            case 1: {
                if (this.bCr) break;
                this.bfErrors |= 4;
            }
        }
        this.bCr = false;
    }

    public static String trim(StringBuffer sb) {
        int sIdx;
        int eIdx = sb.length();
        for (sIdx = 0; sIdx < eIdx && sb.charAt(sIdx) == ' '; ++sIdx) {
        }
        while (eIdx > sIdx && sb.charAt(eIdx - 1) == ' ') {
            --eIdx;
        }
        return sb.substring(sIdx, eIdx);
    }

    public static void report_error(int bfErrors, Diagnostics<Diagnosis> diagnostics) {
        if (diagnostics == null) {
            throw new IllegalArgumentException("'diagnostics' argument is null");
        }
        if ((bfErrors & 1) != 0) {
            diagnostics.addError(new Diagnosis(DiagnosisType.ERROR, "header/line", "Unexpected EOF"));
        }
        if ((bfErrors & 2) != 0) {
            diagnostics.addError(new Diagnosis(DiagnosisType.ERROR, "header/line", "Misplaced CR"));
        }
        if ((bfErrors & 4) != 0) {
            diagnostics.addError(new Diagnosis(DiagnosisType.ERROR, "header/line", "Missing CR"));
        }
        if ((bfErrors & 8) != 0) {
            diagnostics.addError(new Diagnosis(DiagnosisType.ERROR, "header/line", "Unexpected CR"));
        }
        if ((bfErrors & 0x10) != 0) {
            diagnostics.addError(new Diagnosis(DiagnosisType.ERROR, "header/line", "Invalid UTF-8 encoded character"));
        }
        if ((bfErrors & 0x20) != 0) {
            diagnostics.addError(new Diagnosis(DiagnosisType.ERROR, "header/line", "Invalid US-ASCII character"));
        }
        if ((bfErrors & 0x40) != 0) {
            diagnostics.addError(new Diagnosis(DiagnosisType.ERROR, "header/line", "Invalid control character"));
        }
        if ((bfErrors & 0x80) != 0) {
            diagnostics.addError(new Diagnosis(DiagnosisType.ERROR, "header/line", "Invalid separator character"));
        }
        if ((bfErrors & 0x100) != 0) {
            diagnostics.addError(new Diagnosis(DiagnosisType.ERROR, "header/line", "Missing quote character"));
        }
        if ((bfErrors & 0x200) != 0) {
            diagnostics.addError(new Diagnosis(DiagnosisType.ERROR, "header/line", "Missing quoted pair character"));
        }
        if ((bfErrors & 0x400) != 0) {
            diagnostics.addError(new Diagnosis(DiagnosisType.ERROR, "header/line", "Invalid quoted pair character"));
        }
        if ((bfErrors & 0x800) != 0) {
            diagnostics.addError(new Diagnosis(DiagnosisType.ERROR, "header/line", "Invalid charset"));
        }
    }

    static {
        int i;
        charCharacteristicsTab = new byte[256];
        for (i = 0; i < 32; ++i) {
            if (i == 9) continue;
            int n = i;
            charCharacteristicsTab[n] = (byte)(charCharacteristicsTab[n] | 1);
        }
        charCharacteristicsTab[127] = (byte)(charCharacteristicsTab[127] | 1);
        for (i = 0; i < separatorsWs.length(); ++i) {
            char c = separatorsWs.charAt(i);
            charCharacteristicsTab[c] = (byte)(charCharacteristicsTab[c] | 2);
        }
    }
}

