/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3.framebody;

import java.nio.ByteBuffer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import org.jaudiotagger.tag.InvalidTagException;
import org.jaudiotagger.tag.id3.framebody.AbstractFrameBodyTextInfo;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTDAT;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTIME;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTRDA;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTYER;
import org.jaudiotagger.tag.id3.framebody.ID3v24FrameBody;

public class FrameBodyTDRC
extends AbstractFrameBodyTextInfo
implements ID3v24FrameBody {
    private String originalID;
    private String year = "";
    private String time = "";
    private String date = "";
    private boolean monthOnly = false;
    private boolean hoursOnly = false;
    private static SimpleDateFormat formatYearIn;
    private static SimpleDateFormat formatYearOut;
    private static SimpleDateFormat formatDateIn;
    private static SimpleDateFormat formatDateOut;
    private static SimpleDateFormat formatMonthOut;
    private static SimpleDateFormat formatTimeIn;
    private static SimpleDateFormat formatTimeOut;
    private static SimpleDateFormat formatHoursOut;
    private static final List<SimpleDateFormat> formatters;
    private static final int PRECISION_SECOND = 0;
    private static final int PRECISION_MINUTE = 1;
    private static final int PRECISION_HOUR = 2;
    private static final int PRECISION_DAY = 3;
    private static final int PRECISION_MONTH = 4;
    private static final int PRECISION_YEAR = 5;

    public FrameBodyTDRC() {
    }

    public FrameBodyTDRC(FrameBodyTDRC body) {
        super(body);
    }

    public String getOriginalID() {
        return this.originalID;
    }

    private static synchronized String formatAndParse(SimpleDateFormat formatDate, SimpleDateFormat parseDate, String text) {
        try {
            Date date = parseDate.parse(text);
            String result = formatDate.format(date);
            return result;
        }
        catch (ParseException e) {
            logger.warning("Unable to parse:" + text);
            return "";
        }
    }

    public String getFormattedText() {
        StringBuffer sb = new StringBuffer();
        if (this.originalID == null) {
            return this.getText();
        }
        if (this.year != null && !this.year.trim().isEmpty()) {
            sb.append(FrameBodyTDRC.formatAndParse(formatYearOut, formatYearIn, this.year));
        }
        if (!this.date.equals("")) {
            if (this.isMonthOnly()) {
                sb.append(FrameBodyTDRC.formatAndParse(formatMonthOut, formatDateIn, this.date));
            } else {
                sb.append(FrameBodyTDRC.formatAndParse(formatDateOut, formatDateIn, this.date));
            }
        }
        if (!this.time.equals("")) {
            if (this.isHoursOnly()) {
                sb.append(FrameBodyTDRC.formatAndParse(formatHoursOut, formatTimeIn, this.time));
            } else {
                sb.append(FrameBodyTDRC.formatAndParse(formatTimeOut, formatTimeIn, this.time));
            }
        }
        return sb.toString();
    }

    public void setYear(String year) {
        logger.finest("Setting year to" + year);
        this.year = year;
    }

    public void setTime(String time) {
        logger.finest("Setting time to:" + time);
        this.time = time;
    }

    public void setDate(String date) {
        logger.finest("Setting date to:" + date);
        this.date = date;
    }

    public String getYear() {
        return this.year;
    }

    public String getTime() {
        return this.time;
    }

    public String getDate() {
        return this.date;
    }

    public FrameBodyTDRC(FrameBodyTYER body) {
        this.originalID = "TYER";
        this.year = body.getText();
        this.setObjectValue("TextEncoding", (byte)0);
        this.setObjectValue("Text", this.getFormattedText());
    }

    public FrameBodyTDRC(FrameBodyTIME body) {
        this.originalID = "TIME";
        this.time = body.getText();
        this.setHoursOnly(body.isHoursOnly());
        this.setObjectValue("TextEncoding", (byte)0);
        this.setObjectValue("Text", this.getFormattedText());
    }

    public FrameBodyTDRC(FrameBodyTDAT body) {
        this.originalID = "TDAT";
        this.date = body.getText();
        this.setMonthOnly(body.isMonthOnly());
        this.setObjectValue("TextEncoding", (byte)0);
        this.setObjectValue("Text", this.getFormattedText());
    }

    public FrameBodyTDRC(FrameBodyTRDA body) {
        this.originalID = "TRDA";
        this.date = body.getText();
        this.setObjectValue("TextEncoding", (byte)0);
        this.setObjectValue("Text", this.getFormattedText());
    }

    public FrameBodyTDRC(byte textEncoding, String text) {
        super(textEncoding, text);
        this.findMatchingMaskAndExtractV3Values();
    }

    public FrameBodyTDRC(ByteBuffer byteBuffer, int frameSize) throws InvalidTagException {
        super(byteBuffer, frameSize);
        this.findMatchingMaskAndExtractV3Values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findMatchingMaskAndExtractV3Values() {
        for (int i = 0; i < formatters.size(); ++i) {
            try {
                Date d;
                SimpleDateFormat simpleDateFormat = formatters.get(i);
                synchronized (simpleDateFormat) {
                    d = formatters.get(i).parse(this.getText());
                }
                if (d == null) continue;
                this.extractID3v23Formats(d, i);
                break;
            }
            catch (ParseException d) {
                continue;
            }
            catch (NumberFormatException nfe) {
                logger.log(Level.WARNING, "Date Formatter:" + formatters.get(i).toPattern() + "failed to parse:" + this.getText() + "with " + nfe.getMessage(), nfe);
            }
        }
    }

    private static synchronized String formatDateAsYear(Date d) {
        return formatYearIn.format(d);
    }

    private static synchronized String formatDateAsDate(Date d) {
        return formatDateIn.format(d);
    }

    private static synchronized String formatDateAsTime(Date d) {
        return formatTimeIn.format(d);
    }

    private void extractID3v23Formats(Date dateRecord, int precision) {
        logger.fine("Precision is:" + precision + "for date:" + dateRecord.toString());
        Date d = dateRecord;
        if (precision == 5) {
            this.setYear(FrameBodyTDRC.formatDateAsYear(d));
        } else if (precision == 4) {
            this.setYear(FrameBodyTDRC.formatDateAsYear(d));
            this.setDate(FrameBodyTDRC.formatDateAsDate(d));
            this.monthOnly = true;
        } else if (precision == 3) {
            this.setYear(FrameBodyTDRC.formatDateAsYear(d));
            this.setDate(FrameBodyTDRC.formatDateAsDate(d));
        } else if (precision == 2) {
            this.setYear(FrameBodyTDRC.formatDateAsYear(d));
            this.setDate(FrameBodyTDRC.formatDateAsDate(d));
            this.setTime(FrameBodyTDRC.formatDateAsTime(d));
            this.hoursOnly = true;
        } else if (precision == 1) {
            this.setYear(FrameBodyTDRC.formatDateAsYear(d));
            this.setDate(FrameBodyTDRC.formatDateAsDate(d));
            this.setTime(FrameBodyTDRC.formatDateAsTime(d));
        } else if (precision == 0) {
            this.setYear(FrameBodyTDRC.formatDateAsYear(d));
            this.setDate(FrameBodyTDRC.formatDateAsDate(d));
            this.setTime(FrameBodyTDRC.formatDateAsTime(d));
        }
    }

    @Override
    public String getIdentifier() {
        return "TDRC";
    }

    public boolean isMonthOnly() {
        return this.monthOnly;
    }

    public void setMonthOnly(boolean monthOnly) {
        this.monthOnly = monthOnly;
    }

    public boolean isHoursOnly() {
        return this.hoursOnly;
    }

    public void setHoursOnly(boolean hoursOnly) {
        this.hoursOnly = hoursOnly;
    }

    static {
        formatters = new ArrayList<SimpleDateFormat>();
        formatters.add(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.UK));
        formatters.add(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm", Locale.UK));
        formatters.add(new SimpleDateFormat("yyyy-MM-dd'T'HH", Locale.UK));
        formatters.add(new SimpleDateFormat("yyyy-MM-dd", Locale.UK));
        formatters.add(new SimpleDateFormat("yyyy-MM", Locale.UK));
        formatters.add(new SimpleDateFormat("yyyy", Locale.UK));
        formatYearIn = new SimpleDateFormat("yyyy", Locale.UK);
        formatDateIn = new SimpleDateFormat("ddMM", Locale.UK);
        formatTimeIn = new SimpleDateFormat("HHmm", Locale.UK);
        formatYearOut = new SimpleDateFormat("yyyy", Locale.UK);
        formatDateOut = new SimpleDateFormat("-MM-dd", Locale.UK);
        formatMonthOut = new SimpleDateFormat("-MM", Locale.UK);
        formatTimeOut = new SimpleDateFormat("'T'HH:mm", Locale.UK);
        formatHoursOut = new SimpleDateFormat("'T'HH", Locale.UK);
    }
}

