/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.wav;

import java.util.HashMap;
import java.util.Map;

public enum WavChunkType {
    FORMAT("fmt ", "Basic Audio Information"),
    FACT("fact", "Only strictly required for Non-PCM or compressed data"),
    DATA("data", "Stores the actual audio data"),
    LIST("LIST", "List chunk, wraps round other chunks"),
    INFO("INFO", "Original metadata implementation"),
    ID3("id3 ", "Stores metadata in ID3 chunk");

    private static final Map<String, WavChunkType> CODE_TYPE_MAP;
    private String code;
    private String description;

    public static synchronized WavChunkType get(String code) {
        if (CODE_TYPE_MAP.isEmpty()) {
            for (WavChunkType type : WavChunkType.values()) {
                CODE_TYPE_MAP.put(type.getCode(), type);
            }
        }
        return CODE_TYPE_MAP.get(code);
    }

    private WavChunkType(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public String getCode() {
        return this.code;
    }

    static {
        CODE_TYPE_MAP = new HashMap<String, WavChunkType>();
    }
}

