/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.aiff.chunk;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.jaudiotagger.audio.aiff.AiffAudioHeader;
import org.jaudiotagger.audio.aiff.AiffUtil;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.iff.Chunk;
import org.jaudiotagger.audio.iff.ChunkHeader;

public class CommentsChunk
extends Chunk {
    private static final int TIMESTAMP_LENGTH = 4;
    private static final int MARKERID_LENGTH = 2;
    private static final int COUNT_LENGTH = 2;
    private AiffAudioHeader aiffHeader;

    public CommentsChunk(ChunkHeader chunkHeader, ByteBuffer chunkData, AiffAudioHeader aiffAudioHeader) {
        super(chunkData, chunkHeader);
        this.aiffHeader = aiffAudioHeader;
    }

    @Override
    public boolean readChunk() throws IOException {
        int numComments = Utils.u(this.chunkData.getShort());
        for (int i = 0; i < numComments; ++i) {
            long timestamp = Utils.u(this.chunkData.getInt());
            Date jTimestamp = AiffUtil.timestampToDate(timestamp);
            int marker = Utils.u(this.chunkData.getShort());
            int count = Utils.u(this.chunkData.getShort());
            String text = Utils.getString(this.chunkData, 0, count, StandardCharsets.ISO_8859_1) + " " + AiffUtil.formatDate(jTimestamp);
            if (count % 2 != 0) {
                this.chunkData.get();
            }
            this.aiffHeader.addComment(text);
        }
        return true;
    }
}

