/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.highlight;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafMetaData;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.index.VectorValues;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.Version;

public class TermVectorLeafReader
extends LeafReader {
    private final Fields fields;
    private final FieldInfos fieldInfos;

    public TermVectorLeafReader(final String field, final Terms terms) {
        this.fields = new Fields(){

            public Iterator<String> iterator() {
                return Collections.singletonList(field).iterator();
            }

            public Terms terms(String fld) throws IOException {
                if (!field.equals(fld)) {
                    return null;
                }
                return terms;
            }

            public int size() {
                return 1;
            }
        };
        IndexOptions indexOptions = !terms.hasFreqs() ? IndexOptions.DOCS : (!terms.hasPositions() ? IndexOptions.DOCS_AND_FREQS : (!terms.hasOffsets() ? IndexOptions.DOCS_AND_FREQS_AND_POSITIONS : IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS));
        FieldInfo fieldInfo = new FieldInfo(field, 0, true, true, terms.hasPayloads(), indexOptions, DocValuesType.NONE, -1L, Collections.emptyMap(), 0, 0, 0, 0, VectorSimilarityFunction.EUCLIDEAN, false);
        this.fieldInfos = new FieldInfos(new FieldInfo[]{fieldInfo});
    }

    protected void doClose() throws IOException {
    }

    public Terms terms(String field) throws IOException {
        return this.fields.terms(field);
    }

    public NumericDocValues getNumericDocValues(String field) throws IOException {
        return null;
    }

    public BinaryDocValues getBinaryDocValues(String field) throws IOException {
        return null;
    }

    public SortedDocValues getSortedDocValues(String field) throws IOException {
        return null;
    }

    public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
        return null;
    }

    public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
        return null;
    }

    public NumericDocValues getNormValues(String field) throws IOException {
        return null;
    }

    public FieldInfos getFieldInfos() {
        return this.fieldInfos;
    }

    public Bits getLiveDocs() {
        return null;
    }

    public PointValues getPointValues(String fieldName) {
        return null;
    }

    public VectorValues getVectorValues(String fieldName) {
        return null;
    }

    public TopDocs searchNearestVectors(String field, float[] target, int k, Bits acceptDocs) {
        return null;
    }

    public void checkIntegrity() throws IOException {
    }

    public Fields getTermVectors(int docID) throws IOException {
        if (docID != 0) {
            return null;
        }
        return this.fields;
    }

    public int numDocs() {
        return 1;
    }

    public int maxDoc() {
        return 1;
    }

    public void document(int docID, StoredFieldVisitor visitor) throws IOException {
    }

    public LeafMetaData getMetaData() {
        return new LeafMetaData(Version.LATEST.major, null, null);
    }

    public IndexReader.CacheHelper getCoreCacheHelper() {
        return null;
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return null;
    }
}

