/*
 * Decompiled with CFR 0.152.
 */
package traer.physics;

import traer.physics.Force;
import traer.physics.Particle;
import traer.physics.Vector3D;

public class Spring
implements Force {
    float springConstant;
    float damping;
    float restLength;
    Particle a;
    Particle b;
    boolean on;

    public Spring(Particle A, Particle B, float ks, float d, float r) {
        this.springConstant = ks;
        this.damping = d;
        this.restLength = r;
        this.a = A;
        this.b = B;
        this.on = true;
    }

    public final void turnOff() {
        this.on = false;
    }

    public final void turnOn() {
        this.on = true;
    }

    public final boolean isOn() {
        return this.on;
    }

    public final boolean isOff() {
        return !this.on;
    }

    public final Particle getOneEnd() {
        return this.a;
    }

    public final Particle getTheOtherEnd() {
        return this.b;
    }

    public final float currentLength() {
        return this.a.position().distanceTo(this.b.position());
    }

    public final float restLength() {
        return this.restLength;
    }

    public final float strength() {
        return this.springConstant;
    }

    public final void setStrength(float ks) {
        this.springConstant = ks;
    }

    public final float damping() {
        return this.damping;
    }

    public final void setDamping(float d) {
        this.damping = d;
    }

    public final void setRestLength(float l) {
        this.restLength = l;
    }

    public final void apply() {
        if (this.on) {
            float a2bX = this.a.position().x - this.b.position().x;
            float a2bY = this.a.position().y - this.b.position().y;
            float a2bZ = this.a.position().z - this.b.position().z;
            float oneOvera2bDistance = Vector3D.fastInverseSqrt(a2bX * a2bX + a2bY * a2bY + a2bZ * a2bZ);
            float a2bDistance = 1.0f / oneOvera2bDistance;
            if (a2bDistance == 0.0f) {
                a2bX = 0.0f;
                a2bY = 0.0f;
                a2bZ = 0.0f;
            } else {
                a2bX *= oneOvera2bDistance;
                a2bY *= oneOvera2bDistance;
                a2bZ *= oneOvera2bDistance;
            }
            float springForce = -(a2bDistance - this.restLength) * this.springConstant;
            float Va2bX = this.a.velocity().x - this.b.velocity().x;
            float Va2bY = this.a.velocity().y - this.b.velocity().y;
            float Va2bZ = this.a.velocity().z - this.b.velocity().z;
            float dampingForce = -this.damping * (a2bX * Va2bX + a2bY * Va2bY + a2bZ * Va2bZ);
            float r = springForce + dampingForce;
            a2bX *= r;
            a2bY *= r;
            a2bZ *= r;
            if (this.a.isFree()) {
                this.a.force().add(a2bX, a2bY, a2bZ);
            }
            if (this.b.isFree()) {
                this.b.force().add(-a2bX, -a2bY, -a2bZ);
            }
        }
    }

    public final boolean hasDead() {
        return this.a.isDead() || this.b.isDead();
    }
}

