/*
 * Decompiled with CFR 0.152.
 */
package org.openzim;

import com.github.luben.zstd.ZstdInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openzim.RandomAccessFileZIMInputStream;
import org.openzim.ZIMFile;
import org.tukaani.xz.SingleXZInputStream;

public class ZIMReader {
    private static final int MAX_CLUSTER_CACHE_SIZE = 100;
    public static final String[] METADATA_KEYS = new String[]{"Name", "Title", "Creator", "Publisher", "Date", "Description", "LongDescription", "Language", "License", "Tags", "Relation", "Flavour", "Source", "Counter", "Scraper"};
    private final ZIMFile mFile;
    private List<ArticleEntry> allArticlesCache = null;
    private Map<Integer, Map<Integer, ArticleEntry>> indexedArticlesCache = null;
    private final ArrayList<Cluster> clusterCache = new ArrayList();

    public ZIMReader(ZIMFile file) {
        this.mFile = file;
    }

    public ZIMFile getZIMFile() {
        return this.mFile;
    }

    public List<ArticleEntry> getAllArticles() throws IOException {
        if (this.allArticlesCache != null) {
            return this.allArticlesCache;
        }
        ArrayList<ArticleEntry> list2 = new ArrayList<ArticleEntry>();
        for (int i = 0; i < this.mFile.header_entryCount; ++i) {
            DirectoryEntry de = this.getDirectoryInfo(i);
            if (!(de instanceof ArticleEntry)) continue;
            list2.add((ArticleEntry)de);
        }
        this.allArticlesCache = list2;
        return list2;
    }

    public Map<Integer, Map<Integer, ArticleEntry>> getIndexedArticles(List<ArticleEntry> list2) {
        if (this.indexedArticlesCache != null) {
            return this.indexedArticlesCache;
        }
        HashMap<Integer, Map<Integer, ArticleEntry>> index2 = new HashMap<Integer, Map<Integer, ArticleEntry>>();
        for (ArticleEntry entry2 : list2) {
            HashMap<Integer, ArticleEntry> cluster = (HashMap<Integer, ArticleEntry>)index2.get(entry2.cluster_number);
            if (cluster == null) {
                cluster = new HashMap<Integer, ArticleEntry>();
                index2.put(entry2.cluster_number, cluster);
            }
            cluster.put(entry2.blob_number, entry2);
        }
        this.indexedArticlesCache = index2;
        return index2;
    }

    public final String getMetadata(String key) throws IOException {
        DirectoryEntry de = this.getDirectoryInfo('M', key);
        if (de == null) {
            return null;
        }
        byte[] val = this.getArticleData(de);
        if (val == null) {
            return null;
        }
        if (val.length == 0) {
            return null;
        }
        return new String(val, StandardCharsets.UTF_8);
    }

    public DirectoryEntry getMainDirectoryEntry() throws IOException {
        DirectoryEntry de = this.getDirectoryInfo(this.mFile.header_mainPage);
        if (de instanceof RedirectEntry) {
            int redirect = ((RedirectEntry)de).redirect_index;
            de = this.getDirectoryInfo(redirect);
        }
        for (int entryNumner = 0; !de.getMimeType().equals("text/html") && entryNumner < this.mFile.header_entryCount; ++entryNumner) {
            de = this.getDirectoryInfo(entryNumner);
            if (de.namespace != 'C' && de.namespace != 'A' || !(de instanceof ArticleEntry) || !de.getMimeType().equals("text/html") || de.url.contains("404") || de.title.contains("404") || de.title.contains("301")) continue;
            return de;
        }
        return de;
    }

    public String getURLByURLOrder(int entryNumber) throws IOException {
        long pos = this.mFile.getURLPtr(entryNumber);
        this.mFile.mReader.seek(pos);
        int mimeType = this.mFile.mReader.readTwoLittleEndianBytesInt();
        if (mimeType == 65535) {
            this.mFile.mReader.seek(pos + 12L);
            return this.mFile.mReader.readZeroTerminatedString();
        }
        this.mFile.mReader.seek(pos + 16L);
        return this.mFile.mReader.readZeroTerminatedString();
    }

    public String getURLByTitleOrder(int entryNumber) throws IOException {
        int articleNumber = this.mFile.getTitlePtr(entryNumber);
        return this.getURLByURLOrder(articleNumber);
    }

    public DirectoryEntry getDirectoryInfo(int entryNumber) throws IOException {
        int pointer_to_the_URL_pointer = this.mFile.getTitlePtr(entryNumber);
        long pointer_to_the_directory_entry = this.mFile.getURLPtr(pointer_to_the_URL_pointer);
        this.mFile.mReader.seek(pointer_to_the_directory_entry);
        int type = this.mFile.mReader.readTwoLittleEndianBytesInt();
        this.mFile.mReader.read();
        char namespace = (char)this.mFile.mReader.read();
        this.mFile.mReader.readFourLittleEndianBytesInt();
        if (type == 65535) {
            int redirectIndex = this.mFile.mReader.readFourLittleEndianBytesInt();
            String url = this.mFile.mReader.readZeroTerminatedString();
            String title = this.mFile.mReader.readZeroTerminatedString();
            title = title.equals("") ? url : title;
            return new RedirectEntry(entryNumber, namespace, url, title, type, redirectIndex);
        }
        int cluster_number = this.mFile.mReader.readFourLittleEndianBytesInt();
        int blob_number = this.mFile.mReader.readFourLittleEndianBytesInt();
        String url = this.mFile.mReader.readZeroTerminatedString();
        String title = this.mFile.mReader.readZeroTerminatedString();
        title = title.equals("") ? url : title;
        return new ArticleEntry(entryNumber, namespace, url, title, type, cluster_number, blob_number);
    }

    public DirectoryEntry getDirectoryInfo(char namespace, String articleName) throws IOException {
        int numberOfArticles = this.mFile.header_entryCount;
        int beg = 0;
        int end = numberOfArticles;
        articleName = namespace + "/" + (String)articleName;
        while (beg <= end) {
            int mid = beg + (end - beg) / 2;
            DirectoryEntry entry2 = this.getDirectoryInfo(mid);
            if (entry2 == null) {
                return null;
            }
            String cmpStr = entry2.namespace + "/" + entry2.title;
            if (((String)articleName).compareTo(cmpStr) < 0) {
                end = mid - 1;
                continue;
            }
            if (((String)articleName).compareTo(cmpStr) > 0) {
                beg = mid + 1;
                continue;
            }
            return entry2;
        }
        return null;
    }

    public Cluster getCluster(int clusterNumber) throws IOException {
        for (int i = 0; i < this.clusterCache.size(); ++i) {
            Cluster c = this.clusterCache.get(i);
            if (c.cluster_number != clusterNumber) continue;
            return c;
        }
        Cluster c = new Cluster(clusterNumber);
        if (this.clusterCache.size() >= 100) {
            this.clusterCache.remove(0);
        }
        this.clusterCache.add(c);
        return c;
    }

    public byte[] getArticleData(DirectoryEntry directoryInfo) throws IOException {
        if (directoryInfo == null) {
            return null;
        }
        if (directoryInfo.getClass() != ArticleEntry.class) {
            return null;
        }
        ArticleEntry article = (ArticleEntry)directoryInfo;
        Cluster c = this.getCluster(article.cluster_number);
        byte[] blob = c.getBlob(article.blob_number);
        return blob;
    }

    public class DirectoryEntry {
        private final int mimetype;
        public final char namespace;
        public final String url;
        public final String title;
        public final int urlListindex;

        public DirectoryEntry(int urlListindex, char namespace, String url, String title, int mimeType) {
            assert (url != null);
            assert (title != null);
            this.mimetype = mimeType;
            this.namespace = namespace;
            this.url = url;
            this.title = title;
            this.urlListindex = urlListindex;
        }

        public String getMimeType() {
            return ZIMReader.this.mFile.getMimeType(this.mimetype);
        }
    }

    public class ArticleEntry
    extends DirectoryEntry {
        public final int cluster_number;
        public final int blob_number;

        public ArticleEntry(int urlListindex, char namespace, String url, String title, int mimeType, int cluster_number, int blob_number) {
            super(urlListindex, namespace, url, title, mimeType);
            this.cluster_number = cluster_number;
            this.blob_number = blob_number;
        }
    }

    public class RedirectEntry
    extends DirectoryEntry {
        public final int redirect_index;

        public RedirectEntry(int urlListindex, char namespace, String url, String title, int mimeType, int redirect_index) {
            super(urlListindex, namespace, url, title, mimeType);
            this.redirect_index = redirect_index;
        }
    }

    private class Cluster {
        private int cluster_number;
        private List<byte[]> blobs;
        private boolean extended;

        public Cluster(int cluster_number) throws IOException {
            int i;
            this.cluster_number = cluster_number;
            long clusterPos = ZIMReader.this.mFile.geClusterPtr(cluster_number);
            ZIMReader.this.mFile.mReader.seek(clusterPos);
            int compressionType = ZIMReader.this.mFile.mReader.read();
            RandomAccessFileZIMInputStream is = null;
            if (compressionType <= 1 || compressionType == 8 || compressionType == 9) {
                this.extended = compressionType > 1;
                is = ZIMReader.this.mFile.mReader;
            }
            if (compressionType == 4 || compressionType == 12) {
                this.extended = compressionType == 12;
                is = new SingleXZInputStream((InputStream)ZIMReader.this.mFile.mReader, 0x2800000);
            }
            if (compressionType == 5 || compressionType == 13) {
                this.extended = compressionType == 13;
                is = new ZstdInputStream((InputStream)ZIMReader.this.mFile.mReader);
            }
            if (is == null) {
                throw new IOException("compression type unknown: " + compressionType);
            }
            ArrayList<Long> offsets = new ArrayList<Long>();
            byte[] buffer = new byte[this.extended ? 8 : 4];
            is.read(buffer);
            long end_offset = this.extended ? RandomAccessFileZIMInputStream.toEightLittleEndianLong(buffer) : (long)RandomAccessFileZIMInputStream.toFourLittleEndianInteger(buffer);
            offsets.add(end_offset);
            int offset_count = (int)(end_offset / (long)(this.extended ? 8 : 4));
            for (i = 0; i < offset_count - 1; ++i) {
                is.read(buffer);
                long l = this.extended ? RandomAccessFileZIMInputStream.toEightLittleEndianLong(buffer) : (long)RandomAccessFileZIMInputStream.toFourLittleEndianInteger(buffer);
                offsets.add(l);
            }
            this.blobs = new ArrayList<byte[]>();
            for (i = 0; i < offsets.size() - 1; ++i) {
                int length = (int)((Long)offsets.get(i + 1) - (Long)offsets.get(i));
                byte[] b = new byte[length];
                RandomAccessFileZIMInputStream.readFully((InputStream)is, b);
                this.blobs.add(b);
            }
        }

        public byte[] getBlob(int i) {
            return this.blobs.get(i);
        }

        public int getSize() {
            return this.blobs.size();
        }
    }

    public class ClusterIterator
    implements Iterator<ArticleBlobEntry> {
        private Map<Integer, Map<Integer, ArticleEntry>> index;
        private Cluster cluster;
        private int clusterCounter;
        private int blobCounter;

        public ClusterIterator() throws IOException {
            List<ArticleEntry> list2 = ZIMReader.this.getAllArticles();
            this.index = ZIMReader.this.getIndexedArticles(list2);
            this.clusterCounter = 0;
            this.blobCounter = 0;
            this.cluster = null;
        }

        private final void loadCluster() {
            if (this.cluster == null) {
                try {
                    this.cluster = new Cluster(this.clusterCounter);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public boolean hasNext() {
            if (this.clusterCounter >= ZIMReader.this.mFile.header_clusterCount) {
                return false;
            }
            this.loadCluster();
            return this.blobCounter < this.cluster.blobs.size();
        }

        @Override
        public ArticleBlobEntry next() {
            Map<Integer, ArticleEntry> clusterMap = this.index.get(this.clusterCounter);
            ArticleEntry ae = clusterMap.get(this.blobCounter);
            this.loadCluster();
            ArticleBlobEntry abe = new ArticleBlobEntry(ae, this.cluster.getBlob(this.blobCounter));
            ++this.blobCounter;
            if (this.blobCounter >= this.cluster.blobs.size()) {
                ++this.clusterCounter;
                this.cluster = null;
                this.blobCounter = 0;
            }
            return abe;
        }
    }

    public class ArticleBlobEntry {
        public final ArticleEntry article;
        public final byte[] blob;

        public ArticleBlobEntry(ArticleEntry article, byte[] blob) {
            assert (article != null);
            assert (blob != null);
            this.article = article;
            this.blob = blob;
        }
    }
}

