/*
 * Decompiled with CFR 0.152.
 */
package org.openzim;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import org.openzim.RandomAccessFileZIMInputStream;

public class ZIMFile
extends File {
    private static final long serialVersionUID = 1L;
    public final int header_magicNumber;
    public final int header_majorVersion;
    public final int header_minorVersion;
    public final int header_entryCount;
    public final int header_clusterCount;
    private final long header_urlPtrPos;
    private final long header_titlePtrPos;
    private final long header_clusterPtrPos;
    public final long header_mimeListPos;
    public final int header_mainPage;
    public final int header_layoutPage;
    public final long header_checksumPos;
    public final RandomAccessFileZIMInputStream mReader;
    private final String[] mimeTypeList;
    private final byte[] urlPtrListBlob;
    private final byte[] titlePtrListBlob;
    private final byte[] clusterPtrListBlob;

    public ZIMFile(String path) throws IOException {
        super(path);
        if (!this.exists()) {
            throw new FileNotFoundException("The file that you specified was not found.");
        }
        this.mReader = new RandomAccessFileZIMInputStream(new RandomAccessFile(this, "r"));
        this.header_magicNumber = this.mReader.readFourLittleEndianBytesInt();
        this.header_majorVersion = this.mReader.readTwoLittleEndianBytesInt();
        this.header_minorVersion = this.mReader.readTwoLittleEndianBytesInt();
        RandomAccessFileZIMInputStream.skipFully(this.mReader, 16L);
        this.header_entryCount = this.mReader.readFourLittleEndianBytesInt();
        this.header_clusterCount = this.mReader.readFourLittleEndianBytesInt();
        this.header_urlPtrPos = this.mReader.readEightLittleEndianBytesLong();
        this.header_titlePtrPos = this.mReader.readEightLittleEndianBytesLong();
        this.header_clusterPtrPos = this.mReader.readEightLittleEndianBytesLong();
        this.header_mimeListPos = this.mReader.readEightLittleEndianBytesLong();
        this.header_mainPage = this.mReader.readFourLittleEndianBytesInt();
        this.header_layoutPage = this.mReader.readFourLittleEndianBytesInt();
        this.header_checksumPos = this.mReader.readEightLittleEndianBytesLong();
        int len = 0;
        StringBuffer mimeBuffer = null;
        ArrayList<String> mList = new ArrayList<String>();
        while (true) {
            int b = this.mReader.read();
            len = 0;
            mimeBuffer = new StringBuffer();
            while (b != 0) {
                mimeBuffer.append((char)b);
                b = this.mReader.read();
                ++len;
            }
            if (len == 0) break;
            String mimeType = mimeBuffer.toString();
            mList.add(mimeType);
        }
        this.mimeTypeList = mList.toArray(new String[mList.size()]);
        try {
            this.urlPtrListBlob = new byte[this.header_entryCount * 8];
            this.mReader.seek(this.header_urlPtrPos);
            RandomAccessFileZIMInputStream.readFully((InputStream)this.mReader, this.urlPtrListBlob);
            this.titlePtrListBlob = new byte[this.header_entryCount * 4];
            this.mReader.seek(this.header_titlePtrPos);
            RandomAccessFileZIMInputStream.readFully((InputStream)this.mReader, this.titlePtrListBlob);
            this.clusterPtrListBlob = new byte[this.header_clusterCount * 8];
            this.mReader.seek(this.header_clusterPtrPos);
            RandomAccessFileZIMInputStream.readFully((InputStream)this.mReader, this.clusterPtrListBlob);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IOException(e.getMessage());
        }
    }

    public final String getMimeType(int idx2) {
        if (idx2 >= this.mimeTypeList.length) {
            return "";
        }
        return this.mimeTypeList[idx2];
    }

    public final long getURLPtr(int idx2) {
        return RandomAccessFileZIMInputStream.toEightLittleEndianLong(this.urlPtrListBlob, idx2 * 8);
    }

    public final int getTitlePtr(int idx2) {
        return RandomAccessFileZIMInputStream.toFourLittleEndianInteger(this.titlePtrListBlob, idx2 * 4);
    }

    public final long geClusterPtr(int idx2) {
        return RandomAccessFileZIMInputStream.toEightLittleEndianLong(this.clusterPtrListBlob, idx2 * 8);
    }
}

