/*
 * Decompiled with CFR 0.152.
 */
package org.openzim;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class RandomAccessFileZIMInputStream
extends InputStream {
    private final RandomAccessFile mRAFReader;
    private long mMarked = -1L;
    private final byte[] buffer2 = new byte[2];
    private final byte[] buffer4 = new byte[4];
    private final byte[] buffer8 = new byte[8];

    public RandomAccessFileZIMInputStream(RandomAccessFile reader) {
        this.mRAFReader = reader;
    }

    public int readTwoLittleEndianBytesInt() throws IOException {
        this.mRAFReader.read(this.buffer2, 0, 2);
        return RandomAccessFileZIMInputStream.toTwoLittleEndianInteger(this.buffer2);
    }

    public int readFourLittleEndianBytesInt() throws IOException {
        this.mRAFReader.read(this.buffer4, 0, 4);
        return RandomAccessFileZIMInputStream.toFourLittleEndianInteger(this.buffer4);
    }

    public long readEightLittleEndianBytesLong() throws IOException {
        this.mRAFReader.read(this.buffer8, 0, 8);
        return RandomAccessFileZIMInputStream.toEightLittleEndianLong(this.buffer8);
    }

    private static int toTwoLittleEndianInteger(byte[] buffer) {
        return buffer[0] & 0xFF | (buffer[1] & 0xFF) << 8;
    }

    public static int toFourLittleEndianInteger(byte[] buffer) {
        return buffer[0] & 0xFF | (buffer[1] & 0xFF) << 8 | (buffer[2] & 0xFF) << 16 | (buffer[3] & 0xFF) << 24;
    }

    public static int toFourLittleEndianInteger(byte[] buffer, int pos) {
        return buffer[pos] & 0xFF | (buffer[pos + 1] & 0xFF) << 8 | (buffer[pos + 2] & 0xFF) << 16 | (buffer[pos + 3] & 0xFF) << 24;
    }

    public static long toEightLittleEndianLong(byte[] buffer) {
        return (long)(buffer[0] & 0xFF) | (long)(buffer[1] & 0xFF) << 8 | (long)(buffer[2] & 0xFF) << 16 | (long)(buffer[3] & 0xFF) << 24 | (long)(buffer[4] & 0xFF) << 32 | (long)(buffer[5] & 0xFF) << 40 | (long)(buffer[6] & 0xFF) << 48 | (long)(buffer[7] & 0xFF) << 56;
    }

    public static long toEightLittleEndianLong(byte[] buffer, int pos) {
        return (long)(buffer[pos] & 0xFF) | (long)(buffer[pos + 1] & 0xFF) << 8 | (long)(buffer[pos + 2] & 0xFF) << 16 | (long)(buffer[pos + 3] & 0xFF) << 24 | (long)(buffer[pos + 4] & 0xFF) << 32 | (long)(buffer[pos + 5] & 0xFF) << 40 | (long)(buffer[pos + 6] & 0xFF) << 48 | (long)(buffer[pos + 7] & 0xFF) << 56;
    }

    public static void skipFully(InputStream stream, long bytes) throws IOException {
        for (long i = stream.skip(bytes); i < bytes; i += stream.skip(bytes - i)) {
        }
    }

    public String readZeroTerminatedString() throws IOException {
        int b;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        while ((b = this.mRAFReader.read()) != 0 && b != -1) {
            buffer.write(b);
        }
        return buffer.toString("UTF-8");
    }

    @Override
    public int read() throws IOException {
        return this.mRAFReader.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.mRAFReader.read(b, off, len);
    }

    public static byte[] readFully(InputStream is, int len) throws IOException {
        byte[] b = new byte[len];
        for (int c = 0; c < len; c += is.read(b, c, len - c)) {
        }
        return b;
    }

    public static void readFully(InputStream is, byte[] b) throws IOException {
        for (int c = 0; c < b.length; c += is.read(b, c, b.length - c)) {
        }
    }

    public RandomAccessFile getRandomAccessFile() {
        return this.mRAFReader;
    }

    public void seek(long pos) throws IOException {
        this.mRAFReader.seek(pos);
    }

    public long getFilePointer() throws IOException {
        return this.mRAFReader.getFilePointer();
    }

    public void mark() throws IOException {
        this.mMarked = this.mRAFReader.getFilePointer();
    }

    @Override
    public void reset() throws IOException {
        if (this.mMarked == -1L) {
            return;
        }
        this.mRAFReader.seek(this.mMarked);
        this.mMarked = -1L;
    }
}

