/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.visualization;

import java.io.File;
import java.io.IOException;
import net.yacy.visualization.PrintTool;
import net.yacy.visualization.RasterPlotter;

public class TelemetryOrbitalSweepPlotter
extends RasterPlotter {
    private final int centerX;
    private final int centerY;
    private final int baseRadius;
    private final double[] satelliteAngles;
    private final int[] satelliteRadii;

    public TelemetryOrbitalSweepPlotter(int width, int height) {
        super(width, height, RasterPlotter.DrawMode.MODE_REPLACE, 18L);
        this.centerX = width / 2;
        this.centerY = height / 2;
        this.baseRadius = Math.min(width, height) / 3;
        this.satelliteAngles = new double[]{15.0, 80.0, 130.0, 210.0, 275.0, 330.0};
        this.satelliteRadii = new int[]{this.baseRadius - 20, this.baseRadius + 40, this.baseRadius + 90, this.baseRadius - 50, this.baseRadius + 60, this.baseRadius + 10};
    }

    public void renderFrame(int frame) {
        this.clear();
        this.drawBackgroundGrid();
        this.drawOrbits(frame);
        this.drawSatellites(frame);
        this.drawOverlay(frame);
    }

    private void drawBackgroundGrid() {
        this.setColor(6707L);
        for (int r = 30; r <= this.baseRadius + 140; r += 30) {
            this.arc(this.centerX, this.centerY, r - 3, r, 20);
        }
        this.setColor(10820L);
        for (int a = 0; a < 360; a += 10) {
            this.line(this.centerX, this.centerY, this.centerX + (int)(Math.cos(Math.toRadians(a)) * (double)(this.baseRadius + 150)), this.centerY + (int)(-Math.sin(Math.toRadians(a)) * (double)(this.baseRadius + 150)), 15);
        }
    }

    private void drawOrbits(int frame) {
        double sweep = (double)(frame % 8) * 45.0;
        this.setColor(65484L);
        int outer = this.baseRadius + 120;
        this.arc(this.centerX, this.centerY, outer - 2, outer + 2, 30);
        this.arcLine(this.centerX, this.centerY, 40, outer, sweep, true, null, null, -1, -1, -1, false);
        this.arcLine(this.centerX, this.centerY, 40, outer, sweep - 12.0, true, null, null, -1, -1, -1, false);
        this.setColor(43758L);
        for (int r = this.baseRadius - 20; r <= this.baseRadius + 90; r += 40) {
            this.arc(this.centerX, this.centerY, r - 1, r + 1, 40);
        }
    }

    private void drawSatellites(int frame) {
        double sweep = (double)(frame % 8) * 45.0;
        for (int i = 0; i < this.satelliteAngles.length; ++i) {
            double angle = this.satelliteAngles[i] + (double)(frame * (i + 1)) * 2.5;
            int radius = this.satelliteRadii[i];
            int x = this.centerX + (int)Math.round(Math.cos(Math.toRadians(angle)) * (double)radius);
            int y = this.centerY - (int)Math.round(Math.sin(Math.toRadians(angle)) * (double)radius);
            long color = i % 2 == 0 ? 0x66FFEEL : 0xFF66CCL;
            this.setColor(color);
            this.dot(x, y, 6, true, 90);
            this.setColor(TelemetryOrbitalSweepPlotter.lighten(color, 1.6));
            this.dot(x, y, 2, true, 100);
            this.setColor(color);
            this.arcLine(this.centerX, this.centerY, radius - 12, radius, angle, true, null, null, -1, -1, -1, false);
        }
        this.setColor(65450L);
        int pulseRadius = this.baseRadius + (int)(Math.sin(Math.toRadians(sweep * 3.0)) * 12.0);
        this.arc(this.centerX, this.centerY, pulseRadius - 1, pulseRadius + 1, 50);
    }

    private void drawOverlay(int frame) {
        this.setColor(0x66FFFFL);
        PrintTool.print5(this, 6, 12, 0, "ORBITAL TELEMETRY", -1, 80);
        PrintTool.print5(this, 6, 22, 0, String.format("SWEEP:%03d", frame * 45 % 360), -1, 70);
        this.setColor(52479L);
        PrintTool.print5(this, this.getWidth() - 6, 12, 0, "ALT/KM", 1, 70);
        PrintTool.print5(this, this.getWidth() - 6, 22, 0, "VEL/MPS", 1, 70);
        int statusY = this.getHeight() - 18;
        this.setColor(65450L);
        PrintTool.print5(this, 6, statusY, 0, "LOCK", -1, 70);
        this.setColor(0xFF66CCL);
        PrintTool.print5(this, 70, statusY, 0, "TRACK", -1, 60);
        this.setColor(56831L);
        PrintTool.print5(this, this.getWidth() - 6, statusY, 0, "SIG" + frame % 8, 1, 60);
    }

    public static void main(String[] args) {
        File dir;
        System.setProperty("java.awt.headless", "true");
        File file = dir = args.length > 0 ? new File(args[0]) : new File(".");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        TelemetryOrbitalSweepPlotter plotter = new TelemetryOrbitalSweepPlotter(480, 480);
        for (int frame = 0; frame < 8; ++frame) {
            plotter.renderFrame(frame);
            File out = new File(dir, String.format("telemetry_orbit_%02d.png", frame));
            try {
                plotter.save(out, "png");
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to save orbital frame", e);
            }
        }
    }
}

